/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.docs;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.ruby.internal.ui.docs.WatchdogListener;

public class Watchdog
implements Runnable {
    private ListenerList timeoutListeners = new ListenerList();
    private final long timeout;
    private boolean stopped = false;

    public Watchdog(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout lesser than 1.");
        }
        this.timeout = timeout;
    }

    public void addListener(WatchdogListener listener) {
        this.timeoutListeners.add((Object)listener);
    }

    public void removeListener(WatchdogListener listener) {
        this.timeoutListeners.remove((Object)listener);
    }

    protected final void fireTimeoutOccured() {
        Object[] listeners = this.timeoutListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((WatchdogListener)listeners[i]).timeoutOccured();
            ++i;
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        long now;
        long until = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && until > (now = System.currentTimeMillis())) {
            try {
                this.wait(until - now);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.stopped) {
            this.fireTimeoutOccured();
        }
    }
}

