/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser.raw;

import org.eclipse.dltk.tcl.internal.parser.raw.ErrorDescription;
import org.eclipse.dltk.tcl.internal.parser.raw.ICodeScanner;
import org.eclipse.dltk.tcl.internal.parser.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.IWordSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.Messages;
import org.eclipse.dltk.tcl.internal.parser.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclTextUtils;

public class BracesSubstitution
extends TclElement
implements ISubstitution,
IWordSubstitution {
    public static boolean iAm(ICodeScanner scanner) {
        int c = scanner.read();
        if (c == -1) {
            return false;
        }
        scanner.unread();
        return c == 123;
    }

    public boolean readMe(ICodeScanner input, SimpleTclParser parser) throws TclParseException {
        if (!BracesSubstitution.iAm(input)) {
            return false;
        }
        this.setStart(input.getPosition());
        input.read();
        int nest = 1;
        while (nest > 0) {
            int c = input.read();
            if (c == -1) {
                parser.handleError(new ErrorDescription(Messages.BracesSubstitution_Error, this.getStart(), input.getPosition(), 0));
                break;
            }
            if (c == 92) {
                c = input.read();
                if (c == 123 || c == 125) continue;
                if (c == 13) {
                    int c1 = input.read();
                    if (c1 == 10) {
                        while ((c = input.read()) != -1 && TclTextUtils.isTrueWhitespace(c)) {
                        }
                        input.unread();
                        continue;
                    }
                    input.unread();
                }
            }
            if (c == 123) {
                ++nest;
                continue;
            }
            if (c != 125) continue;
            --nest;
        }
        if (!input.isEOF()) {
            this.setEnd(input.getPosition() - 1);
        } else {
            this.setEnd(input.getPosition());
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append(this.getStart()).append("..").append(this.getEnd());
        sb.append("}");
        return sb.toString();
    }
}

