/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.handlers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.handlers.LaunchStatusDialog;
import org.eclipse.dltk.launching.ILaunchStatusHandler;
import org.eclipse.dltk.launching.ILaunchStatusHandlerExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchStatusHandler
implements ILaunchStatusHandler,
ILaunchStatusHandlerExtension {
    private IDebugTarget debugTarget;
    private final Object lock = new Object();
    private boolean disposed = false;
    private LaunchStatusDialog dialog = null;
    private boolean canceled = false;

    public void initialize(IDebugTarget target, IProgressMonitor monitor) {
        if (Display.getCurrent() != null) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " should be initialized in background threads only");
        }
        this.debugTarget = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDialogCreated() {
        Object object = this.lock;
        synchronized (object) {
            return this.dialog != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDisposed() {
        Object object = this.lock;
        synchronized (object) {
            return this.disposed;
        }
    }

    public void updateElapsedTime(long elapsedTime) {
        if (this.isDisposed()) {
            return;
        }
        this.asyncExec(() -> {
            LaunchStatusDialog d;
            if (!this.isDialogCreated()) {
                this.createDialog();
            }
            if ((d = this.dialog) != null) {
                d.updateElapsedTime(elapsedTime);
            }
        });
    }

    private void asyncExec(Runnable runnable) {
        DLTKDebugUIPlugin.getStandardDisplay().asyncExec(runnable);
    }

    protected void createDialog() {
        IProcess process;
        ILaunchConfiguration configuration;
        if (this.isDialogCreated()) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && PlatformUI.getWorkbench().getWorkbenchWindowCount() > 0) {
            window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        this.dialog = new LaunchStatusDialog(window != null ? window.getShell() : null, this);
        ILaunch launch = this.debugTarget.getLaunch();
        if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
            this.dialog.setLaunchName(configuration.getName());
        }
        String cmdLine = (process = this.debugTarget.getProcess()) != null ? process.getAttribute(IProcess.ATTR_CMDLINE) : null;
        this.dialog.setCommandLine(cmdLine);
        this.dialog.open();
    }

    protected void disposeDialog() {
        if (this.isDialogCreated()) {
            this.dialog.close();
            this.dialog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.disposed = true;
        }
        if (this.isDialogCreated()) {
            this.asyncExec(() -> this.disposeDialog());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.lock;
        synchronized (object) {
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.canceled = value;
        }
    }
}

