/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class BeginOfLineRule
implements IRule {
    private IToken token;
    private char start;

    public BeginOfLineRule(IToken token, char start) {
        this.token = token;
        this.start = start;
    }

    protected char[] getAdditional() {
        return new char[0];
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int beforeNewLine = 0;
        if (scanner.getColumn() > 0) {
            int i = scanner.getColumn();
            while (i > 0) {
                scanner.unread();
                int cc = scanner.read();
                scanner.unread();
                ++beforeNewLine;
                if ((char)cc == '\n' || (char)cc == '\r') break;
                if (!Character.isWhitespace((char)cc)) {
                    int j = 0;
                    while (j < beforeNewLine) {
                        scanner.read();
                        ++j;
                    }
                    return Token.UNDEFINED;
                }
                --i;
            }
        }
        int j = 0;
        while (j < beforeNewLine) {
            scanner.read();
            ++j;
        }
        if (scanner.read() == this.start) {
            int c;
            while ((char)(c = scanner.read()) != '\n' && (char)c != '\r' && c != -1) {
            }
            scanner.unread();
            return this.token;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

