/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.ExpressionList;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.python.parser.ast.expressions.ExtendedVariableReference;

public class PythonClassDeclaration
extends TypeDeclaration {
    public PythonClassDeclaration(DLTKToken nameDLTKToken, int start, int end) {
        super(nameDLTKToken, start, end);
    }

    public PythonClassDeclaration(DLTKToken dltk, DLTKToken dltk2) {
        super(dltk, dltk2.getColumn(), -1);
    }

    public void setParents(DLTKToken pStart, ExpressionList supers, DLTKToken pEnd) {
        ASTListNode s = new ASTListNode();
        s.getChilds().addAll(supers.getExpressions());
        s.setStart(supers.sourceStart());
        s.setEnd(supers.sourceEnd());
        this.setSuperClasses(s);
        this.setParentStart(pStart.getColumn());
        this.setParentEnd(pEnd.getColumn());
    }

    public List getSuperClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.fSuperClasses != null) {
            List superClasseExpressions = this.fSuperClasses.getChilds();
            for (Expression expr : superClasseExpressions) {
                if (expr instanceof SimpleReference) {
                    names.add(((SimpleReference)expr).getName());
                    continue;
                }
                if (!(expr instanceof ExtendedVariableReference)) continue;
                ExtendedVariableReference ref = (ExtendedVariableReference)expr;
                List exprs = ref.getExpressions();
                boolean notAllSR = false;
                for (Expression ex : exprs) {
                    if (ex instanceof SimpleReference) continue;
                    notAllSR = true;
                }
                if (notAllSR) continue;
                String name = "";
                boolean bFirst = true;
                for (Expression ex : exprs) {
                    if (bFirst) {
                        bFirst = false;
                    } else {
                        name = String.valueOf(name) + ".";
                    }
                    name = String.valueOf(name) + ((SimpleReference)ex).getName();
                }
                names.add(ref.getStringRepresentation());
            }
        }
        return names;
    }

    public void setBody(DLTKToken dltk, Block sa, int sourceEnd) {
        this.setBody(dltk.getColumn(), sa, sourceEnd);
        this.setEnd(sourceEnd);
    }
}

