/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPagesLocationsBlock;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPagesMessages;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageFinder;
import org.eclipse.dltk.tcl.ui.manpages.ManPageFolder;
import org.eclipse.dltk.tcl.ui.manpages.ManPageResource;
import org.eclipse.dltk.tcl.ui.manpages.ManpagesFactory;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.dialogs.TimeTriggeredProgressMonitorDialog;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManPagesLocationsDialog
extends StatusDialog
implements ModifyListener {
    private final boolean isNew;
    private final ManPageResource documentations;
    protected final Documentation documentation;
    private final Documentation input;
    private Text nameField;
    private TreeViewer pathViewer;
    private Button addButton;
    private Button removeButton;
    private int busyCounter = 0;

    public ManPagesLocationsDialog(Shell shell, ManPageResource documentations, Documentation documentation) {
        super(shell);
        this.documentations = documentations;
        this.input = documentation;
        this.isNew = documentation == null;
        this.documentation = documentation != null ? (Documentation)EcoreUtil.copy((EObject)documentation) : ManPagesLocationsDialog.newDocumentation();
        this.setTitle(this.isNew ? ManPagesMessages.ManPagesLocationsDialog_AddTtile : ManPagesMessages.ManPagesLocationsDialog_EditTitle);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private static Documentation newDocumentation() {
        Documentation value = ManpagesFactory.eINSTANCE.createDocumentation();
        value.setId(EcoreUtil.generateUUID());
        value.setName("");
        return value;
    }

    public Documentation getResult() {
        return this.documentation;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(dialogArea, 0);
        content.setLayoutData((Object)new GridData(1808));
        content.setLayout((Layout)new GridLayout(3, false));
        new Label(content, 0).setText(ManPagesMessages.ManPagesLocationsDialog_Name);
        this.nameField = new Text(content, 2048);
        GridData nameGD = new GridData(768);
        nameGD.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)nameGD);
        this.nameField.addModifyListener((ModifyListener)this);
        Label pathLabel = new Label(content, 0);
        pathLabel.setText(ManPagesMessages.ManPagesLocationsDialog_Paths);
        pathLabel.setLayoutData((Object)new GridData(34));
        Composite pathComp = new Composite(content, 0);
        pathComp.setLayoutData((Object)new GridData(1808));
        GridLayout pathLayout = new GridLayout(2, false);
        pathLayout.marginHeight = 0;
        pathLayout.marginWidth = 0;
        pathComp.setLayout((Layout)pathLayout);
        this.pathViewer = new TreeViewer(pathComp);
        this.pathViewer.setContentProvider((IContentProvider)new FolderContentProvider());
        this.pathViewer.setLabelProvider((IBaseLabelProvider)new FolderLabelProvider());
        this.pathViewer.setComparator(new ViewerComparator());
        GridData pathGD = new GridData(1808);
        pathGD.heightHint = this.convertHeightInCharsToPixels(16);
        pathGD.widthHint = this.convertWidthInCharsToPixels(64);
        this.pathViewer.getControl().setLayoutData((Object)pathGD);
        this.pathViewer.addSelectionChangedListener(event -> this.pathSelectionChanged());
        Composite buttonComp = new Composite(pathComp, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonComp.setLayout((Layout)buttonLayout);
        buttonComp.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonComp, 8);
        ManPagesLocationsBlock.setButtonLayoutData(this.addButton);
        this.addButton.setText(ManPagesMessages.ManPagesLocationsDialog_AddButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManPagesLocationsDialog.this.doAdd();
            }
        });
        this.removeButton = new Button(buttonComp, 8);
        ManPagesLocationsBlock.setButtonLayoutData(this.removeButton);
        this.removeButton.setText(ManPagesMessages.ManPagesLocationsDialog_RemoveButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ManPagesLocationsDialog.this.getSelection();
                if (ManPagesLocationsDialog.this.canRemove(selection)) {
                    ManPagesLocationsDialog.this.doRemove(selection);
                }
            }
        });
        this.getData(this.documentation);
        return dialogArea;
    }

    protected void doAdd() {
        File file;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(ManPagesMessages.ManPagesLocationsDialog_6);
        String result = dialog.open();
        if (result != null && (file = new File(result)).isDirectory()) {
            TimeTriggeredProgressMonitorDialog dialog2 = new TimeTriggeredProgressMonitorDialog(null, 500);
            try {
                dialog2.run(true, true, monitor -> {
                    monitor.beginTask(ManPagesMessages.ManPagesLocationsDialog_7, 1);
                    ManPageFinder finder = new ManPageFinder();
                    finder.find(this.documentation, file);
                    monitor.done();
                });
            }
            catch (InvocationTargetException e) {
                TclUI.error(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pathViewer.refresh();
            this.updateStatus();
        }
    }

    protected void doRemove(IStructuredSelection selection) {
        for (Object obj : selection) {
            if (!(obj instanceof ManPageFolder)) continue;
            EcoreUtil.remove((EObject)((EObject)obj));
        }
        this.pathViewer.refresh();
        this.updateStatus();
    }

    protected void pathSelectionChanged() {
        IStructuredSelection selection = this.getSelection();
        this.removeButton.setEnabled(this.canRemove(selection));
    }

    private void getData(Documentation doc) {
        ++this.busyCounter;
        try {
            this.nameField.setText(doc.getName());
            this.pathViewer.setInput((Object)this.documentation);
        }
        finally {
            --this.busyCounter;
        }
    }

    private void setData(Documentation doc) {
        doc.setName(this.nameField.getText().trim());
    }

    protected void okPressed() {
        this.setData(this.documentation);
        if (this.isNew) {
            this.documentations.getContents().add((Object)this.documentation);
        } else {
            this.input.setName(this.documentation.getName());
            this.input.getFolders().clear();
            this.input.getFolders().addAll(this.documentation.getFolders());
        }
        super.okPressed();
    }

    public void modifyText(ModifyEvent e) {
        if (this.busyCounter > 0) {
            return;
        }
        this.updateStatus();
    }

    private void updateStatus() {
        this.updateStatus(this.validate());
    }

    private IStatus validate() {
        if (this.nameField.getText().trim().length() == 0) {
            return new StatusInfo(4, ManPagesMessages.ManPagesLocationsDialog_ErrorEmptyName);
        }
        if (this.documentation.getFolders().isEmpty()) {
            return new StatusInfo(4, ManPagesMessages.ManPagesLocationsDialog_ErrorNoFolders);
        }
        return StatusInfo.OK_STATUS;
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.pathViewer.getSelection();
    }

    protected boolean canRemove(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object obj : selection) {
            if (obj instanceof ManPageFolder) continue;
            return false;
        }
        return true;
    }

    static class FolderContentProvider
    implements ITreeContentProvider {
        FolderContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ManPageFolder) {
                ManPageFolder folder = (ManPageFolder)parentElement;
                EMap<String, String> keywords = folder.getKeywords();
                return keywords.toArray((Object[])new Map.Entry[keywords.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ManPageFolder) {
                ManPageFolder folder = (ManPageFolder)element;
                return !folder.getKeywords().isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Documentation) {
                Documentation doc = (Documentation)inputElement;
                EList<ManPageFolder> folders = doc.getFolders();
                return folders.toArray((Object[])new Object[folders.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class FolderLabelProvider
    extends LabelProvider {
        FolderLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ManPageFolder) {
                return ((ManPageFolder)element).getPath();
            }
            if (element instanceof EObject && element instanceof BasicEMap.Entry) {
                BasicEMap.Entry entry = (BasicEMap.Entry)element;
                return String.valueOf((String)entry.getKey()) + " (" + (String)entry.getValue() + ")";
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ManPageFolder) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_obj.png");
            }
            return DLTKUIPlugin.getImageDescriptorRegistry().get(DLTKPluginImages.DESC_OBJS_INFO_OBJ);
        }
    }
}

