/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.compiler.problem.ValidationStatus;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.osgi.util.NLS;

public class JavaScriptValidations {
    static final String ATTR_INCONSISTENT_RETURNS = String.valueOf(JavaScriptValidations.class.getName()) + ".INCONSISTENT_RETURNS";

    public static Script parse(IBuildContext context) {
        IModuleDeclaration declaration;
        IModuleDeclaration savedAST = (IModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (savedAST instanceof Script) {
            return (Script)savedAST;
        }
        ISourceModule module = context.getSourceModule();
        if (module != null && (declaration = SourceParserUtil.parse((ISourceModule)module, (IProblemReporter)context.getProblemReporter())) instanceof Script) {
            context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)declaration);
            return (Script)declaration;
        }
        JavaScriptParser parser = new JavaScriptParser();
        Script script = parser.parse((IModuleSource)context, context.getProblemReporter());
        context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)script);
        return script;
    }

    public static IRType typeOf(IValueReference reference) {
        if (reference != null) {
            if (reference.getDeclaredType() != null) {
                return reference.getDeclaredType();
            }
            JSTypeSet declaredTypes = reference.getDeclaredTypes();
            if (declaredTypes.size() == 1) {
                return declaredTypes.toRType();
            }
            return reference.getTypes().toRType();
        }
        return null;
    }

    public static Set<IRType> getTypes(IValueReference reference) {
        if (reference != null) {
            HashSet<IRType> set = new HashSet<IRType>(4);
            IRType declaredType = reference.getDeclaredType();
            if (declaredType != null) {
                set.add(declaredType);
            }
            for (IRType type : reference.getDeclaredTypes()) {
                set.add(type);
            }
            for (IRType type : reference.getTypes()) {
                set.add(type);
            }
            if (!set.isEmpty()) {
                return set;
            }
        }
        return Collections.emptySet();
    }

    protected static Reporter createReporter(IBuildContext context) {
        return new Reporter(context.getLineTracker(), context.getProblemReporter());
    }

    public static <METHOD extends IRMethod> METHOD selectMethod(List<METHOD> methods, IValueReference[] arguments, boolean fallback) {
        if (methods.size() == 1) {
            return (METHOD)((IRMethod)methods.get(0));
        }
        ArrayList<IRMethod> matches = null;
        for (IRMethod method : methods) {
            if (!JavaScriptValidations.checkParameterCount(method, arguments.length)) continue;
            if (matches == null) {
                matches = new ArrayList<IRMethod>(4);
            }
            matches.add(method);
        }
        if (matches != null) {
            IRMethod firstMatch = (IRMethod)matches.get(0);
            if (matches.size() == 1) {
                return (METHOD)firstMatch;
            }
            block1: for (IRMethod method : matches) {
                List<IRParameter> parameters = method.getParameters();
                int i = 0;
                while (i < Math.min(parameters.size(), arguments.length)) {
                    IRType argumentType;
                    IRType parameterType = ((IRParameter)parameters.get(i)).getType();
                    if (parameterType != null && (argumentType = JavaScriptValidations.typeOf(arguments[i])) != null && parameterType.isAssignableFrom(argumentType) == TypeCompatibility.FALSE) continue block1;
                    ++i;
                }
                return (METHOD)method;
            }
            if (!(firstMatch instanceof IRConstructor)) {
                Collection[] paramType = new Collection[firstMatch.getParameterCount()];
                for (IRMethod method : matches) {
                    List<IRParameter> parameters = method.getParameters();
                    int i = 0;
                    while (i < Math.min(arguments.length, parameters.size())) {
                        if (paramType[i] == null) {
                            paramType[i] = new ArrayList();
                        }
                        paramType[i].add(parameters.get(i).getType());
                        ++i;
                    }
                }
                List<IRParameter> parameters = firstMatch.getParameters();
                IRParameter[] params = new IRParameter[paramType.length];
                int i = 0;
                while (i < parameters.size()) {
                    IRParameter param = parameters.get(i);
                    params[i] = RModelBuilder.createParameter(param.getName(), RTypes.union(paramType[i]), param.getKind());
                    ++i;
                }
                return (METHOD)RModelBuilder.method(firstMatch.getName(), firstMatch.getType(), Arrays.asList(params), firstMatch.getVisibility(), firstMatch.getSource());
            }
        }
        return (METHOD)(fallback ? (IRMethod)methods.get(0) : null);
    }

    static boolean checkParameterCount(IRMethod method, int argCount) {
        List<IRParameter> params = method.getParameters();
        if (params.size() == argCount) {
            return true;
        }
        if (params.size() < argCount) {
            return !params.isEmpty() && params.get(params.size() - 1).getKind() == ParameterKind.VARARGS;
        }
        if (params.size() > argCount) {
            ParameterKind last = params.get(argCount).getKind();
            return last == ParameterKind.OPTIONAL || last == ParameterKind.VARARGS;
        }
        return false;
    }

    public static void reportValidationStatus(JSProblemReporter reporter, IValidationStatus result, ISourceNode node, JavaScriptProblems defaultProblemId, String defaultMessage, String name) {
        if (result instanceof ValidationStatus) {
            int end;
            int start;
            ValidationStatus status = (ValidationStatus)result;
            if (status.hasRange()) {
                start = status.start();
                end = status.end();
            } else {
                start = node.start();
                end = node.end();
            }
            reporter.reportProblem(status.identifier(), status.message(), start, end);
        } else if (result instanceof IProblemIdentifier) {
            reporter.reportProblem((IProblemIdentifier)result, NLS.bind((String)defaultMessage, (Object)name), node.start(), node.end());
        } else {
            if (result == ValidationStatus.OK) {
                return;
            }
            reporter.reportProblem((IProblemIdentifier)defaultProblemId, String.valueOf(NLS.bind((String)defaultMessage, (Object)name)) + ": " + result, node.start(), node.end());
        }
    }
}

