/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.internal.ui.TclInterpreterMessages;
import org.eclipse.dltk.tcl.internal.ui.preferences.ProjectBuildJob;
import org.eclipse.dltk.ui.dialogs.MultipleInputDialog;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;

final class TclGlobalVariableSourceCorrectionMarkerResolution
implements IMarkerResolution,
IAnnotationResolution {
    private String sourceName;
    private IScriptProject project;

    public TclGlobalVariableSourceCorrectionMarkerResolution(String pkgName, IScriptProject scriptProject) {
        this.sourceName = pkgName;
        this.project = scriptProject;
    }

    public String getLabel() {
        return "Add variable '" + this.sourceName + "' to list of project global variables";
    }

    private boolean resolve() {
        Map emap;
        MultipleInputDialog dialog = new MultipleInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TclInterpreterMessages.GlobalVariableBlock_AddTitle);
        dialog.addLabelField("Name: " + this.sourceName);
        dialog.addVariablesField("Value", null, true);
        if (dialog.open() != 0) {
            return false;
        }
        String value = dialog.getStringValue("Value");
        if (value != null && value.length() > 0 && !(emap = TclPackagesManager.getVariables((String)this.project.getElementName())).containsKey(this.sourceName)) {
            emap.put(this.sourceName, value);
            TclPackagesManager.setVariables((String)this.project.getElementName(), (Map)emap);
            new ProjectBuildJob(this.project.getProject()).schedule(500L);
        }
        return true;
    }

    public void run(IMarker marker) {
        this.resolve();
    }

    public void run(IScriptAnnotation annotation, IDocument document) {
        this.resolve();
    }
}

