/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser.raw;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.dltk.tcl.internal.parser.raw.BracesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.CodeScanner;
import org.eclipse.dltk.tcl.internal.parser.raw.CommandSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.ErrorDescription;
import org.eclipse.dltk.tcl.internal.parser.raw.ICodeScanner;
import org.eclipse.dltk.tcl.internal.parser.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.IWordSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.MagicBackslashSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.Messages;
import org.eclipse.dltk.tcl.internal.parser.raw.NormalBackslashSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.QuotesSubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.TclCommand;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parser.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parser.raw.TclScript;
import org.eclipse.dltk.tcl.internal.parser.raw.TclTextUtils;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWord;
import org.eclipse.dltk.tcl.internal.parser.raw.TclWordBuffer;
import org.eclipse.dltk.tcl.internal.parser.raw.VariableSubstitution;
import org.eclipse.dltk.tcl.parser.ITclErrorConstants;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;

public class SimpleTclParser {
    private ITclErrorReporter reporter = null;
    private boolean skipComments = true;
    private final int sourceOffset;
    private static final Pattern MAGIC_SUBSTITUTE = Pattern.compile("\\\\\\r*\\n\\s*");
    private static final TclCommand STOP = new TclCommand();
    private static final TclCommand STOP_EOF = new TclCommand();

    public void setProblemReporter(ITclErrorReporter reporter) {
        this.reporter = reporter;
    }

    public SimpleTclParser() {
        this(0);
    }

    public SimpleTclParser(int sourceOffset) {
        this.sourceOffset = sourceOffset;
    }

    public boolean handleError(ErrorDescription error) {
        if (this.reporter != null) {
            this.reporter.report(0, error.getMessage(), null, this.sourceOffset + error.getPosition(), this.sourceOffset + error.getEnd() + 1, ITclErrorConstants.ERROR);
        }
        return true;
    }

    public static String magicSubstitute(String src) {
        int i = 0;
        while ((i = src.indexOf(92, i)) >= 0 && ++i < src.length()) {
            char c = src.charAt(i);
            if (c == '\r' || c == '\n') {
                return MAGIC_SUBSTITUTE.matcher(src).replaceAll(" ");
            }
            ++i;
        }
        return src;
    }

    public ISubstitution getCVB(ICodeScanner input) throws TclParseException {
        if (CommandSubstitution.iAm(input)) {
            return new CommandSubstitution();
        }
        if (VariableSubstitution.iAm(input)) {
            return new VariableSubstitution();
        }
        if (NormalBackslashSubstitution.iAm(input)) {
            return new NormalBackslashSubstitution();
        }
        if (MagicBackslashSubstitution.iAm(input)) {
            return new MagicBackslashSubstitution();
        }
        return null;
    }

    private TclCommand nextCommand(ICodeScanner input, boolean nest, TclWordBuffer wordBuffer) throws TclParseException {
        TclCommand cmd;
        block25: {
            cmd = new TclCommand();
            cmd.setStart(input.getPosition());
            wordBuffer.reset();
            while (true) {
                ISubstitution s;
                TclWord word;
                int ch;
                boolean eof;
                boolean bl = eof = (ch = input.read()) == -1;
                if (eof && cmd.isEmpty() && wordBuffer.isEmpty()) {
                    return STOP_EOF;
                }
                if (TclTextUtils.isTrueWhitespace(ch) || eof) {
                    word = wordBuffer.buildWord();
                    if (word != null) {
                        this.validateWord(word);
                        cmd.addWord(word);
                    }
                    if (!eof) continue;
                    break block25;
                }
                input.unread();
                if (wordBuffer.getState() != TclWordBuffer.State.CONTENT) {
                    wordBuffer.setStart(input.getPosition());
                }
                if (wordBuffer.isEmpty() && BracesSubstitution.iAm(input)) {
                    s = new BracesSubstitution();
                    ((BracesSubstitution)s).readMe(input, this);
                    wordBuffer.add(s);
                    continue;
                }
                if (wordBuffer.isEmpty() && QuotesSubstitution.iAm(input)) {
                    s = new QuotesSubstitution();
                    ((QuotesSubstitution)s).readMe(input, this);
                    wordBuffer.add(s);
                    continue;
                }
                if (cmd.isEmpty() && wordBuffer.isEmpty()) {
                    if (ch == 35 && this.skipComments) {
                        input.read();
                        TclTextUtils.runToLineEnd(input);
                        return null;
                    }
                    if (ch == 93 && nest) {
                        input.read();
                        return STOP;
                    }
                } else if (ch == 93 && nest) {
                    word = wordBuffer.buildWord();
                    if (word != null) {
                        this.validateWord(word);
                        cmd.addWord(word);
                    }
                    break block25;
                }
                if ((s = this.getCVB(input)) != null) {
                    s.readMe(input, this);
                    if (s instanceof MagicBackslashSubstitution) {
                        TclWord word2 = wordBuffer.buildWord();
                        if (word2 == null) continue;
                        word2.setEnd(((MagicBackslashSubstitution)s).getStart() - 1);
                        this.validateWord(word2);
                        cmd.addWord(word2);
                        continue;
                    }
                    wordBuffer.add(s);
                    continue;
                }
                boolean cmdEnd = false;
                switch (ch) {
                    case 13: {
                        input.read();
                        int c1 = input.read();
                        if (c1 == 10) {
                            cmdEnd = true;
                            break;
                        }
                        if (c1 == -1) {
                            cmdEnd = true;
                            break;
                        }
                        input.unread();
                        wordBuffer.add((char)ch);
                        break;
                    }
                    case 10: {
                        input.read();
                        cmdEnd = true;
                        break;
                    }
                    case 59: {
                        input.read();
                        cmdEnd = true;
                        break;
                    }
                    default: {
                        input.read();
                        wordBuffer.add((char)ch);
                    }
                }
                if (cmdEnd) break;
            }
            TclWord word = wordBuffer.buildWord();
            if (word != null) {
                this.validateWord(word);
                cmd.addWord(word);
            }
        }
        int wordsSize = cmd.getWords().size();
        if (wordsSize > 0) {
            TclWord w = cmd.getWords().get(wordsSize - 1);
            cmd.setEnd(w.getEnd());
        } else {
            cmd.setEnd(cmd.getStart());
        }
        return cmd;
    }

    private void validateWord(TclWord word) {
        Object first;
        List<Object> contents = word.getContents();
        if (contents.size() > 1 && (first = word.getContents().get(0)) instanceof IWordSubstitution) {
            this.handleError(new ErrorDescription(first instanceof QuotesSubstitution ? Messages.SimpleTclParser_ExtraCharactersAfterCloseQuote : Messages.SimpleTclParser_ExtraCharactersAfterCloseBrace, ((TclElement)first).getEnd() + 1, word.getStart() + word.length(), 0));
        }
    }

    public TclScript parse(ICodeScanner input, boolean nest, IEOFHandler handler) throws TclParseException {
        TclCommand cmd;
        TclWordBuffer wordBuffer = new TclWordBuffer();
        TclScript script = new TclScript();
        script.setStart(input.getPosition());
        while ((cmd = this.nextCommand(input, nest, wordBuffer)) != STOP) {
            if (cmd == STOP_EOF) {
                if (handler == null) break;
                handler.handle();
                break;
            }
            if (cmd == null || cmd.getWords().size() == 0) continue;
            script.addCommand(cmd);
        }
        script.setEnd(input.getPosition() - 1);
        return script;
    }

    public TclScript parse(String content) throws TclParseException {
        CodeScanner scanner = new CodeScanner(content);
        TclScript script = this.parse(scanner, false, null);
        return script;
    }

    public static TclScript staticParse(String content) throws TclParseException {
        SimpleTclParser parser = new SimpleTclParser();
        return parser.parse(content);
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public static interface IEOFHandler {
        public void handle();
    }
}

