/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.BufferChangedEvent;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IBufferChangedListener;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.swt.widgets.Display;

public class DocumentAdapter
implements IBuffer,
IDocumentListener {
    public static final IBuffer NULL = new NullBuffer();
    private IPath fPath;
    private static final boolean DEBUG_LINE_DELIMITERS = true;
    private IOpenable fOwner;
    private IFile fFile;
    private ITextFileBuffer fTextFileBuffer;
    private IDocument fDocument;
    private DocumentSetCommand fSetCmd = new DocumentSetCommand();
    private DocumentReplaceCommand fReplaceCmd = new DocumentReplaceCommand();
    private Set<String> fLegalLineDelimiters;
    private List<IBufferChangedListener> fBufferListeners = new ArrayList<IBufferChangedListener>(3);
    private IStatus fStatus;
    private LocationKind fLocationKind;
    private IFileStore fFileStore;

    public DocumentAdapter(IOpenable owner, IFile file) {
        this.fOwner = owner;
        this.fFile = file;
        this.fPath = this.fFile.getFullPath();
        this.fLocationKind = LocationKind.IFILE;
        this.initialize();
    }

    public DocumentAdapter(IOpenable owner, IPath path) {
        Assert.isLegal((path != null ? 1 : 0) != 0);
        this.fOwner = owner;
        this.fPath = path;
        this.fLocationKind = LocationKind.NORMALIZE;
        this.initialize();
    }

    public DocumentAdapter(IOpenable owner, IFileStore fileStore, IPath path) {
        Assert.isLegal((fileStore != null ? 1 : 0) != 0);
        Assert.isLegal((path != null ? 1 : 0) != 0);
        this.fOwner = owner;
        this.fFileStore = fileStore;
        this.fPath = path;
        this.fLocationKind = LocationKind.NORMALIZE;
        this.initialize();
    }

    private void initialize() {
        block4: {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                if (this.fFileStore != null) {
                    manager.connectFileStore(this.fFileStore, (IProgressMonitor)new NullProgressMonitor());
                    this.fTextFileBuffer = manager.getFileStoreTextFileBuffer(this.fFileStore);
                } else {
                    manager.connect(this.fPath, this.fLocationKind, (IProgressMonitor)new NullProgressMonitor());
                    this.fTextFileBuffer = manager.getTextFileBuffer(this.fPath, this.fLocationKind);
                }
                this.fDocument = this.fTextFileBuffer.getDocument();
            }
            catch (CoreException x) {
                this.fStatus = x.getStatus();
                this.fDocument = manager.createEmptyDocument(this.fPath, LocationKind.NORMALIZE);
                if (!(this.fDocument instanceof ISynchronizable)) break block4;
                ((ISynchronizable)this.fDocument).setLockObject(new Object());
            }
        }
        this.fDocument.addPrenotifiedDocumentListener((IDocumentListener)this);
    }

    public IStatus getStatus() {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (this.fTextFileBuffer != null) {
            return this.fTextFileBuffer.getStatus();
        }
        return null;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void addBufferChangedListener(IBufferChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fBufferListeners.contains(listener)) {
            this.fBufferListeners.add(listener);
        }
    }

    public void removeBufferChangedListener(IBufferChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.fBufferListeners.remove(listener);
    }

    public void append(char[] text) {
        this.append(new String(text));
    }

    public void append(String text) {
        this.validateLineDelimiters(text);
        this.fReplaceCmd.replace(this.fDocument.getLength(), 0, text);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        IDocument d = this.fDocument;
        this.fDocument = null;
        d.removePrenotifiedDocumentListener((IDocumentListener)this);
        if (this.fTextFileBuffer != null) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                if (this.fFileStore != null) {
                    manager.disconnectFileStore(this.fFileStore, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    manager.disconnect(this.fPath, this.fLocationKind, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.fTextFileBuffer = null;
        }
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, 0, 0, null));
        this.fBufferListeners.clear();
    }

    public char getChar(int position) {
        try {
            return this.fDocument.getChar(position);
        }
        catch (BadLocationException x) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public char[] getCharacters() {
        String content = this.getContents();
        return content == null ? null : content.toCharArray();
    }

    public String getContents() {
        return this.fDocument.get();
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public IOpenable getOwner() {
        return this.fOwner;
    }

    public String getText(int offset, int length) {
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException x) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    public boolean hasUnsavedChanges() {
        return this.fTextFileBuffer != null ? this.fTextFileBuffer.isDirty() : false;
    }

    public boolean isClosed() {
        return this.fDocument == null;
    }

    public boolean isReadOnly() {
        IResource resource = this.getUnderlyingResource();
        return resource == null ? true : resource.getResourceAttributes().isReadOnly();
    }

    public void replace(int position, int length, char[] text) {
        this.replace(position, length, new String(text));
    }

    public void replace(int position, int length, String text) {
        this.validateLineDelimiters(text);
        this.fReplaceCmd.replace(position, length, text);
    }

    public void save(IProgressMonitor progress, boolean force) throws ModelException {
        try {
            if (this.fTextFileBuffer != null) {
                this.fTextFileBuffer.commit(progress, force);
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public void setContents(char[] contents) {
        this.setContents(new String(contents));
    }

    public void setContents(String contents) {
        int oldLength = this.fDocument.getLength();
        if (contents == null) {
            if (oldLength != 0) {
                this.fSetCmd.set("");
            }
        } else {
            this.validateLineDelimiters(contents);
            if (!contents.equals(this.fDocument.get())) {
                this.fSetCmd.set(contents);
            }
        }
    }

    private void validateLineDelimiters(String contents) {
        if (this.fLegalLineDelimiters == null) {
            HashSet<String> existingDelimiters = new HashSet<String>();
            int i = this.fDocument.getNumberOfLines() - 1;
            while (i >= 0) {
                try {
                    String curr = this.fDocument.getLineDelimiter(i);
                    if (curr != null) {
                        existingDelimiters.add(curr);
                    }
                }
                catch (BadLocationException e) {
                    DLTKUIPlugin.log(e);
                }
                --i;
            }
            if (existingDelimiters.isEmpty()) {
                return;
            }
            this.fLegalLineDelimiters = existingDelimiters;
        }
        DefaultLineTracker tracker = new DefaultLineTracker();
        tracker.set(contents);
        int lines = tracker.getNumberOfLines();
        if (lines <= 1) {
            return;
        }
        int i = 0;
        while (i < lines) {
            try {
                String curr = tracker.getLineDelimiter(i);
                if (curr != null && !this.fLegalLineDelimiters.contains(curr)) {
                    StringBuffer buf = new StringBuffer("WARNING: DocumentAdapter added new line delimiter to code: ");
                    int k = 0;
                    while (k < curr.length()) {
                        if (k > 0) {
                            buf.append(' ');
                        }
                        buf.append((int)curr.charAt(k));
                        ++k;
                    }
                    Status status = new Status(2, "org.eclipse.dltk.ui", 0, buf.toString(), new Throwable());
                    DLTKUIPlugin.log((IStatus)status);
                }
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log(e);
            }
            ++i;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.fireBufferChanged(new BufferChangedEvent((IBuffer)this, event.getOffset(), event.getLength(), event.getText()));
    }

    private void fireBufferChanged(BufferChangedEvent event) {
        if (this.fBufferListeners != null && this.fBufferListeners.size() > 0) {
            Iterator<IBufferChangedListener> e = new ArrayList<IBufferChangedListener>(this.fBufferListeners).iterator();
            while (e.hasNext()) {
                e.next().bufferChanged(event);
            }
        }
    }

    private static final void run(Runnable runnable) {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    protected class DocumentReplaceCommand
    implements Runnable {
        private int fOffset;
        private int fLength;
        private String fText;

        protected DocumentReplaceCommand() {
        }

        @Override
        public void run() {
            try {
                DocumentAdapter.this.fDocument.replace(this.fOffset, this.fLength, this.fText);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void replace(int offset, int length, String text) {
            this.fOffset = offset;
            this.fLength = length;
            this.fText = text;
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    protected class DocumentSetCommand
    implements Runnable {
        private String fContents;

        protected DocumentSetCommand() {
        }

        @Override
        public void run() {
            DocumentAdapter.this.fDocument.set(this.fContents);
        }

        public void set(String contents) {
            this.fContents = contents;
            DocumentAdapter.run(this);
        }
    }

    private static class NullBuffer
    implements IBuffer {
        private NullBuffer() {
        }

        public void addBufferChangedListener(IBufferChangedListener listener) {
        }

        public void append(char[] text) {
        }

        public void append(String text) {
        }

        public void close() {
        }

        public char getChar(int position) {
            return '\u0000';
        }

        public char[] getCharacters() {
            return null;
        }

        public String getContents() {
            return null;
        }

        public int getLength() {
            return 0;
        }

        public IOpenable getOwner() {
            return null;
        }

        public String getText(int offset, int length) {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }

        public boolean hasUnsavedChanges() {
            return false;
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        public void removeBufferChangedListener(IBufferChangedListener listener) {
        }

        public void replace(int position, int length, char[] text) {
        }

        public void replace(int position, int length, String text) {
        }

        public void save(IProgressMonitor progress, boolean force) throws ModelException {
        }

        public void setContents(char[] contents) {
        }

        public void setContents(String contents) {
        }
    }
}

