/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.DelegatedOpen;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.editor.IScriptEditor;
import org.eclipse.dltk.internal.ui.text.LineComparator;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    public static IScriptProject getScriptProject(IEditorInput input) {
        IScriptProject project;
        IModelElement element;
        IScriptProject dProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project2 = ((IFileEditorInput)input).getFile().getProject();
            if (project2 != null && !(dProject = DLTKCore.create((IProject)project2)).exists()) {
                dProject = null;
            }
        } else if (input instanceof ExternalStorageEditorInput && (element = (IModelElement)input.getAdapter(IModelElement.class)) != null && (project = element.getScriptProject()) != null && project.exists()) {
            return project;
        }
        return dProject;
    }

    public static ISourceModule getEditorInputModelElement(IEditorPart editor, boolean primaryOnly) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        ISourceModule je = DLTKUIPlugin.getEditorInputModelElement(editorInput);
        if (je != null || primaryOnly) {
            return je;
        }
        return DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, primaryOnly);
    }

    public static IEditorPart openInEditor(Object inputElement) throws ModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws ModelException, PartInitException {
        ISourceModule editorCU;
        IEditorPart editor;
        IWorkbenchPage page;
        IModelElement modelElement;
        ISourceModule cu;
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        if (inputElement instanceof DelegatedOpen) {
            return ((DelegatedOpen)inputElement).openInEditor(activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null) {
            if (inputElement instanceof IModelElement) {
                String editorId = null;
                IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)inputElement);
                if (toolkit != null) {
                    editorId = toolkit.getEditorId(inputElement);
                }
                if (editorId == null) {
                    editorId = EditorUtility.getEditorID(input, inputElement);
                }
                if (editorId != null) {
                    return EditorUtility.openInEditor(input, editorId, activate);
                }
            } else {
                return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
            }
        }
        if (inputElement instanceof IModelElement && (cu = (ISourceModule)(modelElement = (IModelElement)inputElement).getAncestor(5)) != null && (page = DLTKUIPlugin.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (editorCU = EditorUtility.getEditorInputModelElement(editor, false)) == cu) {
            EditorUtility.revealInEditor(editor, modelElement);
            return editor;
        }
        return null;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorDescriptor editorDescriptor;
        try {
            editorDescriptor = input instanceof IFileEditorInput ? IDE.getEditorDescriptor((IFile)((IFileEditorInput)input).getFile(), (boolean)true, (boolean)false) : (input instanceof ExternalStorageEditorInput ? IDE.getEditorDescriptor((String)input.getName(), (boolean)true, (boolean)false) : IDE.getEditorDescriptor((String)input.getName(), (boolean)true, (boolean)false));
        }
        catch (PartInitException e) {
            return null;
        }
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    private static IEditorInput getEditorInput(IModelElement element) {
        while (element != null) {
            IResource resource;
            ISourceModule unit;
            IEditorInput adapter = (IEditorInput)element.getAdapter(IEditorInput.class);
            if (adapter != null) {
                return adapter;
            }
            if (element instanceof IExternalSourceModule) {
                unit = ((ISourceModule)element).getPrimary();
                if (unit instanceof IStorage) {
                    return new ExternalStorageEditorInput((IStorage)unit);
                }
            } else if (element instanceof ISourceModule && (resource = (unit = ((ISourceModule)element).getPrimary()).getResource()) instanceof IFile && ((IFile)resource).exists()) {
                return new FileEditorInput((IFile)resource);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) {
        if (input instanceof IModelElement) {
            return EditorUtility.getEditorInput((IModelElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add archive entry and external source folder editor input..");
        }
        if (input instanceof IStorage) {
            return new ExternalStorageEditorInput((IStorage)input);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, IModelElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof IScriptEditor) {
            ((IScriptEditor)part).setSelection(element);
            return;
        }
        try {
            ISourceRange range = null;
            if (!(element instanceof IExternalSourceModule)) {
                if (element instanceof ISourceModule) {
                    range = null;
                } else if (element instanceof IMember) {
                    range = ((IMember)element).getNameRange();
                } else if (element instanceof ISourceReference) {
                    range = ((ISourceReference)element).getSourceRange();
                }
            }
            if (range != null) {
                EditorUtility.revealInEditor(part, range.getOffset(), range.getLength());
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public static void revealInEditor(IEditorPart editorPart, int lineNumber) throws CoreException {
        if (editorPart instanceof ITextEditor && lineNumber >= 0) {
            ITextEditor textEditor = (ITextEditor)editorPart;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput input = editorPart.getEditorInput();
            provider.connect((Object)input);
            IDocument document = provider.getDocument((Object)input);
            try {
                IRegion line = document.getLineInformation(lineNumber);
                textEditor.selectAndReveal(line.getOffset(), line.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            provider.disconnect((Object)input);
        }
    }

    public static void revealInEditor(IEditorPart part, IRegion region) {
        if (part != null && region != null) {
            EditorUtility.revealInEditor(part, region.getOffset(), region.getLength());
        }
    }

    public static void revealInEditor(IEditorPart editor, final int offset, final int length) {
        if (editor instanceof ITextEditor) {
            ((ITextEditor)editor).selectAndReveal(offset, length);
            return;
        }
        if (editor instanceof IGotoMarker) {
            final IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                final IGotoMarker gotoMarkerTarget = (IGotoMarker)editor;
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = null;
                        try {
                            marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("charStart", offset);
                            marker.setAttribute("charEnd", offset + length);
                            gotoMarkerTarget.gotoMarker(marker);
                        }
                        finally {
                            if (marker != null) {
                                marker.delete();
                            }
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            } else if (input instanceof ExternalStorageEditorInput) {
                System.err.println("TODO: Add external storage editor input reveal...");
            }
            return;
        }
        if (editor != null && editor.getEditorSite().getSelectionProvider() != null) {
            IEditorSite site = editor.getEditorSite();
            if (site == null) {
                return;
            }
            ISelectionProvider provider = editor.getEditorSite().getSelectionProvider();
            if (provider == null) {
                return;
            }
            provider.setSelection((ISelection)new TextSelection(offset, length));
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = DLTKUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = DLTKUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            EditorUtility.initializeHighlightRange(editorPart);
            return editorPart;
        }
        return null;
    }

    private static void initializeHighlightRange(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            boolean enable;
            IAction toggleAction = editorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl = enable = toggleAction != null;
            if (DLTKCore.DEBUG) {
                System.err.println("Add initializeHighlightRange support of preferences.");
            }
            boolean bl2 = enable = enable && toggleAction.isEnabled() && toggleAction.isChecked();
            if (enable) {
                if (toggleAction instanceof TextEditorAction) {
                    ((TextEditorAction)toggleAction).setEditor(null);
                    ((TextEditorAction)toggleAction).setEditor((ITextEditor)editorPart);
                } else {
                    toggleAction.run();
                    toggleAction.run();
                }
            }
        }
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null && (p = DLTKUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IModelElement getActiveEditorModelInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return DLTKUIPlugin.getEditorInputModelElement(editorInput);
        }
        return null;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return Messages.format(DLTKEditorMessages.EditorUtility_concatModifierStrings, modifierString, newModifierString);
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    public static int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static IRegion[] calculateChangedLineRegions(final ITextFileBuffer buffer, final IProgressMonitor monitor) throws CoreException {
        final IRegion[][] result = new IRegion[1][];
        final IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
        try {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 10007, exception.getLocalizedMessage(), exception));
                    String msg = DLTKEditorMessages.CompilationUnitDocumentProvider_error_calculatingChangedRegions;
                    errorStatus[0] = new Status(4, "org.eclipse.dltk.ui", 10007, msg, exception);
                    result[0] = null;
                }

                public void run() throws Exception {
                    monitor.beginTask(DLTKEditorMessages.CompilationUnitDocumentProvider_calculatingChangedRegions_message, 20);
                    IFileStore fileStore = buffer.getFileStore();
                    ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
                    fileBufferManager.connectFileStore(fileStore, EditorUtility.getSubProgressMonitor(monitor, 15));
                    try {
                        IDocument currentDocument = buffer.getDocument();
                        IDocument oldDocument = ((ITextFileBuffer)fileBufferManager.getFileStoreFileBuffer(fileStore)).getDocument();
                        result[0] = this.getChangedLineRegions(oldDocument, currentDocument);
                    }
                    finally {
                        fileBufferManager.disconnectFileStore(fileStore, EditorUtility.getSubProgressMonitor(monitor, 5));
                        monitor.done();
                    }
                }

                private IRegion[] getChangedLineRegions(IDocument oldDocument, IDocument currentDocument) throws BadLocationException {
                    LineComparator leftSide = new LineComparator(oldDocument);
                    LineComparator rightSide = new LineComparator(currentDocument);
                    RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
                    ArrayList<Object> regions = new ArrayList<Object>();
                    int i = 0;
                    while (i < differences.length) {
                        RangeDifference curr = differences[i];
                        if (curr.kind() == 2 && curr.rightLength() > 0) {
                            int startLine = curr.rightStart();
                            int endLine = curr.rightEnd() - 1;
                            IRegion startLineRegion = currentDocument.getLineInformation(startLine);
                            if (startLine == endLine) {
                                regions.add(startLineRegion);
                            } else {
                                IRegion endLineRegion = currentDocument.getLineInformation(endLine);
                                int startOffset = startLineRegion.getOffset();
                                int endOffset = endLineRegion.getOffset() + endLineRegion.getLength();
                                regions.add(new Region(startOffset, endOffset - startOffset));
                            }
                        }
                        ++i;
                    }
                    return regions.toArray(new IRegion[regions.size()]);
                }
            });
        }
        finally {
            if (!errorStatus[0].isOK()) {
                throw new CoreException(errorStatus[0]);
            }
        }
        return result[0];
    }

    private static IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }
}

