/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.parser.structure;

import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclModelBuilderDetector;
import org.eclipse.dltk.tcl.structure.TclModelBuilderUtil;
import org.eclipse.dltk.xotcl.internal.core.XOTclKeywords;
import org.eclipse.dltk.xotcl.internal.core.parser.structure.XOTclNames;
import org.eclipse.dltk.xotcl.internal.core.parser.structure.XOTclType;

public class XOTclModelDetector
extends TclModelBuilderUtil
implements ITclModelBuilderDetector {
    private static final String CLASS_PREFIX = "#Class#";
    private static final String OBJECT_PREFIX = "#Object#";
    static final String CREATE = "create";
    static final String INSTPROC = "instproc";
    static final String PROC = "proc";
    private static final String CLASS_CREATE = "#Class#create";
    private static final String CLASS_NEW_INSTANCE = "#Class#$newInstance";
    private static final String OBJECT_CREATE = "#Object#create";
    private static final boolean INTERPRET_CLASS_UNKNOWN_AS_CREATE = true;
    private static final boolean INTERPRET_OBJECT_UNKNOWN_AS_CREATE = true;
    private static final String[] NAMESPACES = new String[]{"::xotcl::", "xotcl::"};
    private static final String CLASS = "Class";
    private static final String OBJECT = "Object";

    public String detect(String commandName, TclCommand command, ITclModelBuildContext context) {
        if (commandName == null) {
            return null;
        }
        if (CLASS.equals(commandName = this.normalize(commandName))) {
            return this.checkClass(command, commandName, context);
        }
        if (OBJECT.equals(commandName)) {
            return this.checkObject(command, commandName, context);
        }
        return this.checkInstanceOperations(command, commandName, context);
    }

    private String checkClass(TclCommand command, String commandName, ITclModelBuildContext context) {
        if (command.getArguments().isEmpty()) {
            return null;
        }
        TclArgument subcmd = (TclArgument)command.getArguments().get(0);
        if (XOTclModelDetector.isSymbol((TclArgument)subcmd)) {
            String value = XOTclModelDetector.asSymbol((TclArgument)subcmd);
            if (this.contains(value, XOTclKeywords.XOTclCommandClassArgs)) {
                return CLASS_PREFIX + value;
            }
            String info = this.checkCreateType(context, command, commandName, subcmd, value);
            if (info != null) {
                return info;
            }
            return CLASS_CREATE;
        }
        return null;
    }

    private String checkObject(TclCommand command, String commandName, ITclModelBuildContext context) {
        if (command.getArguments().isEmpty()) {
            return null;
        }
        TclArgument subcmd = (TclArgument)command.getArguments().get(0);
        if (XOTclModelDetector.isSymbol((TclArgument)subcmd)) {
            String value = XOTclModelDetector.asSymbol((TclArgument)subcmd);
            if (this.contains(value, XOTclKeywords.XOTclCommandObjectArgs)) {
                return OBJECT_PREFIX + value;
            }
            String info = this.checkCreateType(context, command, commandName, subcmd, value);
            if (info != null) {
                return info;
            }
            return OBJECT_CREATE;
        }
        return null;
    }

    private String checkCreateType(ITclModelBuildContext context, TclCommand command, String commandName, TclArgument arg, String value) {
        String info;
        if ((value.equals(INSTPROC) || value.equals(PROC) || value.equals("set")) && (info = this.checkCommands(value)) != null) {
            return info;
        }
        return null;
    }

    private String checkCommands(String value) {
        if (this.contains(value, XOTclKeywords.XOTclCommandClassArgs)) {
            return CLASS_PREFIX + value;
        }
        if (this.contains(value, XOTclKeywords.XOTclCommandObjectArgs)) {
            return OBJECT_PREFIX + value;
        }
        return null;
    }

    private boolean contains(String value, String[] commands) {
        int q = 0;
        while (q < commands.length) {
            if (value.equals(commands[q])) {
                return true;
            }
            ++q;
        }
        return false;
    }

    private String checkInstanceOperations(TclCommand command, String commandName, ITclModelBuildContext context) {
        XOTclType type;
        XOTclNames names;
        if (command.getArguments().isEmpty()) {
            return null;
        }
        TclArgument subcmd = (TclArgument)command.getArguments().get(0);
        if (XOTclModelDetector.isSymbol((TclArgument)subcmd) && (names = XOTclNames.get(context)) != null && (type = names.resolve(commandName)) != null) {
            type.saveTo(context);
            return this.check(subcmd);
        }
        if (commandName.length() >= 3) {
            if (commandName.startsWith("::")) {
                commandName = commandName.substring(2);
            }
            if ((commandName.indexOf("::") > 0 || Character.isUpperCase(commandName.charAt(0))) && XOTclModelDetector.asSymbol((TclArgument)subcmd).equals(CREATE)) {
                new XOTclType(commandName, null).saveTo(context);
                return CLASS_NEW_INSTANCE;
            }
        }
        return null;
    }

    private String check(TclArgument subcmd) {
        String value = XOTclModelDetector.asSymbol((TclArgument)subcmd);
        if (!CREATE.equals(value)) {
            String info = this.checkCommands(value);
            if (info != null) {
                return info;
            }
        } else {
            return CLASS_NEW_INSTANCE;
        }
        return null;
    }

    private String normalize(String commandName) {
        String[] stringArray = NAMESPACES;
        int n = NAMESPACES.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            if (commandName.startsWith(namespace)) {
                return commandName.substring(namespace.length());
            }
            ++n2;
        }
        return commandName;
    }
}

