/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildChange;
import org.eclipse.dltk.core.builder.IBuildState;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.NullValidatorOutput;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.core.ValidatorUtils;

public class ValidatorBuilder
implements IScriptBuilder {
    private static final boolean DEBUG = false;
    private static final int WORK_EXTERNAL = 200;

    public void prepare(IBuildChange change, IBuildState state, IProgressMonitor monitor) throws CoreException {
    }

    public void build(IBuildChange change, IBuildState state, IProgressMonitor monitor) throws CoreException {
        IScriptProject project = change.getScriptProject();
        List elements = change.getSourceModules(0);
        IValidator[] validators = ValidatorRuntime.getProjectValidators(project, ISourceModuleValidator.class, new ValidatorRuntime.AutomaticValidatorPredicate(project));
        int validatorWork = validators.length * 200;
        monitor.beginTask("", validatorWork);
        try {
            ValidatorRuntime.executeSourceModuleValidators(project, elements, (IValidatorOutput)new NullValidatorOutput(), validators, ValidatorUtils.subMonitorFor(monitor, validatorWork));
        }
        finally {
            monitor.done();
        }
        List resources = change.getResources(0);
        SubProgressMonitor sub = new SubProgressMonitor(monitor, resources.size());
        try {
            ValidatorRuntime.executeAutomaticResourceValidators(project, resources, new NullValidatorOutput(), (IProgressMonitor)sub);
        }
        finally {
            sub.done();
        }
    }

    public void clean(IScriptProject project, IProgressMonitor monitor) {
        ValidatorRuntime.cleanAll(project, new ISourceModule[0], new IResource[]{project.getProject()}, monitor);
    }

    public boolean initialize(IScriptProject project) {
        return true;
    }

    public void endBuild(IScriptProject project, IBuildState state, IProgressMonitor monitor) {
    }
}

