/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.NetworkStats;

final class ImmutableNetworkStats
implements NetworkStats {
    private final Long rxBytes;
    private final Long rxPackets;
    private final Long rxDropped;
    private final Long rxErrors;
    private final Long txBytes;
    private final Long txPackets;
    private final Long txDropped;
    private final Long txErrors;

    private ImmutableNetworkStats(Long rxBytes, Long rxPackets, Long rxDropped, Long rxErrors, Long txBytes, Long txPackets, Long txDropped, Long txErrors) {
        this.rxBytes = rxBytes;
        this.rxPackets = rxPackets;
        this.rxDropped = rxDropped;
        this.rxErrors = rxErrors;
        this.txBytes = txBytes;
        this.txPackets = txPackets;
        this.txDropped = txDropped;
        this.txErrors = txErrors;
    }

    @Override
    @JsonProperty(value="rx_bytes")
    public Long rxBytes() {
        return this.rxBytes;
    }

    @Override
    @JsonProperty(value="rx_packets")
    public Long rxPackets() {
        return this.rxPackets;
    }

    @Override
    @JsonProperty(value="rx_dropped")
    public Long rxDropped() {
        return this.rxDropped;
    }

    @Override
    @JsonProperty(value="rx_errors")
    public Long rxErrors() {
        return this.rxErrors;
    }

    @Override
    @JsonProperty(value="tx_bytes")
    public Long txBytes() {
        return this.txBytes;
    }

    @Override
    @JsonProperty(value="tx_packets")
    public Long txPackets() {
        return this.txPackets;
    }

    @Override
    @JsonProperty(value="tx_dropped")
    public Long txDropped() {
        return this.txDropped;
    }

    @Override
    @JsonProperty(value="tx_errors")
    public Long txErrors() {
        return this.txErrors;
    }

    public final ImmutableNetworkStats withRxBytes(Long value) {
        Long newValue = Objects.requireNonNull(value, "rxBytes");
        if (this.rxBytes.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(newValue, this.rxPackets, this.rxDropped, this.rxErrors, this.txBytes, this.txPackets, this.txDropped, this.txErrors);
    }

    public final ImmutableNetworkStats withRxPackets(Long value) {
        Long newValue = Objects.requireNonNull(value, "rxPackets");
        if (this.rxPackets.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, newValue, this.rxDropped, this.rxErrors, this.txBytes, this.txPackets, this.txDropped, this.txErrors);
    }

    public final ImmutableNetworkStats withRxDropped(Long value) {
        Long newValue = Objects.requireNonNull(value, "rxDropped");
        if (this.rxDropped.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, newValue, this.rxErrors, this.txBytes, this.txPackets, this.txDropped, this.txErrors);
    }

    public final ImmutableNetworkStats withRxErrors(Long value) {
        Long newValue = Objects.requireNonNull(value, "rxErrors");
        if (this.rxErrors.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, this.rxDropped, newValue, this.txBytes, this.txPackets, this.txDropped, this.txErrors);
    }

    public final ImmutableNetworkStats withTxBytes(Long value) {
        Long newValue = Objects.requireNonNull(value, "txBytes");
        if (this.txBytes.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, this.rxDropped, this.rxErrors, newValue, this.txPackets, this.txDropped, this.txErrors);
    }

    public final ImmutableNetworkStats withTxPackets(Long value) {
        Long newValue = Objects.requireNonNull(value, "txPackets");
        if (this.txPackets.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, this.rxDropped, this.rxErrors, this.txBytes, newValue, this.txDropped, this.txErrors);
    }

    public final ImmutableNetworkStats withTxDropped(Long value) {
        Long newValue = Objects.requireNonNull(value, "txDropped");
        if (this.txDropped.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, this.rxDropped, this.rxErrors, this.txBytes, this.txPackets, newValue, this.txErrors);
    }

    public final ImmutableNetworkStats withTxErrors(Long value) {
        Long newValue = Objects.requireNonNull(value, "txErrors");
        if (this.txErrors.equals(newValue)) {
            return this;
        }
        return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, this.rxDropped, this.rxErrors, this.txBytes, this.txPackets, this.txDropped, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkStats && this.equalTo(0, (ImmutableNetworkStats)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetworkStats another) {
        return this.rxBytes.equals(another.rxBytes) && this.rxPackets.equals(another.rxPackets) && this.rxDropped.equals(another.rxDropped) && this.rxErrors.equals(another.rxErrors) && this.txBytes.equals(another.txBytes) && this.txPackets.equals(another.txPackets) && this.txDropped.equals(another.txDropped) && this.txErrors.equals(another.txErrors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.rxBytes.hashCode();
        h += (h << 5) + this.rxPackets.hashCode();
        h += (h << 5) + this.rxDropped.hashCode();
        h += (h << 5) + this.rxErrors.hashCode();
        h += (h << 5) + this.txBytes.hashCode();
        h += (h << 5) + this.txPackets.hashCode();
        h += (h << 5) + this.txDropped.hashCode();
        h += (h << 5) + this.txErrors.hashCode();
        return h;
    }

    public String toString() {
        return "NetworkStats{rxBytes=" + this.rxBytes + ", rxPackets=" + this.rxPackets + ", rxDropped=" + this.rxDropped + ", rxErrors=" + this.rxErrors + ", txBytes=" + this.txBytes + ", txPackets=" + this.txPackets + ", txDropped=" + this.txDropped + ", txErrors=" + this.txErrors + "}";
    }

    public static ImmutableNetworkStats copyOf(NetworkStats instance) {
        if (instance instanceof ImmutableNetworkStats) {
            return (ImmutableNetworkStats)instance;
        }
        return ImmutableNetworkStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_RX_BYTES = 1L;
        private static final long INIT_BIT_RX_PACKETS = 2L;
        private static final long INIT_BIT_RX_DROPPED = 4L;
        private static final long INIT_BIT_RX_ERRORS = 8L;
        private static final long INIT_BIT_TX_BYTES = 16L;
        private static final long INIT_BIT_TX_PACKETS = 32L;
        private static final long INIT_BIT_TX_DROPPED = 64L;
        private static final long INIT_BIT_TX_ERRORS = 128L;
        private long initBits = 255L;
        private Long rxBytes;
        private Long rxPackets;
        private Long rxDropped;
        private Long rxErrors;
        private Long txBytes;
        private Long txPackets;
        private Long txDropped;
        private Long txErrors;

        private Builder() {
        }

        public final Builder from(NetworkStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.rxBytes(instance.rxBytes());
            this.rxPackets(instance.rxPackets());
            this.rxDropped(instance.rxDropped());
            this.rxErrors(instance.rxErrors());
            this.txBytes(instance.txBytes());
            this.txPackets(instance.txPackets());
            this.txDropped(instance.txDropped());
            this.txErrors(instance.txErrors());
            return this;
        }

        @JsonProperty(value="rx_bytes")
        public final Builder rxBytes(Long rxBytes) {
            this.rxBytes = Objects.requireNonNull(rxBytes, "rxBytes");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="rx_packets")
        public final Builder rxPackets(Long rxPackets) {
            this.rxPackets = Objects.requireNonNull(rxPackets, "rxPackets");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="rx_dropped")
        public final Builder rxDropped(Long rxDropped) {
            this.rxDropped = Objects.requireNonNull(rxDropped, "rxDropped");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="rx_errors")
        public final Builder rxErrors(Long rxErrors) {
            this.rxErrors = Objects.requireNonNull(rxErrors, "rxErrors");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="tx_bytes")
        public final Builder txBytes(Long txBytes) {
            this.txBytes = Objects.requireNonNull(txBytes, "txBytes");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="tx_packets")
        public final Builder txPackets(Long txPackets) {
            this.txPackets = Objects.requireNonNull(txPackets, "txPackets");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="tx_dropped")
        public final Builder txDropped(Long txDropped) {
            this.txDropped = Objects.requireNonNull(txDropped, "txDropped");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="tx_errors")
        public final Builder txErrors(Long txErrors) {
            this.txErrors = Objects.requireNonNull(txErrors, "txErrors");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableNetworkStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkStats(this.rxBytes, this.rxPackets, this.rxDropped, this.rxErrors, this.txBytes, this.txPackets, this.txDropped, this.txErrors);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rxBytes");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rxPackets");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("rxDropped");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("rxErrors");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("txBytes");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("txPackets");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("txDropped");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("txErrors");
            }
            return "Cannot build NetworkStats, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

