/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.fs;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.codan.internal.checkers.fs.VulnerableFormatStringArgument;

public class CFormatStringParser {
    private static final String DIGIT_PATTERN = "[0-9][0-9]*";
    private static final String STRING_FORMAT_PATTERN = "%[\\*]?[0-9]*[hlL]?[cdeEfgGsuxX]";
    private static final String VULNERABLE_PATTERN = "%[0-9]*s";
    private final Pattern argumentPattern = Pattern.compile("%[\\*]?[0-9]*[hlL]?[cdeEfgGsuxX]");
    private final Matcher argumentMatcher;
    private final Pattern vulnerablePattern;
    private final Collection<VulnerableFormatStringArgument> vulnerableArguments;
    public static final int ARGUMENT_SIZE_NOT_SPECIFIED = -1;

    protected CFormatStringParser(String argument) {
        this.argumentMatcher = this.argumentPattern.matcher(argument);
        this.vulnerablePattern = Pattern.compile(VULNERABLE_PATTERN);
        this.vulnerableArguments = new ConcurrentLinkedQueue<VulnerableFormatStringArgument>();
        this.extractVulnerableArguments();
    }

    public boolean isVulnerable() {
        return !this.vulnerableArguments.isEmpty();
    }

    public Iterator<VulnerableFormatStringArgument> getVulnerableArgumentsIterator() {
        return this.vulnerableArguments.iterator();
    }

    private void extractVulnerableArguments() {
        this.vulnerableArguments.clear();
        boolean hasMore = this.argumentMatcher.find();
        int indexOfCurrentArgument = 0;
        while (hasMore) {
            String formatString = this.argumentMatcher.group();
            String matchedArgument = formatString;
            Matcher vulnerabilityMatcher = this.vulnerablePattern.matcher(matchedArgument);
            boolean isVulnerable = vulnerabilityMatcher.find();
            if (isVulnerable) {
                int argumentSize = this.parseArgumentSize(formatString);
                VulnerableFormatStringArgument vulnerableArgument = new VulnerableFormatStringArgument(indexOfCurrentArgument, formatString, argumentSize);
                this.vulnerableArguments.add(vulnerableArgument);
            }
            hasMore = this.argumentMatcher.find();
            ++indexOfCurrentArgument;
        }
    }

    private int parseArgumentSize(String formatString) {
        Pattern numberPattern;
        Matcher numberMatcher;
        int MINIMUM_POSSIBLE_SIZE = 2;
        int argumentSize = -1;
        if (formatString.length() > 2 && (numberMatcher = (numberPattern = Pattern.compile(DIGIT_PATTERN)).matcher(formatString)).find()) {
            String sizeModifierString = numberMatcher.group();
            argumentSize = Integer.parseInt(sizeModifierString);
        }
        return argumentSize;
    }
}

