/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.hyperlink.IncludeHyperlinkVisitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class IncludeHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof PHPStructuredEditor)) {
            return null;
        }
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)textEditor, (boolean)false);
        if (!(input instanceof ISourceModule)) {
            return null;
        }
        int offset = region.getOffset();
        ISourceModule sourceModule = input;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        if (moduleDeclaration == null) {
            return null;
        }
        IncludeHyperlinkVisitor includeVisitor = new IncludeHyperlinkVisitor(offset, sourceModule);
        try {
            moduleDeclaration.traverse((ASTVisitor)includeVisitor);
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        if (includeVisitor.getFile() != null) {
            ISourceModule includedSourceModule;
            if (!this.inclusive(region, includeVisitor.getSelectRegion())) {
                return null;
            }
            HashSet<String> set = new HashSet<String>();
            IResource resource = sourceModule.getResource();
            if (resource != null && resource.getLocation() != null) {
                set.add(resource.getLocation().toOSString());
            }
            if ((includedSourceModule = FileNetworkUtility.findSourceModule((ISourceModule)sourceModule, (String)includeVisitor.getFile(), set)) != null) {
                return new IHyperlink[]{new ModelElementHyperlink((IRegion)includeVisitor.getSelectRegion(), (Object)includedSourceModule, new OpenAction((IEditorPart)textEditor))};
            }
        }
        return null;
    }

    private boolean inclusive(IRegion region1, Region region2) {
        if (region1 == null || region2 == null) {
            return false;
        }
        return region1.getOffset() >= region2.getOffset() && region1.getOffset() + region1.getLength() <= region2.getOffset() + region2.getLength();
    }
}

