/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointOrganizerManager;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class GroupBreakpointsByDialog
extends TrayDialog {
    private final BreakpointsView fView;
    private TableViewer fAvailableViewer;
    private final AvailableOrganizersProvider fAvailableOrganizersProvider = new AvailableOrganizersProvider();
    private TreeViewer fSelectedViewer;
    private final SelectedOrganizerProvider fSelectedOrganizersProvider = new SelectedOrganizerProvider();
    private final List<Object> fResult = new ArrayList<Object>();
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private Button fBreakpointGroupAccel;
    private final SelectionAdapter fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == GroupBreakpointsByDialog.this.fAddButton) {
                GroupBreakpointsByDialog.this.handleAddPressed();
            } else if (source == GroupBreakpointsByDialog.this.fRemoveButton) {
                GroupBreakpointsByDialog.this.handleRemovePressed();
            } else if (source == GroupBreakpointsByDialog.this.fMoveUpButton) {
                GroupBreakpointsByDialog.this.handleMoveUpPressed();
            } else if (source == GroupBreakpointsByDialog.this.fMoveDownButton) {
                GroupBreakpointsByDialog.this.handleMoveDownPressed();
            }
        }
    };

    protected GroupBreakpointsByDialog(BreakpointsView view) {
        super(view.getSite().getShell());
        this.fView = view;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        BreakpointOrganzierLabelProvider labelProvider = new BreakpointOrganzierLabelProvider();
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        parentComposite.setFont(parent.getFont());
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = 400;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(BreakpointGroupMessages.GroupBreakpointsByDialog_0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.createAvailableViewer(composite, (ILabelProvider)labelProvider);
        this.createButtons(composite);
        this.createSelectedViewer(composite, (ILabelProvider)labelProvider);
        this.initializeContent();
        this.updateViewers();
        this.fBreakpointGroupAccel = new Button(composite, 32);
        this.fBreakpointGroupAccel.setText(BreakpointGroupMessages.GroupBreakpointsByDialog_8);
        GridData gridDataCheckbox = new GridData();
        gridDataCheckbox.horizontalSpan = 3;
        this.fBreakpointGroupAccel.setLayoutData((Object)gridDataCheckbox);
        boolean set = Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), "org.eclipse.debug.core.PREF_FOR_BP_GROUP_TYPE_ACCELERATOR", true, null);
        this.fBreakpointGroupAccel.setSelection(set);
        Dialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getDialogArea(), "org.eclipse.debug.ui.group_breakpoints_dialog_context");
        return contents;
    }

    private void initializeContent() {
        IBreakpointOrganizer organizer;
        IBreakpointOrganizer[] organizers;
        IBreakpointOrganizer[] iBreakpointOrganizerArray = organizers = BreakpointOrganizerManager.getDefault().getOrganizers();
        int n = organizers.length;
        int n2 = 0;
        while (n2 < n) {
            organizer = iBreakpointOrganizerArray[n2];
            this.fAvailableOrganizersProvider.addAvailable(organizer);
            ++n2;
        }
        organizers = this.fView.getBreakpointOrganizers();
        if (organizers != null) {
            iBreakpointOrganizerArray = organizers;
            n = organizers.length;
            n2 = 0;
            while (n2 < n) {
                organizer = iBreakpointOrganizerArray[n2];
                this.fSelectedOrganizersProvider.addSelected(organizer);
                ++n2;
            }
        }
    }

    private void createAvailableViewer(Composite parent, ILabelProvider labelProvider) {
        Composite availableComposite = new Composite(parent, 0);
        availableComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        availableComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 225;
        availableComposite.setLayoutData((Object)gridData);
        Label label = new Label(availableComposite, 64);
        label.setText(BreakpointGroupMessages.GroupBreakpointsByDialog_1);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        this.fAvailableViewer = new TableViewer(availableComposite);
        this.fAvailableViewer.setContentProvider((IContentProvider)this.fAvailableOrganizersProvider);
        this.fAvailableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fAvailableViewer.setInput(new Object());
        Table table = this.fAvailableViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setFont(parent.getFont());
        this.fAvailableViewer.addDoubleClickListener(event -> this.handleAddPressed());
        this.fAvailableViewer.addSelectionChangedListener(event -> this.updateAddButton());
    }

    private void createSelectedViewer(Composite parent, ILabelProvider labelProvider) {
        Composite selectedComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        selectedComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 225;
        selectedComposite.setLayoutData((Object)gridData);
        selectedComposite.setFont(parent.getFont());
        Label label = new Label(selectedComposite, 64);
        label.setText(BreakpointGroupMessages.GroupBreakpointsByDialog_3);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fSelectedViewer = new TreeViewer(selectedComposite);
        this.fSelectedViewer.setContentProvider((IContentProvider)this.fSelectedOrganizersProvider);
        this.fSelectedViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fSelectedViewer.setInput(new Object());
        Tree tree = this.fSelectedViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setFont(parent.getFont());
        this.fSelectedViewer.addDoubleClickListener(event -> this.handleRemovePressed());
        this.fSelectedViewer.addSelectionChangedListener(event -> this.updateSelectedButtons());
    }

    public void createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData());
        buttonComposite.setFont(parent.getFont());
        this.fAddButton = SWTFactory.createPushButton(buttonComposite, BreakpointGroupMessages.GroupBreakpointsByDialog_2, null);
        this.fAddButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fRemoveButton = SWTFactory.createPushButton(buttonComposite, BreakpointGroupMessages.GroupBreakpointsByDialog_4, null);
        this.fRemoveButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fMoveUpButton = SWTFactory.createPushButton(buttonComposite, BreakpointGroupMessages.GroupBreakpointsByDialog_5, null);
        this.fMoveUpButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.fMoveDownButton = SWTFactory.createPushButton(buttonComposite, BreakpointGroupMessages.GroupBreakpointsByDialog_6, null);
        this.fMoveDownButton.addSelectionListener((SelectionListener)this.fSelectionListener);
    }

    public IBreakpointOrganizer[] getOrganizers() {
        return this.fResult.toArray(new IBreakpointOrganizer[this.fResult.size()]);
    }

    protected void okPressed() {
        Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)"org.eclipse.debug.core.PREF_FOR_BP_GROUP_TYPE_ACCELERATOR", (boolean)this.fBreakpointGroupAccel.getSelection(), null);
        Object[] factories = this.fSelectedOrganizersProvider.getElements(null);
        while (factories.length > 0) {
            Object factory = factories[0];
            this.fResult.add(factory);
            factories = this.fSelectedOrganizersProvider.getChildren(factory);
        }
        super.okPressed();
    }

    public void handleAddPressed() {
        IStructuredSelection selection = this.fAvailableViewer.getStructuredSelection();
        if (selection.size() < 1) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.fSelectedOrganizersProvider.addSelected((IBreakpointOrganizer)iter.next());
        }
        this.updateViewers();
    }

    public void handleRemovePressed() {
        ITreeSelection selection = this.fSelectedViewer.getStructuredSelection();
        if (selection.size() < 1) {
            return;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.fAvailableOrganizersProvider.addAvailable((IBreakpointOrganizer)iter.next());
        }
        this.updateViewers();
    }

    public void handleMoveUpPressed() {
        ITreeSelection selection = this.fSelectedViewer.getStructuredSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.fSelectedOrganizersProvider.moveUp(iter.next());
        }
        this.updateViewers();
    }

    public void handleMoveDownPressed() {
        ITreeSelection selection = this.fSelectedViewer.getStructuredSelection();
        Object[] elements = selection.toArray();
        int i = elements.length - 1;
        while (i >= 0) {
            this.fSelectedOrganizersProvider.moveDown(elements[i]);
            --i;
        }
        this.updateViewers();
    }

    public void updateViewers() {
        this.fAvailableViewer.refresh();
        this.fSelectedViewer.refresh();
        this.fSelectedViewer.expandAll();
        this.updateAddButton();
        this.updateSelectedButtons();
    }

    public void updateSelectedButtons() {
        this.updateRemoveButton();
        this.updateMoveUpButton();
        this.updateMoveDownButton();
    }

    public void updateAddButton() {
        IStructuredSelection selection = this.fAvailableViewer.getStructuredSelection();
        this.fAddButton.setEnabled(selection.size() > 0);
    }

    public void updateRemoveButton() {
        ITreeSelection selection = this.fSelectedViewer.getStructuredSelection();
        this.fRemoveButton.setEnabled(selection.size() > 0);
    }

    public void updateMoveUpButton() {
        boolean enabled = true;
        ITreeSelection selection = this.fSelectedViewer.getStructuredSelection();
        if (selection.size() == 0) {
            enabled = false;
        } else {
            Object firstSelected = selection.getFirstElement();
            Object parent = this.fSelectedOrganizersProvider.getParent(firstSelected);
            if (!(parent instanceof IBreakpointOrganizer)) {
                enabled = false;
            }
        }
        this.fMoveUpButton.setEnabled(enabled);
    }

    public void updateMoveDownButton() {
        boolean enabled = true;
        ITreeSelection selection = this.fSelectedViewer.getStructuredSelection();
        if (selection.size() == 0) {
            enabled = false;
        } else {
            Object lastSelected = selection.toList().get(selection.size() - 1);
            Object[] children = this.fSelectedOrganizersProvider.getChildren(lastSelected);
            if (children.length < 1) {
                enabled = false;
            }
        }
        this.fMoveDownButton.setEnabled(enabled);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(BreakpointGroupMessages.GroupBreakpointsByDialog_7);
    }

    private class AvailableOrganizersProvider
    implements IStructuredContentProvider {
        protected List<IBreakpointOrganizer> availableOrganziers = new ArrayList<IBreakpointOrganizer>();

        private AvailableOrganizersProvider() {
        }

        public void addAvailable(IBreakpointOrganizer organizer) {
            this.availableOrganziers.add(organizer);
            GroupBreakpointsByDialog.this.fSelectedOrganizersProvider.selectedOrganizers.remove(organizer);
        }

        public Object[] getElements(Object inputElement) {
            return this.availableOrganziers.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BreakpointOrganzierLabelProvider
    extends LabelProvider {
        private final HashMap<ImageDescriptor, Image> fImageCache = new HashMap();

        private BreakpointOrganzierLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBreakpointOrganizer) {
                return ((IBreakpointOrganizer)element).getLabel();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor;
            if (element instanceof IBreakpointOrganizer && (imageDescriptor = ((IBreakpointOrganizer)element).getImageDescriptor()) != null) {
                Image image = this.fImageCache.get(imageDescriptor);
                if (image == null && (image = imageDescriptor.createImage()) != null) {
                    this.fImageCache.put(imageDescriptor, image);
                }
                return image;
            }
            return super.getImage(element);
        }

        public void dispose() {
            for (Image image : this.fImageCache.values()) {
                image.dispose();
            }
            super.dispose();
        }
    }

    private class SelectedOrganizerProvider
    implements ITreeContentProvider {
        protected List<Object> selectedOrganizers = new ArrayList<Object>();

        private SelectedOrganizerProvider() {
        }

        public void addSelected(IBreakpointOrganizer organizer) {
            this.selectedOrganizers.add(organizer);
            GroupBreakpointsByDialog.this.fAvailableOrganizersProvider.availableOrganziers.remove(organizer);
        }

        public void moveUp(Object object) {
            int index = this.selectedOrganizers.indexOf(object);
            if (index > 0) {
                this.selectedOrganizers.remove(object);
                this.selectedOrganizers.add(index - 1, object);
            }
        }

        public void moveDown(Object object) {
            int index = this.selectedOrganizers.indexOf(object);
            if (index < this.selectedOrganizers.size() - 1) {
                this.selectedOrganizers.remove(object);
                this.selectedOrganizers.add(index + 1, object);
            }
        }

        public Object[] getChildren(Object parentElement) {
            int index = this.selectedOrganizers.indexOf(parentElement);
            if (index < this.selectedOrganizers.size() - 1) {
                return new Object[]{this.selectedOrganizers.get(index + 1)};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            int index = this.selectedOrganizers.indexOf(element);
            if (index <= 0 || this.selectedOrganizers.size() <= 1) {
                return null;
            }
            return this.selectedOrganizers.get(index - 1);
        }

        public boolean hasChildren(Object element) {
            int index = this.selectedOrganizers.indexOf(element);
            return index != -1 && index < this.selectedOrganizers.size() - 1;
        }

        public Object[] getElements(Object inputElement) {
            if (this.selectedOrganizers.size() > 0) {
                return new Object[]{this.selectedOrganizers.get(0)};
            }
            return new Object[0];
        }
    }
}

