/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.generator;

import java.util.function.Function;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.builder.MemorySourceBuilder;
import org.eclipse.scout.sdk.core.util.Ensure;

@FunctionalInterface
public interface ISourceGenerator<BUILDER extends ISourceBuilder<?>> {
    public void generate(BUILDER var1);

    default public ISourceGenerator<ISourceBuilder<?>> generalize(BUILDER specificBuilder) {
        return this.generalize(a -> Ensure.notNull(specificBuilder));
    }

    default public ISourceGenerator<ISourceBuilder<?>> generalize(Function<ISourceBuilder<?>, BUILDER> fromGenericToSpecificBuilder) {
        return b -> this.generate((ISourceBuilder)Ensure.notNull(fromGenericToSpecificBuilder).apply(b));
    }

    default public StringBuilder toSource(Function<ISourceBuilder<?>, BUILDER> fromGenericToSpecificBuilder, IBuilderContext context) {
        MemorySourceBuilder out = MemorySourceBuilder.create(context);
        this.generalize(fromGenericToSpecificBuilder).generate(out);
        return out.source();
    }

    public static <T extends ISourceBuilder<?>> ISourceGenerator<T> empty() {
        return b -> {};
    }

    public static <T extends ISourceBuilder<?>> ISourceGenerator<T> raw(CharSequence source) {
        Ensure.notNull(source);
        return b -> b.append(source);
    }
}

