/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.scout.sdk.core.java.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.internal.ClasspathEntryImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractSpiElement;
import org.eclipse.scout.sdk.core.java.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.util.SdkException;

public class ClasspathWithEcj
extends AbstractSpiElement<IClasspathEntry>
implements ClasspathSpi {
    private final Path m_path;
    private final int m_mode;
    private final boolean m_isDirectory;
    private final String m_encoding;
    private final int m_hashCode;

    protected ClasspathWithEcj(ClasspathEntry cp, AbstractJavaEnvironment env) {
        super((JavaEnvironmentSpi)env);
        this.m_path = cp.path();
        this.m_isDirectory = Files.isDirectory(this.m_path, new LinkOption[0]);
        this.m_encoding = cp.encoding();
        this.m_mode = cp.mode();
        this.m_hashCode = env.nextHashCode();
    }

    public Path getPath() {
        return this.m_path;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public int getMode() {
        return this.m_mode;
    }

    public boolean isDirectory() {
        return this.m_isDirectory;
    }

    protected IClasspathEntry internalCreateApi() {
        return new ClasspathEntryImplementor((ClasspathSpi)this);
    }

    public JavaElementSpi internalFindNewElement() {
        return null;
    }

    public boolean isSourceFolder() {
        return this.getMode() == 1 && this.isDirectory();
    }

    public final int hashCode() {
        return this.m_hashCode;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    private String modeName() {
        return switch (this.getMode()) {
            case 1 -> "SOURCE";
            case 2 -> "BINARY";
            case 3 -> "SOURCE & BINARY";
            default -> throw new SdkException((CharSequence)"Unknown mode: {}", new Object[]{this.getMode()});
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(ClasspathWithEcj.class.getSimpleName()).append(" [").append("path=").append(this.getPath()).append(", mode=").append(this.modeName()).append(']');
        return builder.toString();
    }
}

