/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.search.IJavaSearchDelegate;

public class JavaSearchDelegateDiscovery {
    private static final String SELECTED_SYSPROP = "IJavaSearchDelegate";
    private static final String EXTPOINT_ID = "javaSearchDelegate";
    private static boolean ERROR_LOGGED = false;
    private static String lastId;
    private static IConfigurationElement lastExtension;
    private static final Map<String, IJavaSearchDelegate> JAVA_SEARCH_DELEGATE_CACHE;

    static {
        JAVA_SEARCH_DELEGATE_CACHE = new HashMap<String, IJavaSearchDelegate>();
    }

    public static IJavaSearchDelegate getInstance() {
        block5: {
            String id = System.getProperty(SELECTED_SYSPROP);
            IConfigurationElement configElement = JavaSearchDelegateDiscovery.getConfigurationElement(id);
            lastId = id;
            lastExtension = configElement;
            if (configElement != null) {
                try {
                    if (JAVA_SEARCH_DELEGATE_CACHE.get(id) != null) {
                        return JAVA_SEARCH_DELEGATE_CACHE.get(id);
                    }
                    Object executableExtension = configElement.createExecutableExtension("class");
                    if (executableExtension instanceof IJavaSearchDelegate) {
                        IJavaSearchDelegate icep = (IJavaSearchDelegate)executableExtension;
                        JAVA_SEARCH_DELEGATE_CACHE.put(id, icep);
                        return icep;
                    }
                }
                catch (CoreException e) {
                    if (JavaSearchDelegateDiscovery.setErrorLogged()) break block5;
                    ILog.get().error("Could not instantiate IJavaSearchDelegate: '" + id + "' with class: " + configElement.getAttribute("class"), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static IConfigurationElement getConfigurationElement(String id) {
        if (id == null || id.isBlank()) {
            return null;
        }
        if (lastExtension != null && Objects.equals(id, lastId)) {
            return lastExtension;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String elementId = configElement.getAttribute("id");
                    if (id.equals(elementId) && "searchDelegate".equals(configElement.getName())) {
                        return configElement;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static synchronized boolean setErrorLogged() {
        boolean prev = ERROR_LOGGED;
        ERROR_LOGGED = true;
        return prev;
    }
}

