/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.commands;

import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class SetSteppingModeHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String ID_PARAMETER_MODE = "com.arm.eclipse.rvd.ui.command.steppingMode.parameterMode";
    private String fCurrentValue = CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_STEP_MODE);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String param = event.getParameter(ID_PARAMETER_MODE);
        if (param == null || param.equals(this.fCurrentValue)) {
            return null;
        }
        this.fCurrentValue = param;
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_STEP_MODE, this.fCurrentValue);
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ICommandService service = (ICommandService)window.getService(ICommandService.class);
        service.refreshElements(event.getCommand().getId(), null);
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String param = (String)parameters.get(ID_PARAMETER_MODE);
        if (param != null) {
            element.setChecked(this.fCurrentValue != null && this.fCurrentValue.equals(param));
        }
    }

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window != null && this.getSteppingModeTarget(window) != null;
    }

    public boolean isHandled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window != null && this.getSteppingModeTarget(window) != null;
    }

    private ISteppingModeTarget getSteppingModeTarget(IWorkbenchWindow window) {
        Object element;
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(window).getActiveContext();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            return (ISteppingModeTarget)((IAdaptable)element).getAdapter(ISteppingModeTarget.class);
        }
        return null;
    }
}

