/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.RefreshOperation;
import org.eclipse.mylyn.builds.internal.core.util.BuildScheduler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.Messages;

public class BuildRefresher
implements IPropertyChangeListener {
    private static final long STARTUP_DELAY = 5000L;
    private boolean running;
    private final IPreferenceStore preferenceStore;
    private final BuildScheduler scheduler;
    private RefreshJob refreshJob;

    public BuildRefresher(IPreferenceStore preferenceStore, BuildScheduler scheduler) {
        this.preferenceStore = preferenceStore;
        this.scheduler = scheduler;
    }

    private long getInterval() {
        return this.preferenceStore.getLong("refresh.interval");
    }

    public boolean isEnabled() {
        return this.running && this.preferenceStore.getBoolean("refresh.enabled");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("refresh.enabled") || event.getProperty().equals("refresh.interval")) {
            this.reschedule(0L);
        }
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException();
        }
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.running = true;
        this.reschedule(5000L);
    }

    void refresh() {
        if (this.refreshJob == null) {
            this.refreshJob = new RefreshJob();
            this.refreshJob.setSystem(true);
        }
        this.scheduler.schedule((Job)this.refreshJob, 0L);
    }

    private synchronized void reschedule(long delay) {
        if (this.isEnabled()) {
            if (this.refreshJob == null) {
                this.refreshJob = new RefreshJob();
                this.refreshJob.setSystem(true);
                this.refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (BuildRefresher.this.running) {
                            BuildRefresher.this.reschedule(BuildRefresher.this.getInterval());
                        }
                    }
                });
            }
            this.scheduler.schedule((Job)this.refreshJob, delay);
        } else if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
    }

    private class RefreshJob
    extends BuildJob {
        public RefreshJob() {
            super(Messages.BuildRefresher_backgroundBuildsRefresh);
            this.setUser(false);
        }

        protected IStatus doExecute(IOperationMonitor progress) {
            RefreshOperation refreshOperation = BuildsUiInternal.getFactory().getRefreshOperation();
            refreshOperation.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
            return refreshOperation.doExecute(progress);
        }
    }
}

