/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.AbstractIdDialog;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;

public class ParameterIdSelectionDialog
extends AbstractIdDialog<MParameter, MCommandParameter> {
    @Inject
    protected ModelEditor editor;
    protected MParameter parameter;
    protected Set<EStructuralFeature> parametersFeatures = new HashSet<EStructuralFeature>();
    protected Set<EStructuralFeature> commandsFeatures = new HashSet<EStructuralFeature>();

    @Inject
    public ParameterIdSelectionDialog(Shell parentShell, IModelResource resource, MParameter parameter, EditingDomain domain, EModelService modelService, @Translation Messages messages) {
        super(parentShell, resource, parameter, domain, modelService, messages);
        this.parameter = parameter;
        this.parametersFeatures.add((EStructuralFeature)MenuPackageImpl.Literals.HANDLED_ITEM__PARAMETERS);
        this.commandsFeatures.add((EStructuralFeature)MenuPackageImpl.Literals.HANDLED_ITEM__COMMAND);
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        FontDescriptor italicFontDescriptor = FontDescriptor.createFrom((Font)this.viewer.getControl().getFont()).setStyle(2);
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ComponentLabelProvider(this.editor, this.messages, italicFontDescriptor));
    }

    @Override
    protected String getShellTitle() {
        return this.messages.ParameterIdSelectionDialog_ShellTitle;
    }

    @Override
    protected String getDialogTitle() {
        return this.messages.ParameterIdSelectionDialog_DialogTitle;
    }

    @Override
    protected String getDialogMessage() {
        return this.messages.ParameterIdSelectionDialog_DialogMessage;
    }

    @Override
    protected String getLabelText() {
        return this.messages.ParameterIdSelectionDialog_LabelText;
    }

    @Override
    protected List<MCommandParameter> getViewerInput() {
        return this.getParametersOfParentNodesCommand();
    }

    @Override
    protected EAttribute getFeatureLiteral() {
        return CommandsPackageImpl.Literals.PARAMETER__NAME;
    }

    @Override
    protected String getListItemInformation(MCommandParameter listItem) {
        return null;
    }

    protected List<MCommandParameter> getParametersOfParentNodesCommand() {
        TreeIterator it = EcoreUtil.getAllContents((EObject)((EObject)this.resource.getRoot().get(0)), (boolean)true);
        while (it.hasNext()) {
            EObject containerObjectWithCommand = (EObject)it.next();
            if (containerObjectWithCommand == null || !this.canSupplyParameters(containerObjectWithCommand)) continue;
            List<MCommandParameter> commandParameters = this.getCommandParameters(containerObjectWithCommand);
            return commandParameters;
        }
        return Collections.emptyList();
    }

    protected boolean canSupplyParameters(EObject object) {
        return this.referencesCommand(object) && this.referencesParameters(object) && this.containsSearchedParameter(object);
    }

    protected boolean referencesCommand(EObject object) {
        EList eAllReferences = object.eClass().getEAllReferences();
        for (EReference r : eAllReferences) {
            if (!this.commandsFeatures.contains(r)) continue;
            return true;
        }
        return false;
    }

    protected boolean referencesParameters(EObject object) {
        EList eAllReferences = object.eClass().getEAllReferences();
        for (EReference r : eAllReferences) {
            if (!this.parametersFeatures.contains(r)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsSearchedParameter(EObject object) {
        for (EStructuralFeature parametersFeature : this.parametersFeatures) {
            Object parameters = object.eGet(parametersFeature);
            if (parameters == null || !(parameters instanceof Collection)) continue;
            return ((Collection)parameters).contains(this.parameter);
        }
        return false;
    }

    protected List<MCommandParameter> getCommandParameters(EObject containerObjectWithCommand) {
        Object command = containerObjectWithCommand.eGet((EStructuralFeature)MenuPackageImpl.Literals.HANDLED_ITEM__COMMAND);
        if (command != null && command instanceof MCommand) {
            List parameters = ((MCommand)command).getParameters();
            if (parameters != null) {
                return parameters;
            }
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("The parameter contains no MCommand");
    }
}

