/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.permission;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.DiagramSemanticElementLockedNotificationFigure;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.jface.viewers.IToolTipProvider;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class EditPartAuthorityListener
implements IAuthorityListener {
    private IGraphicalEditPart part;

    public EditPartAuthorityListener(IGraphicalEditPart part) {
        this.part = part;
    }

    public void notifyIsLocked(EObject instance) {
        if (this.shouldRefresh(instance)) {
            this.refreshEditMode();
        }
    }

    public void notifyIsReleased(EObject instance) {
        if (this.shouldRefresh(instance)) {
            this.refreshEditMode();
        }
    }

    public void notifyIsLocked(Collection<EObject> instances) {
        for (EObject eObject : instances) {
            if (!this.shouldRefresh(eObject)) continue;
            this.refreshEditMode();
            return;
        }
    }

    public void notifyIsReleased(Collection<EObject> instances) {
        for (EObject eObject : instances) {
            if (!this.shouldRefresh(eObject)) continue;
            this.refreshEditMode();
            return;
        }
    }

    private boolean shouldRefresh(EObject instance) {
        EObject element;
        boolean shouldRefresh = false;
        if (instance != null && this.part.isActive() && (element = this.part.resolveSemanticElement()) instanceof DSemanticDecorator) {
            DSemanticDecorator semanticDecorator = (DSemanticDecorator)element;
            EObject target = semanticDecorator.getTarget();
            boolean isConcerningEditPart = instance.equals(target) || instance.equals(semanticDecorator);
            boolean isConcerningDiagramEditPart = target != null && instance instanceof DDiagram && semanticDecorator instanceof DDiagramElement && instance.equals(((DDiagramElement)semanticDecorator).getParentDiagram());
            shouldRefresh = isConcerningEditPart || isConcerningDiagramEditPart;
        }
        return shouldRefresh;
    }

    public void refreshEditMode() {
        Option<DDiagramEditor> diagramEditorIfAny = this.getDDiagramEditor();
        if (diagramEditorIfAny.some()) {
            final DDiagramEditor diagramEditor = (DDiagramEditor)diagramEditorIfAny.get();
            final EObject semanticElement = this.part.resolveSemanticElement();
            IPermissionAuthority auth = diagramEditor.getPermissionAuthority();
            final boolean enableEditMode = auth.canEditInstance(semanticElement);
            boolean refreshShouldBePerformedSynchronously = DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiPreferencesKeys.PREF_REFRESH_DECORATORS_SYNCHRONOUSLY.name());
            if (refreshShouldBePerformedSynchronously) {
                this.doRefreshEditMode(enableEditMode, diagramEditor, semanticElement);
            } else {
                EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Optional.ofNullable(diagramEditor).map(DDiagramEditor::getSession).filter(Session::isOpen).isPresent()) {
                            EditPartAuthorityListener.this.doRefreshEditMode(enableEditMode, diagramEditor, semanticElement);
                        }
                    }
                });
            }
        }
    }

    protected void doRefreshEditMode(boolean enableEditMode, DDiagramEditor diagramEditor, EObject semanticElement) {
        if (!enableEditMode || !this.isTargetValid(semanticElement)) {
            this.part.disableEditMode();
        } else {
            this.part.enableEditMode();
        }
        DecorationEditPolicy decorationEditPolicy = (DecorationEditPolicy)this.part.getEditPolicy((Object)"DecorationPolicy");
        if (decorationEditPolicy != null && this.part.getParent() != null && this.part.getRoot() != null) {
            decorationEditPolicy.refresh();
        }
        this.doRefreshRootSemanticElementEditMode(diagramEditor, semanticElement);
    }

    private void doRefreshRootSemanticElementEditMode(DDiagramEditor diagramEditor, EObject semanticElement) {
        DDiagramEditPart ddep;
        RootEditPart rootEditPart;
        if (this.part instanceof DDiagramEditPart && semanticElement instanceof DSemanticDecorator && (rootEditPart = (ddep = (DDiagramEditPart)this.part).getRoot()) instanceof DiagramRootEditPart) {
            try {
                EObject target = ((DSemanticDecorator)semanticElement).getTarget();
                LockStatus lockStatus = diagramEditor.getPermissionAuthority().getLockStatus(target);
                switch (lockStatus) {
                    case LOCKED_BY_ME: {
                        DiagramSemanticElementLockedNotificationFigure.createNotification((DiagramRootEditPart)rootEditPart, LockStatus.LOCKED_BY_ME);
                        break;
                    }
                    case LOCKED_BY_OTHER: {
                        String tooltip = "";
                        IToolTipProvider tooltipProvider = (IToolTipProvider)Platform.getAdapterManager().getAdapter((Object)semanticElement, IToolTipProvider.class);
                        if (tooltipProvider != null) {
                            tooltip = tooltipProvider.getToolTipText((Object)target);
                        }
                        DiagramSemanticElementLockedNotificationFigure.createNotification((DiagramRootEditPart)rootEditPart, "", tooltip, LockStatus.LOCKED_BY_OTHER);
                        break;
                    }
                    default: {
                        DiagramSemanticElementLockedNotificationFigure.removeNotification((DiagramRootEditPart)rootEditPart);
                        break;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private boolean isTargetValid(EObject semanticElement) {
        boolean result = false;
        try {
            EObject target;
            result = semanticElement instanceof DDiagramElement ? (target = ((DDiagramElement)semanticElement).getTarget()) != null && target.eResource() != null : true;
        }
        catch (IllegalStateException illegalStateException) {
            result = false;
        }
        return result;
    }

    public boolean isLocked() {
        DDiagramEditor diagramEditor;
        if (this.part.getParent() != null && this.part.getRoot() != null && (diagramEditor = (DDiagramEditor)this.part.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")) != null) {
            IPermissionAuthority auth = diagramEditor.getPermissionAuthority();
            return !auth.canEditInstance(this.part.resolveSemanticElement());
        }
        return false;
    }

    private Option<DDiagramEditor> getDDiagramEditor() {
        Option diagramEditor = Options.newNone();
        try {
            diagramEditor = Options.newSome((Object)((DDiagramEditor)this.part.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID")));
        }
        catch (NullPointerException nullPointerException) {}
        return diagramEditor;
    }
}

