/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;
import org.eclipse.emf.cdo.internal.migrator.tasks.ExpandTemplateTask;

public class TransferMembersTask
extends ExpandTemplateTask {
    private final List<SourceClass> sourceClasses = new ArrayList<SourceClass>();
    private String importsPlaceholder = "IMPORTS";
    private String fieldsPlaceholder = "FIELDS";
    private String methodsPlaceholder = "METHODS";

    public SourceClass createSourceClass() {
        SourceClass sourceClass = new SourceClass();
        this.sourceClasses.add(sourceClass);
        return sourceClass;
    }

    public void setImportsPlaceholder(String importsPlaceholder) {
        this.importsPlaceholder = importsPlaceholder;
    }

    public void setFieldsPlaceholder(String fieldsPlaceholder) {
        this.fieldsPlaceholder = fieldsPlaceholder;
    }

    public void setMethodsPlaceholder(String methodsPlaceholder) {
        this.methodsPlaceholder = methodsPlaceholder;
    }

    @Override
    protected void checkAttributes() throws BuildException {
        super.checkAttributes();
        for (SourceClass sourceClass : this.sourceClasses) {
            sourceClass.checkAttributes();
        }
        TransferMembersTask.assertTrue("'importsPlaceholder' must be specified.", this.importsPlaceholder != null && this.importsPlaceholder.length() != 0);
        TransferMembersTask.assertTrue("'fieldsPlaceholder' must be specified.", this.fieldsPlaceholder != null && this.fieldsPlaceholder.length() != 0);
        TransferMembersTask.assertTrue("'methodsPlaceholder' must be specified.", this.methodsPlaceholder != null && this.methodsPlaceholder.length() != 0);
    }

    @Override
    protected String generate(String content, Map<String, String> properties) throws Exception {
        Collector collector = new Collector(this);
        for (SourceClass sourceClass : this.sourceClasses) {
            collector.collect(sourceClass);
        }
        properties.put(this.importsPlaceholder, this.formatImports(collector.imports.keySet()));
        properties.put(this.fieldsPlaceholder, this.formatMembers(collector.fields.values()));
        properties.put(this.methodsPlaceholder, this.formatMembers(collector.methods.values()));
        return super.generate(content, properties);
    }

    private String formatImports(Collection<String> imports) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : imports) {
            if (first) {
                first = false;
            } else {
                builder.append(NL);
            }
            builder.append("import ");
            builder.append(name);
            builder.append(";");
        }
        return builder.toString();
    }

    private String formatMembers(Collection<List<String>> members) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (List<String> texts : members) {
            for (String text : texts) {
                if (first) {
                    first = false;
                } else {
                    builder.append(NL);
                    builder.append(NL);
                }
                builder.append(text);
            }
        }
        return builder.toString();
    }

    private static final class Collector {
        private static final Pattern IMPORT_PATTERN = Pattern.compile("[\\\\t ]*import\\s+([^;]+);");
        private static final Pattern FIELD_PATTERN = Pattern.compile("[\\\\t ]*((public|private|protected|static|final|transient|volatile)+\\s)+[\\$_\\w\\<\\>\\[\\]]*\\s+([\\$_\\w]+)\\s*(;|=[^;]*;)");
        private static final Pattern METHOD_PATTERN = Pattern.compile("[\\t ]*((public|private|protected|static|final|native|synchronized|abstract|strictfp)+\\s)+[\\$_\\w\\<\\>\\[\\]]*\\s+(([\\$_\\w]+)\\([^\\)]*\\)?)[^\\{;]*(.)");
        public final Map<String, List<String>> imports = new LinkedHashMap<String, List<String>>();
        public final Map<String, List<String>> fields = new LinkedHashMap<String, List<String>>();
        public final Map<String, List<String>> methods = new LinkedHashMap<String, List<String>>();
        private final CDOTask task;

        public Collector(CDOTask task) {
            this.task = task;
        }

        public void collect(SourceClass sourceClass) throws IOException {
            String content = TransferMembersTask.readTextFile(sourceClass.getFile());
            if (sourceClass.isImports()) {
                this.task.verbose("Collecting imports of " + String.valueOf(sourceClass));
                this.collect(content, IMPORT_PATTERN, 1, null, this.imports);
            }
            if (!sourceClass.getSourceFields().isEmpty()) {
                this.task.verbose("Collecting fields of " + String.valueOf(sourceClass));
                this.collect(content, FIELD_PATTERN, 3, sourceClass.getSourceFields(), this.fields);
            }
            if (!sourceClass.getSourceMethods().isEmpty()) {
                this.task.verbose("Collecting methods of " + String.valueOf(sourceClass));
                this.collect(content, METHOD_PATTERN, 4, sourceClass.getSourceMethods(), this.methods);
            }
        }

        private void collect(String content, Pattern pattern, int group, List<? extends SourceClass.SourceMember> sourceMembers, Map<String, List<String>> result) {
            Matcher matcher = pattern.matcher(content);
            int matcherStart = 0;
            while (matcher.find(matcherStart)) {
                String braceOrSemicolon;
                String name = matcher.group(group);
                Object text = matcher.group(0);
                matcherStart = matcher.end() + 1;
                if (pattern == METHOD_PATTERN && (braceOrSemicolon = matcher.group(5)).equals("{")) {
                    int start = matcherStart - 1;
                    int end = content.length();
                    int nesting = 1;
                    int i = start;
                    while (i < end) {
                        char c = content.charAt(i);
                        if (c == '{') {
                            ++nesting;
                        } else if (c == '}' && --nesting == 0) {
                            matcherStart = i + 1;
                            String body = content.substring(start, matcherStart);
                            text = (String)text + body;
                            break;
                        }
                        ++i;
                    }
                }
                if (sourceMembers != null && !Collector.matchName(name, sourceMembers)) continue;
                List<String> texts = result.get(name);
                if (texts == null) {
                    texts = new ArrayList<String>();
                    result.put(name, texts);
                }
                texts.add((String)text);
                this.task.verbose("   " + name);
            }
        }

        private static boolean matchName(String name, List<? extends SourceClass.SourceMember> sourceMembers) {
            for (SourceClass.SourceMember sourceMember : sourceMembers) {
                Pattern pattern = sourceMember.getPattern();
                if (!pattern.matcher(name).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static final class SourceClass {
        private File file;
        private boolean imports = true;
        private final List<SourceField> sourceFields = new ArrayList<SourceField>();
        private final List<SourceMethod> sourceMethods = new ArrayList<SourceMethod>();

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public boolean isImports() {
            return this.imports;
        }

        public void setImports(boolean imports) {
            this.imports = imports;
        }

        public List<SourceField> getSourceFields() {
            return this.sourceFields;
        }

        public SourceField createSourceField() {
            SourceField sourceField = new SourceField();
            this.sourceFields.add(sourceField);
            return sourceField;
        }

        public List<SourceMethod> getSourceMethods() {
            return this.sourceMethods;
        }

        public SourceMethod createSourceMethod() {
            SourceMethod sourceMethod = new SourceMethod();
            this.sourceMethods.add(sourceMethod);
            return sourceMethod;
        }

        public String toString() {
            return String.valueOf(this.file);
        }

        public void checkAttributes() throws BuildException {
            TransferMembersTask.assertTrue("'file' must be specified.", this.file != null);
            TransferMembersTask.assertTrue("'file' must be point to an existing file.", this.file.isFile());
            SourceClass.checkSourceMembers(this.sourceFields);
            SourceClass.checkSourceMembers(this.sourceMethods);
        }

        private static void checkSourceMembers(List<? extends SourceMember> sourceMembers) {
            for (SourceMember sourceMember : sourceMembers) {
                Pattern pattern = sourceMember.getPattern();
                TransferMembersTask.assertTrue("'match' must be specified.", pattern != null);
            }
        }

        public static final class SourceField
        extends SourceMember {
            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("SourceField[");
                builder.append(this.getPattern());
                builder.append("]");
                return builder.toString();
            }
        }

        public static abstract class SourceMember {
            private Pattern pattern;

            public Pattern getPattern() {
                return this.pattern;
            }

            public void setMatch(String regex) {
                this.pattern = Pattern.compile(regex);
            }
        }

        public static final class SourceMethod
        extends SourceMember {
            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("SourceMethod[");
                builder.append(this.getPattern());
                builder.append("]");
                return builder.toString();
            }
        }
    }
}

