/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.scoping;

import java.beans.Introspector;
import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.parsley.dsl.model.EmfFeatureAccess;
import org.eclipse.emf.parsley.dsl.scoping.AbstractEmfParsleyDslScopeProvider;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslModelUtil;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EmfParsleyDslScopeProvider
extends AbstractEmfParsleyDslScopeProvider {
    public IScope getScope(EObject context, EReference reference) {
        IScope scope = this.createCustomScope(context, reference);
        if (scope != null) {
            return scope;
        }
        return super.getScope(context, reference);
    }

    public IScope createCustomScope(EObject context, EReference reference) {
        EClass jvmMember;
        EClassifier eType = reference.getEType();
        if (Objects.equals(eType, jvmMember = TypesPackage.eINSTANCE.getJvmMember())) {
            EmfFeatureAccess containingEmfFeatureAccess = EmfParsleyDslModelUtil.containingEmfFeatureAccess(context);
            JvmTypeReference parameterType = null;
            if (containingEmfFeatureAccess != null) {
                parameterType = containingEmfFeatureAccess.getParameterType();
            }
            JvmType type = null;
            if (parameterType != null) {
                type = parameterType.getType();
            }
            return this.customScope(type);
        }
        return null;
    }

    protected IScope customScope(JvmType jvmType) {
        if (jvmType instanceof JvmGenericType) {
            JvmGenericType t = (JvmGenericType)jvmType;
            Iterable jvmOperations = IterableExtensions.filter((Iterable)t.getAllFeatures(), JvmOperation.class);
            Iterable nonStaticOperations = IterableExtensions.filter((Iterable)jvmOperations, it -> !it.isStatic());
            Iterable scopedElementsFor = Scopes.scopedElementsFor((Iterable)nonStaticOperations, it -> {
                if (this.isGetterMethod(it.getSimpleName())) {
                    return QualifiedName.create((String)this.getPropertyNameForGetterMethod(it.getSimpleName()));
                }
                return null;
            });
            return new SimpleScope(scopedElementsFor);
        }
        return null;
    }

    private boolean isGetterMethod(String opName) {
        return this.getterMethodForNonBoolean(opName) || this.getterMethodForBoolean(opName);
    }

    private String getPropertyNameForGetterMethod(String opName) {
        if (this.getterMethodForNonBoolean(opName)) {
            return Introspector.decapitalize(opName.substring(3));
        }
        return Introspector.decapitalize(opName.substring(2));
    }

    private boolean getterMethodForBoolean(String opName) {
        return this.getterMethodInternal(opName, "is");
    }

    private boolean getterMethodForNonBoolean(String opName) {
        return this.getterMethodInternal(opName, "get");
    }

    private boolean getterMethodInternal(String opName, String prefix) {
        return opName.startsWith(prefix) && opName.length() > prefix.length() && Character.isUpperCase(opName.charAt(prefix.length()));
    }
}

