/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectUtil;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.ui.internal.handlers.StructuredSelectEnclosingXMLHandler;

public class StructureSelectEnclosingHandler
extends StructuredSelectEnclosingXMLHandler {
    private ISourceModule sourceModule = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.sourceModule = StructureSelectUtil.getSourceModule(event);
        super.execute(event);
        this.sourceModule = null;
        return null;
    }

    protected Region getNewSelectionRegion(IndexedRegion indexedRegion, ITextSelection textSelection) {
        if (this.sourceModule != null && StructureSelectUtil.isPHP(indexedRegion)) {
            Selection selection = Selection.createFromStartLength((int)textSelection.getOffset(), (int)textSelection.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            try {
                Program ast = StructureSelectUtil.getAST(this.sourceModule);
                ast.accept((Visitor)selAnalyzer);
                ASTNode first = selAnalyzer.getFirstSelectedNode();
                if (first == null || first.getParent() == null) {
                    return StructureSelectUtil.getLastCoveringNodeRange(new Region(textSelection.getOffset(), textSelection.getLength()), (ISourceReference)this.sourceModule, selAnalyzer);
                }
                return StructureSelectUtil.getSelectedNodeSourceRange((ISourceReference)this.sourceModule, first.getParent());
            }
            catch (ModelException modelException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getNewSelectionRegion(indexedRegion, textSelection);
    }
}

