/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.snippets;

import java.util.Map;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.snippets.IXMLSnippetContext;

public class DocTypeSnippetContext
implements IXMLSnippetContext {
    private static final String ROOT_ELEMENT = "root-element";
    public static IXMLSnippetContext DEFAULT_CONTEXT = new DocTypeSnippetContext();

    @Override
    public boolean isMatch(ICompletionRequest request, Map<String, String> model) {
        DOMDocument document = request.getXMLDocument();
        DOMElement documentElement = document.getDocumentElement();
        if (documentElement == null) {
            return false;
        }
        if (document.getDoctype() != null) {
            return false;
        }
        String tagName = documentElement.getTagName();
        if (tagName == null && documentElement.hasChildNodes() && documentElement.getChild(0).isElement()) {
            documentElement = (DOMElement)documentElement.getChild(0);
            tagName = documentElement.getTagName();
        }
        if (tagName == null) {
            return false;
        }
        DOMNode node = request.getNode();
        DOMNode parent = node.getParentNode();
        if (parent != null && parent.isDoctype()) {
            return false;
        }
        int offset = request.getOffset();
        if ((node.isComment() || node.isProcessingInstruction() || node.isProlog()) && offset < node.getEnd()) {
            return false;
        }
        if (document.isBeforeProlog(offset)) {
            return false;
        }
        if (offset > documentElement.getStart()) {
            return false;
        }
        for (DOMNode previous = documentElement.getPreviousSibling(); previous != null; previous = previous.getPreviousSibling()) {
            if (previous.isText() || previous.isProlog() || previous.isProcessingInstruction() || previous.isComment()) continue;
            return false;
        }
        model.put(ROOT_ELEMENT, tagName);
        return true;
    }
}

