/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.startup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.internal.discovery.DiscoveryActivator;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class UpdateConfigurationStartup
implements IStartup {
    private static final String PROJECT_PREF = "org.eclipse.m2e.discovery.pref.projects";

    public void earlyStartup() {
        List<IProject> projects = UpdateConfigurationStartup.getSavedProjects();
        if (!projects.isEmpty()) {
            UpdateConfigurationStartup.updateConfiguration(projects);
        }
        UpdateConfigurationStartup.disableStartup();
    }

    public static void enableStartup() {
        UpdateConfigurationStartup.saveMarkedProjects();
        UpdateConfigurationStartup.addEarlyStartup();
    }

    public static void enableStartup(Collection<String> knownProjects) {
        if (knownProjects != null) {
            HashSet<String> projects = new HashSet<String>(knownProjects);
            for (IProject project : UpdateConfigurationStartup.getMarkedProjects()) {
                projects.add(project.getName());
            }
            UpdateConfigurationStartup.saveProjects(projects);
        } else {
            UpdateConfigurationStartup.saveMarkedProjects();
        }
        UpdateConfigurationStartup.addEarlyStartup();
    }

    public static void disableStartup() {
        UpdateConfigurationStartup.clearSavedProjects();
        UpdateConfigurationStartup.removeEarlyStartup();
    }

    public static void updateConfiguration() {
        Collection<IProject> projects = UpdateConfigurationStartup.getMarkedProjects();
        UpdateConfigurationStartup.updateConfiguration(projects);
    }

    private static void updateConfiguration(Collection<IProject> projects) {
        new UpdateMavenProjectJob(projects).schedule();
    }

    private static void addEarlyStartup() {
        String[] disabledEarlyActivation = Workbench.getInstance().getDisabledEarlyActivatedPlugins();
        if (!UpdateConfigurationStartup.isDisabled(disabledEarlyActivation)) {
            return;
        }
        String[] disabledPlugins = new String[disabledEarlyActivation.length - 1];
        int index = 0;
        String[] stringArray = disabledEarlyActivation;
        int n = disabledEarlyActivation.length;
        int n2 = 0;
        while (n2 < n) {
            String plugin = stringArray[n2];
            if (!"org.eclipse.m2e.discovery".equals(plugin)) {
                disabledPlugins[index] = plugin;
            }
            ++n2;
        }
        UpdateConfigurationStartup.setEarlyActivationPreference(disabledPlugins);
    }

    private static void removeEarlyStartup() {
        String[] disabledEarlyActivation = Workbench.getInstance().getDisabledEarlyActivatedPlugins();
        if (UpdateConfigurationStartup.isDisabled(disabledEarlyActivation)) {
            return;
        }
        String[] disabledPlugins = new String[disabledEarlyActivation.length + 1];
        System.arraycopy(disabledEarlyActivation, 0, disabledPlugins, 0, disabledEarlyActivation.length);
        disabledPlugins[disabledPlugins.length - 1] = "org.eclipse.m2e.discovery";
        UpdateConfigurationStartup.setEarlyActivationPreference(disabledPlugins);
    }

    private static boolean isDisabled(String[] disabledEarlyActivation) {
        String[] stringArray = disabledEarlyActivation;
        int n = disabledEarlyActivation.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if ("org.eclipse.m2e.discovery".equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void setEarlyActivationPreference(String[] disabledPlugins) {
        StringBuilder preference = new StringBuilder();
        String[] stringArray = disabledPlugins;
        int n = disabledPlugins.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            preference.append(item).append(';');
            ++n2;
        }
        IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
        store.putValue("PLUGINS_NOT_ACTIVATED_ON_STARTUP", preference.toString());
        PrefUtil.savePrefs();
    }

    public static List<IProject> getSavedProjects() {
        String[] projectNames = DiscoveryActivator.getDefault().getPreferenceStore().getString(PROJECT_PREF).split(String.valueOf(';'));
        ArrayList<IProject> projects = new ArrayList<IProject>(projectNames.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = projectNames;
        int n = projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            String projectName = stringArray[n2];
            if (projectName.length() > 0 && (project = root.getProject(projectName)) != null) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }

    public static void saveMarkedProjects() {
        StringBuilder sb = new StringBuilder();
        for (IProject project : UpdateConfigurationStartup.getMarkedProjects()) {
            sb.append(project.getName()).append(';');
        }
        DiscoveryActivator.getDefault().getPreferenceStore().putValue(PROJECT_PREF, sb.toString());
    }

    public static void saveProjects(Collection<String> projects) {
        StringBuilder sb = new StringBuilder();
        for (String project : projects) {
            sb.append(project).append(';');
        }
        DiscoveryActivator.getDefault().getPreferenceStore().putValue(PROJECT_PREF, sb.toString());
    }

    private static Collection<IProject> getMarkedProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        MultiStatus status = new MultiStatus("org.eclipse.m2e.discovery", 0, Messages.UpdateConfigurationStartup_MarkerError, null);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.findMarkers("org.eclipse.m2e.core.maven2Problem.lifecycleMapping", true, 1).length > 0) {
                    projects.add(project);
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++n2;
        }
        if (status.getChildren().length > 0) {
            StatusManager.getManager().handle((IStatus)status);
        }
        return projects;
    }

    public static void clearSavedProjects() {
        DiscoveryActivator.getDefault().getPreferenceStore().putValue(PROJECT_PREF, "");
    }
}

