/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewTaskFromSelectionAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.actions.newTaskFromSelection";
    private ITaskMapping taskMapping;

    public NewTaskFromSelectionAction() {
        super(Messages.NewTaskFromSelectionAction_New_Task_from_Selection);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
    }

    public ITaskMapping getTaskMapping() {
        return this.taskMapping;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.taskMapping == null) {
            MessageDialog.openError(null, (String)Messages.NewTaskFromSelectionAction_New_Task_from_Selection, (String)Messages.NewTaskFromSelectionAction_Nothing_selected_to_create_task_from);
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        TasksUiUtil.openNewTaskEditor(shell, this.taskMapping, null);
    }

    public void selectionChanged(ISelection selection) {
        Object element;
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            final String text = textSelection.getText();
            this.taskMapping = text != null && text.length() > 0 ? new TaskMapping(){

                public String getDescription() {
                    return text;
                }
            } : null;
        } else if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITaskComment) {
            ITaskComment comment = (ITaskComment)element;
            final StringBuilder sb = new StringBuilder();
            sb.append("\n" + Messages.NewTaskFromSelectionAction____Created_from_Comment___);
            if (comment.getUrl() == null) {
                sb.append("\n" + Messages.NewTaskFromSelectionAction_URL_);
                sb.append(comment.getTask().getUrl());
                sb.append("\n" + Messages.NewTaskFromSelectionAction_Comment_);
                sb.append(comment.getNumber());
            } else {
                sb.append("\n" + Messages.NewTaskFromSelectionAction_URL_);
                sb.append(comment.getUrl());
            }
            sb.append("\n\n");
            sb.append(comment.getText());
            this.taskMapping = new TaskMapping(){

                public String getDescription() {
                    return sb.toString();
                }
            };
        }
        this.setEnabled(this.taskMapping != null);
    }
}

