/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.execute;

import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStringHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterMarkers;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ResultTableViewer;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;

public class ExecuteViewer
extends Dialog {
    private Text statementSource;
    private Button executeButton;
    private ResultTableViewer resultTableViewer;
    private PageBook pageBook;
    private ResultTableViewer blankResultTable;
    private ProgressMonitorPart progressMonitor;
    private Label msgLabel;
    protected List resultList;
    private int fieldWidth = 10;
    QueryStatement sqlStatement;
    QueryStatement previousExecutedStmt;
    protected Object inputElement;
    protected SQLDomainModel domainModel;
    protected Composite mainUIComponent;

    public ExecuteViewer(Shell shell, Object element, SQLDomainModel domain) {
        super(shell);
        this.inputElement = element;
        this.domainModel = domain;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages._UI_DIALOG_EXECUTE_SQL_TITLE);
        Shell parentShell = (Shell)shell.getParent();
        if (parentShell != null) {
            int locX = parentShell.getLocation().x;
            int locY = parentShell.getLocation().y;
            shell.setBounds(locX, locY, 690, 590);
        }
    }

    public Control getControl() {
        return this.mainUIComponent;
    }

    public void createButtonsForButtonBar(Composite parent) {
        this.executeButton = this.createButton(parent, 0, Messages._UI_BUTTON_EXECUTE, true);
        this.createButton(parent, 1, Messages._UI_BUTTON_EXECUTE_CLOSE, false);
    }

    public Control createDialogArea(Composite parent) {
        this.mainUIComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.mainUIComponent.setLayout((Layout)layout);
        this.mainUIComponent.setLayoutData((Object)ViewUtility.createFill());
        Composite group = ViewUtility.createComposite(this.mainUIComponent, 1);
        GridData stmtGridData = (GridData)group.getLayoutData();
        stmtGridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)stmtGridData);
        ViewUtility.createLabel(group, Messages._UI_LABEL_SQL_STATEMENT);
        this.statementSource = ViewUtility.createTextField(group, this.fieldWidth);
        this.statementSource.setEditable(false);
        Composite labelGroup = ViewUtility.createComposite(this.mainUIComponent, 1);
        GridData groupGridData = (GridData)group.getLayoutData();
        groupGridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)groupGridData);
        ViewUtility.createLabel(labelGroup, Messages._UI_LABEL_QUERY_RESULTS);
        this.msgLabel = ViewUtility.createLabel(labelGroup, Messages._UI_LABEL_EXECUTION_SUCCESSFUL);
        GridData labelGridData = (GridData)this.msgLabel.getLayoutData();
        labelGridData.grabExcessHorizontalSpace = true;
        this.msgLabel.setLayoutData((Object)labelGridData);
        this.pageBook = new PageBook(this.mainUIComponent, 0);
        this.resultTableViewer = new ResultTableViewer(67586, null, (Composite)this.pageBook);
        this.blankResultTable = new ResultTableViewer(67586, null, (Composite)this.pageBook);
        this.pageBook.setLayoutData((Object)ViewUtility.createFill());
        this.pageBook.showPage(this.resultTableViewer.getControl());
        ViewUtility.createLabel(this.mainUIComponent, "");
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 1;
        gLayout.makeColumnsEqualWidth = true;
        this.progressMonitor = new ProgressMonitorPart(this.mainUIComponent, (Layout)gLayout);
        this.progressMonitor.setVisible(false);
        this.msgLabel.setText("");
        this.setInput(this.inputElement);
        return this.mainUIComponent;
    }

    public void setElement(QueryStatement newElement) {
        this.sqlStatement = newElement;
    }

    public QueryStatement getElement() {
        return this.sqlStatement;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.setReturnCode(1);
            this.close();
            return;
        }
        QueryStatement statement = this.getElement();
        if (statement instanceof QueryStatement && buttonId == 0) {
            block17: {
                this.pageBook.showPage(this.blankResultTable.getControl());
                this.progressMonitor.setVisible(true);
                this.progressMonitor.beginTask(Messages._UI_MONITOR_EXECUTING_QUERY, 60);
                Connection jdbcConnection = null;
                try {
                    this.progressMonitor.worked(5);
                    jdbcConnection = this.domainModel.getConnection();
                    this.progressMonitor.worked(20);
                    if (jdbcConnection != null) {
                        boolean continueExecution = this.substituteParameters();
                        if (!continueExecution) break block17;
                        try {
                            Statement stmt = jdbcConnection.createStatement();
                            boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                            if (setLimit) {
                                int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                                stmt.setMaxRows(integer);
                            } else {
                                stmt.setMaxRows(0);
                            }
                            String source = this.statementSource.getText();
                            stmt.execute(source);
                            ResultSet resultSet = null;
                            if (statement instanceof QuerySelectStatement) {
                                resultSet = stmt.getResultSet();
                            }
                            this.progressMonitor.worked(20);
                            this.previousExecutedStmt = statement;
                            if (resultSet != null && statement instanceof QuerySelectStatement) {
                                ResultTableViewer newTable = new ResultTableViewer(67586, resultSet, (Composite)this.pageBook);
                                this.resultTableViewer.getControl().dispose();
                                this.resultTableViewer = newTable;
                                this.resultTableViewer.setInput(this.getElement());
                                this.pageBook.showPage(this.resultTableViewer.getControl());
                                this.resultTableViewer.setLinesVisible(true);
                                this.progressMonitor.worked(20);
                                int numDisplayed = this.resultTableViewer.getRecordsDisplayedCount();
                                if (numDisplayed >= 1000) {
                                    this.msgLabel.setText(Messages._UI_MSG_MAX_RECORD_EXCEEDED);
                                } else {
                                    this.msgLabel.setText(String.valueOf(numDisplayed) + " " + Messages._UI_MSG_RECORD_RETURNED);
                                }
                                SQLWarning rsWarningMsgs = resultSet.getWarnings();
                                if (rsWarningMsgs != null) {
                                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages._UI_DIALOG_WARNING_TITLE, (String)Messages._WARN_MESSAGES_ENCOUNTERED, (IStatus)this.createStatus(rsWarningMsgs));
                                }
                                break block17;
                            }
                            if (!(statement instanceof QuerySelectStatement)) {
                                this.resultTableViewer.getControl().dispose();
                                this.progressMonitor.worked(20);
                                this.msgLabel.setText(Messages._UI_LABEL_EXECUTION_SUCCESSFUL);
                                break block17;
                            }
                            this.resultTableViewer.getControl().dispose();
                            this.progressMonitor.worked(20);
                        }
                        catch (Exception exception) {
                            this.progressMonitor.worked(40);
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages._UI_DIALOG_OP_FAILED_TITLE, (String)exception.toString());
                        }
                        break block17;
                    }
                    this.progressMonitor.worked(40);
                }
                catch (NoSuchElementException noSuchElementException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages._UI_DIALOG_OP_FAILED_TITLE, (String)Messages._UI_LABEL_NO_CONNECTION);
                }
                catch (WrappedException e) {
                    String msg = e.exception() instanceof FileNotFoundException ? String.valueOf(Messages._UI_LABEL_NO_CONNECTION_FILE) + "\n\n" + e.exception().toString() : e.toString();
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages._UI_DIALOG_OP_FAILED_TITLE, (String)msg);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages._UI_DIALOG_OP_FAILED_TITLE, (String)e.toString());
                }
            }
            this.progressMonitor.done();
            this.progressMonitor.setVisible(false);
        }
    }

    public IStatus createStatus(SQLWarning except) {
        String pluginId = SQLBuilderPlugin.getPlugin().getBundle().getSymbolicName();
        String reason = "";
        reason = except instanceof DataTruncation ? Messages._WARN_DATA_WAS_TRUNCATED : Messages._WARN_SQL_WARNINGS_FOUND;
        MultiStatus multiStatus = new MultiStatus(pluginId, 0, reason, null);
        do {
            Status status = new Status(4, pluginId, 0, "SQLState=" + except.getSQLState() + " " + except.getMessage(), null);
            multiStatus.add((IStatus)status);
        } while ((except = except.getNextWarning()) != null);
        return multiStatus;
    }

    private boolean substituteParameters() {
        ParameterMarkers pm = new ParameterMarkers(this.sqlStatement);
        String result = pm.substituteParameters();
        this.statementSource.setText(this.removeControlChars(result));
        return pm.getContinueExecution();
    }

    public void setInput(Object input) {
        if (input instanceof QueryStatement) {
            if (this.previousExecutedStmt == (QueryStatement)input) {
                if (this.pageBook != null && this.resultTableViewer != null) {
                    this.pageBook.showPage(this.resultTableViewer.getControl());
                }
            } else if (this.pageBook != null && this.blankResultTable != null) {
                this.pageBook.showPage(this.blankResultTable.getControl());
            }
            this.setElement((QueryStatement)input);
            if (this.executeButton != null) {
                this.executeButton.setEnabled(true);
            }
            this.refreshStatement();
        }
    }

    public void refreshStatement() {
        if (this.sqlStatement == null || this.statementSource == null) {
            return;
        }
        String result = SQLStringHelper.trimBlanks(this.sqlStatement.getSQL());
        if (result != null) {
            this.statementSource.setText(this.removeControlChars(result));
        }
    }

    protected String removeControlChars(String input) {
        if (input == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(input.trim(), "\r\n\t\f");
        StringBuffer sb = new StringBuffer(input.length());
        while (tokenizer.hasMoreTokens()) {
            sb.append(tokenizer.nextToken());
        }
        return sb.toString();
    }

    public Database getDatabase() {
        return this.domainModel.getDatabase();
    }
}

