/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;

public class ClassLoadingUtil {
    private static String[] axis2ClassPath = null;
    private static String[] classLoadPath = null;
    private static int libCount = 0;
    private static AntClassLoader antClassLoader;
    private static boolean libsLoaded;
    private static URL[] urls;
    private static boolean alreadyInit;
    private static boolean initByClient;

    static {
        libsLoaded = false;
        urls = null;
        alreadyInit = false;
        initByClient = false;
    }

    public static void init(String project) {
        if (!alreadyInit) {
            if (antClassLoader == null) {
                antClassLoader = new AntClassLoader();
            }
            antClassLoader.setParentFirst(false);
            if (classLoadPath == null || !libsLoaded) {
                classLoadPath = ClassLoadingUtil.getAxis2Libs(project);
            }
            if (urls == null) {
                urls = new URL[classLoadPath.length];
            } else if (urls != null && urls.length != classLoadPath.length) {
                urls = new URL[classLoadPath.length];
            }
            Path classpath = new Path(new Project());
            try {
                int i = 0;
                while (i < classLoadPath.length) {
                    if (classLoadPath[i] != null) {
                        URL url;
                        File file = new File(classLoadPath[i]);
                        ClassLoadingUtil.urls[i] = url = file.toURL();
                        classpath.setPath(classLoadPath[i]);
                    }
                    ++i;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            antClassLoader.setClassPath(classpath);
            alreadyInit = true;
        }
    }

    public static Class loadClassFromAntClassLoader(String fillyQualifiedClassName) {
        Class cls = null;
        try {
            cls = antClassLoader.loadClass(fillyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return cls;
    }

    private static String[] getAxis2Libs(String project) {
        File webContainerPath = new File(FacetContainerUtils.pathToWebProjectContainerLib(project));
        axis2ClassPath = new String[webContainerPath.list().length];
        libCount = 0;
        ClassLoadingUtil.visitAllFiles(webContainerPath);
        return axis2ClassPath;
    }

    public static void visitAllFiles(File dir) {
        if (!dir.toString().endsWith(".txt")) {
            if (dir.isDirectory()) {
                String[] children = dir.list();
                int i = 0;
                while (i < children.length) {
                    ClassLoadingUtil.visitAllFiles(new File(dir, children[i]));
                    ++i;
                }
            } else {
                ClassLoadingUtil.axis2ClassPath[ClassLoadingUtil.libCount] = dir.getAbsolutePath();
                ++libCount;
            }
        }
        libsLoaded = true;
    }

    public static void cleanAntClassLoader() {
        if (initByClient) {
            antClassLoader.cleanup();
            alreadyInit = false;
        }
    }

    public static void setInitByClient(boolean status) {
        initByClient = status;
    }
}

