/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamSpec;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.SystemDescriptor;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public final class LMImporter {
    public static final UnaryOperator<URI> EXTERNAL_REFERENCE_PRESERVER = uri -> uri;
    public static final UnaryOperator<URI> EXTERNAL_REFERENCE_REJECTER = uri -> {
        throw new IllegalStateException("External reference: " + String.valueOf(uri));
    };
    public static final UnaryOperator<URI> EXTERNAL_REFERENCE_UNSETTER = uri -> null;
    private static final URI EXTERNAL_REFERENCE_UNSET_MARKER = URI.createURI((String)"UNSET_EXTERNAL_REFERENCE://cdo.lm");
    private final Map<String, ImportModule> modules = new HashMap<String, ImportModule>();
    private final Map<URI, ImportElement> elements = new HashMap<URI, ImportElement>();

    public Map<String, ImportModule> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public ImportModule getModule(String name) {
        return this.modules.get(name);
    }

    public ImportModule addModule(String moduleName, URI rootURI) {
        if (this.modules.containsKey(moduleName)) {
            throw new IllegalStateException("Module import already exists: " + moduleName);
        }
        ImportModule module = new ImportModule(moduleName, rootURI);
        this.modules.put(moduleName, module);
        return module;
    }

    public ImportResolution resolve(ResourceSet resourceSet) {
        return this.resolve(resourceSet, false);
    }

    public ImportResolution resolve(ResourceSet resourceSet, boolean rejectExternalReferences) {
        UnaryOperator<URI> externalReferenceHandler = rejectExternalReferences ? EXTERNAL_REFERENCE_REJECTER : null;
        return this.resolve(resourceSet, externalReferenceHandler);
    }

    public ImportResolution resolve(ResourceSet resourceSet, UnaryOperator<URI> externalReferenceHandler) {
        if (externalReferenceHandler == null) {
            externalReferenceHandler = EXTERNAL_REFERENCE_PRESERVER;
        }
        for (ImportModule module : this.modules.values()) {
            module.accept(element -> {
                if (element instanceof ImportElement.ImportResource) {
                    ImportElement.ImportResource importResource = (ImportElement.ImportResource)element;
                    importResource.resource = resourceSet.getResource(element.getURI(), true);
                }
            });
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        HashMap<EObject, URI> externalReferences = new HashMap<EObject, URI>();
        for (ImportElement element2 : this.elements.values()) {
            Resource resource;
            if (!(element2 instanceof ImportElement.ImportResource) || (resource = ((ImportElement.ImportResource)element2).getResource()) == null) continue;
            ImportModule sourceModule = element2.getModule();
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject source = (EObject)it.next();
                ListIterator it2 = ((InternalEList)source.eCrossReferences()).basicListIterator();
                while (it2.hasNext()) {
                    EObject target = (EObject)it2.next();
                    if (target.eIsProxy()) {
                        throw new IllegalStateException("Unresolved proxy: " + String.valueOf(((InternalEObject)target).eProxyURI()));
                    }
                    URI targetURI = EcoreUtil.getURI((EObject)target);
                    URI targetElementURI = targetURI.trimFragment();
                    ImportElement targetElement = this.elements.get(targetElementURI);
                    if (targetElement == null) {
                        URI handledURI = (URI)externalReferenceHandler.apply(targetURI);
                        if (handledURI == null) {
                            handledURI = EXTERNAL_REFERENCE_UNSET_MARKER;
                        }
                        externalReferences.put(target, handledURI);
                        continue;
                    }
                    ImportModule targetModule = targetElement.getModule();
                    if (targetModule == sourceModule) continue;
                    sourceModule.registerDependency(targetModule);
                }
            }
        }
        return new ImportResolution(resourceSet, externalReferences);
    }

    private void registerElement(ImportElement element) {
        URI uri = element.getURI();
        if (this.elements.containsKey(uri)) {
            throw new IllegalArgumentException("Duplicate element in importer: " + String.valueOf(element));
        }
        this.elements.put(uri, element);
    }

    @FunctionalInterface
    public static interface DropCreator {
        public static final DropCreator DEFAULT = (systemDescriptor, stream, timeStamp, monitor) -> {
            DropType dropType = DropCreator.getDefaultDropType(systemDescriptor);
            return systemDescriptor.createDrop(stream, dropType, timeStamp, "Initial Module Import", monitor);
        };

        public static DropType getDefaultDropType(ISystemDescriptor systemDescriptor) {
            DropType firstRelease = null;
            for (DropType dropType : systemDescriptor.getSystem().getProcess().getDropTypes()) {
                if (dropType.isRelease()) {
                    if (firstRelease != null) continue;
                    firstRelease = dropType;
                    continue;
                }
                return dropType;
            }
            return firstRelease;
        }

        public Drop createDrop(ISystemDescriptor var1, Stream var2, long var3, IProgressMonitor var5) throws ConcurrentAccessException, CommitException;
    }

    public static abstract class ImportElement
    implements Consumer<Consumer<ImportElement>> {
        private static final List<ImportElement> NO_CHILDREN = Collections.unmodifiableList(Collections.emptyList());
        private final ImportModule module;
        private final ImportFolder parent;
        private final String name;
        private final String[] segments;
        private final URI uri;

        private ImportElement(ImportModule module, URI rootURI) {
            this.module = Objects.requireNonNull(module);
            this.parent = null;
            this.name = null;
            this.segments = new String[0];
            this.uri = rootURI;
            module.registerElement(this);
        }

        private ImportElement(ImportFolder parent, String name) {
            this.module = Objects.requireNonNull(parent).getModule();
            this.parent = parent;
            this.name = ImportElement.requireValidName(name);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(parent.getSegments()));
            list.add(name);
            this.segments = list.toArray(new String[list.size()]);
            this.uri = parent.getURI().appendSegment(name);
            this.module.registerElement(this);
        }

        public ImportModule getModule() {
            return this.module;
        }

        public ImportFolder getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public abstract Type getType();

        public String[] getSegments() {
            return this.segments;
        }

        public URI getURI() {
            return this.uri;
        }

        public String getPath() {
            return String.join((CharSequence)CDOURIUtil.SEGMENT_SEPARATOR, this.segments);
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public abstract boolean isFolder();

        public boolean isLeaf() {
            return !this.isFolder();
        }

        @Override
        public void accept(Consumer<ImportElement> visitor) {
            visitor.accept(this);
        }

        public String toString() {
            return this.getPath();
        }

        public static String requireValidName(String name) {
            if (!URI.validSegment((String)name)) {
                throw new IllegalArgumentException("Name is not a valid URI path segment: " + name);
            }
            return name;
        }

        public static final class ImportBinary
        extends ImportLeaf<InputStream> {
            private ImportBinary(ImportFolder parent, String name) {
                super(parent, name);
            }

            @Override
            public Type getType() {
                return Type.BINARY;
            }

            public ImportBinary setContentsModifier(UnaryOperator<InputStream> contentsModifier) {
                return (ImportBinary)super.setContentsModifier(contentsModifier);
            }

            public ImportBinary setCopyPath(String copyPath) {
                return (ImportBinary)super.setCopyPath(copyPath);
            }
        }

        public static final class ImportFolder
        extends ImportElement {
            private List<ImportElement> children;

            private ImportFolder(ImportModule module, URI rootURI) {
                super(module, rootURI);
            }

            private ImportFolder(ImportFolder parent, String name) {
                super(parent, name);
            }

            @Override
            public Type getType() {
                return Type.FOLDER;
            }

            @Override
            public boolean isFolder() {
                return true;
            }

            @Override
            public void accept(Consumer<ImportElement> visitor) {
                super.accept(visitor);
                if (this.children != null) {
                    for (ImportElement child : this.children) {
                        child.accept(visitor);
                    }
                }
            }

            public List<ImportElement> getChildren() {
                return this.children == null ? NO_CHILDREN : Collections.unmodifiableList(this.children);
            }

            public ImportElement getChild(String name) {
                if (this.children != null) {
                    for (ImportElement child : this.children) {
                        if (!child.getName().equals(name)) continue;
                        return child;
                    }
                }
                return null;
            }

            public ImportFolder getOrAddFolderPath(String path) {
                ImportFolder folder = this;
                StringTokenizer tokenizer = new StringTokenizer(path, CDOURIUtil.SEGMENT_SEPARATOR);
                while (tokenizer.hasMoreTokens()) {
                    String name = tokenizer.nextToken().trim();
                    if (StringUtil.isEmpty((String)name)) continue;
                    folder = this.getOrAddFolder(name);
                }
                return folder;
            }

            public ImportFolder getOrAddFolder(String name) {
                return this.addChild(new ImportFolder(this, name));
            }

            public ImportResource addResource(String name) {
                return this.addChild(new ImportResource(this, name));
            }

            public ImportBinary addBinary(String name) {
                return this.addChild(new ImportBinary(this, name));
            }

            public ImportText addText(String name, String encoding) {
                return this.addChild(new ImportText(this, name, encoding));
            }

            private <E extends ImportElement> E addChild(E child) {
                if (this.isLeaf()) {
                    throw new IllegalStateException("Children not supported by " + String.valueOf((Object)this.getType()));
                }
                if (this.children == null) {
                    this.children = new ArrayList<ImportElement>(1);
                } else if (child.getType() != Type.FOLDER) {
                    String name = child.getName();
                    for (ImportElement c : this.children) {
                        if (!c.getName().equals(name)) continue;
                        throw new IllegalStateException("A child with the name '" + name + "' already exists: " + String.valueOf(c));
                    }
                }
                this.children.add(child);
                return child;
            }
        }

        public static abstract class ImportLeaf<CONTENTS>
        extends ImportElement {
            private UnaryOperator<CONTENTS> contentsModifier;
            private String copyPath = this.getPath();

            private ImportLeaf(ImportFolder parent, String name) {
                super(parent, name);
            }

            @Override
            public boolean isFolder() {
                return false;
            }

            public UnaryOperator<CONTENTS> getContentsModifier() {
                return this.contentsModifier;
            }

            public ImportLeaf<CONTENTS> setContentsModifier(UnaryOperator<CONTENTS> contentsModifier) {
                this.contentsModifier = contentsModifier;
                return this;
            }

            public String getCopyPath() {
                return this.copyPath;
            }

            public ImportLeaf<CONTENTS> setCopyPath(String copyPath) {
                this.copyPath = copyPath;
                return this;
            }
        }

        public static final class ImportResource
        extends ImportLeaf<EList<EObject>> {
            private Resource resource;

            private ImportResource(ImportFolder parent, String name) {
                super(parent, name);
            }

            @Override
            public Type getType() {
                return Type.RESOURCE;
            }

            public Resource getResource() {
                return this.resource;
            }

            public ImportResource setContentsModifier(UnaryOperator<EList<EObject>> contentsModifier) {
                return (ImportResource)super.setContentsModifier(contentsModifier);
            }

            public ImportResource setCopyPath(String copyPath) {
                return (ImportResource)super.setCopyPath(copyPath);
            }
        }

        public static final class ImportText
        extends ImportLeaf<Reader> {
            private final String encoding;

            private ImportText(ImportFolder parent, String name, String encoding) {
                super(parent, name);
                this.encoding = encoding;
            }

            @Override
            public Type getType() {
                return Type.TEXT;
            }

            public String getEncoding() {
                return this.encoding;
            }

            public ImportText setContentsModifier(UnaryOperator<Reader> contentsModifier) {
                return (ImportText)super.setContentsModifier(contentsModifier);
            }

            public ImportText setStringContentsModifier(UnaryOperator<String> stringModifier) {
                return (ImportText)super.setContentsModifier(new StringContentsModifier(stringModifier));
            }

            public ImportText setCopyPath(String copyPath) {
                return (ImportText)super.setCopyPath(copyPath);
            }
        }

        public static final class StringContentsModifier
        implements UnaryOperator<Reader> {
            private final UnaryOperator<String> stringModifier;

            public StringContentsModifier(UnaryOperator<String> stringModifier) {
                this.stringModifier = stringModifier;
            }

            @Override
            public Reader apply(Reader in) {
                String text = IOUtil.readText((Reader)in);
                text = (String)this.stringModifier.apply(text);
                return new StringReader(text);
            }
        }

        public static enum Type {
            FOLDER,
            RESOURCE,
            BINARY,
            TEXT;

        }
    }

    public final class ImportModule
    implements Consumer<Consumer<ImportElement>> {
        private final String name;
        private final ImportElement.ImportFolder root;
        private final Map<URI, ImportElement> elements = new HashMap<URI, ImportElement>();
        private final Set<ImportModule> resolvedDependencies = new HashSet<ImportModule>();
        private final Set<ImportModule> extraDependencies = new HashSet<ImportModule>();

        private ImportModule(String name, URI rootURI) {
            this.name = name;
            this.root = new ImportElement.ImportFolder(this, rootURI);
        }

        public Set<ImportModule> getDependencies() {
            HashSet<ImportModule> dependencies = new HashSet<ImportModule>(this.resolvedDependencies);
            dependencies.addAll(this.extraDependencies);
            return dependencies;
        }

        public Set<ImportModule> getResolvedDependencies() {
            return Collections.unmodifiableSet(this.resolvedDependencies);
        }

        public Set<ImportModule> getExtraDependencies() {
            return Collections.unmodifiableSet(this.extraDependencies);
        }

        public void addExtraDependency(ImportModule extraDependency) {
            if (!LMImporter.this.modules.containsValue(extraDependency)) {
                throw new IllegalArgumentException("Extra dependency is not an importer module: " + String.valueOf(extraDependency));
            }
            this.extraDependencies.add(extraDependency);
        }

        public String getName() {
            return this.name;
        }

        public ImportElement.ImportFolder getRoot() {
            return this.root;
        }

        public URI getRootURI() {
            return this.root.getURI();
        }

        @Override
        public void accept(Consumer<ImportElement> visitor) {
            this.root.accept(visitor);
        }

        public ImportElement getChild(String name) {
            return this.root.getChild(name);
        }

        public List<ImportElement> getChildren() {
            return this.root.getChildren();
        }

        public ImportElement.ImportFolder getOrAddFolderPath(String path) {
            return this.root.getOrAddFolderPath(path);
        }

        public ImportElement.ImportFolder getOrAddFolder(String name) {
            return this.root.getOrAddFolder(name);
        }

        public ImportElement.ImportResource addResource(String name) {
            return this.root.addResource(name);
        }

        public ImportElement.ImportBinary addBinary(String name) {
            return this.root.addBinary(name);
        }

        public ImportElement.ImportText addText(String name, String encoding) {
            return this.root.addText(name, encoding);
        }

        public String toString() {
            return this.name;
        }

        private void registerElement(ImportElement element) {
            URI uri = element.getURI();
            if (this.elements.containsKey(uri)) {
                throw new IllegalArgumentException("Duplicate element in module: " + String.valueOf(element));
            }
            this.elements.put(uri, element);
            LMImporter.this.registerElement(element);
        }

        private void registerDependency(ImportModule dependency) {
            this.resolvedDependencies.add(dependency);
        }
    }

    public final class ImportResolution {
        private final ResourceSet resourceSet;
        private final Map<EObject, URI> externalReferences;
        private final List<ModuleInfo> moduleInfos = new ArrayList<ModuleInfo>();

        private ImportResolution(ResourceSet resourceSet, Map<EObject, URI> externalReferences) {
            this.resourceSet = resourceSet;
            this.externalReferences = externalReferences;
            for (ImportModule module : CollectionUtil.topologicalSort(LMImporter.this.modules.values(), ImportModule::getDependencies, (boolean)true)) {
                ModuleDefinition moduleDefinition = ModulesFactory.eINSTANCE.createModuleDefinition();
                moduleDefinition.setName(module.getName());
                moduleDefinition.setVersion(Version.createOSGi((int)0, (int)1, (int)0));
                for (ImportModule dependency : module.getDependencies()) {
                    DependencyDefinition dependencyDefinition = ModulesFactory.eINSTANCE.createDependencyDefinition();
                    dependencyDefinition.setTargetName(dependency.getName());
                    dependencyDefinition.setVersionRange(VersionRange.emptyRange);
                    moduleDefinition.getDependencies().add((Object)dependencyDefinition);
                }
                StreamSpec streamSpec = new StreamSpec(0, 1, "Initial");
                this.moduleInfos.add(new ModuleInfo(module, moduleDefinition, streamSpec));
            }
        }

        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        public Map<EObject, URI> getExternalReferences() {
            return Collections.unmodifiableMap(this.externalReferences);
        }

        public List<ModuleInfo> getModuleInfos() {
            return Collections.unmodifiableList(this.moduleInfos);
        }

        public ModuleInfo getModuleInfo(ImportModule module) {
            for (ModuleInfo moduleInfo : this.moduleInfos) {
                if (moduleInfo.getModule() != module) continue;
                return moduleInfo;
            }
            return null;
        }

        public List<Module> importModules(ISystemDescriptor systemDescriptor) throws ConcurrentAccessException, CommitException, ISystemDescriptor.ResolutionException, IOException {
            HashSet<String> moduleNames = new HashSet<String>(Arrays.asList(systemDescriptor.getModuleNames()));
            for (ModuleInfo moduleInfo : this.moduleInfos) {
                String moduleName = moduleInfo.getModule().getName();
                if (!moduleNames.contains(moduleName)) continue;
                throw new IllegalStateException("Module already exists: " + moduleName);
            }
            ArrayList<Module> result = new ArrayList<Module>();
            HashMap<EObject, Pair<ModuleInfo, CDOID>> objectMappings = new HashMap<EObject, Pair<ModuleInfo, CDOID>>();
            for (ModuleInfo moduleInfo : this.moduleInfos) {
                Module module = this.importModule(systemDescriptor, objectMappings, moduleInfo);
                result.add(module);
            }
            return result;
        }

        private Module importModule(ISystemDescriptor systemDescriptor, Map<EObject, Pair<ModuleInfo, CDOID>> objectMappings, ModuleInfo moduleInfo) throws ConcurrentAccessException, CommitException, ISystemDescriptor.ResolutionException {
            ResourceSet moduleResourceSet;
            ModuleDefinition moduleDefinition = moduleInfo.getModuleDefinition();
            String moduleName = moduleDefinition.getName();
            ModuleType moduleType = moduleInfo.getModuleType();
            StreamSpec streamSpec = moduleInfo.getStreamSpec();
            Module module = systemDescriptor.createModule(moduleName, moduleType, streamSpec, (IProgressMonitor)new NullProgressMonitor());
            Stream stream = (Stream)module.getStreams().get(0);
            CDOTransaction transaction = null;
            try {
                moduleResourceSet = systemDescriptor.createModuleResourceSet((Baseline)stream);
                transaction = (CDOTransaction)CDOUtil.getView((Notifier)moduleResourceSet);
                String moduleDefinitionPath = stream.getSystem().getProcess().getModuleDefinitionPath();
                CDOResource moduleDefinitionResource = transaction.getOrCreateResource(moduleDefinitionPath);
                EList contents = moduleDefinitionResource.getContents();
                contents.clear();
                contents.add((Object)moduleDefinition);
                transaction.commit();
            }
            catch (Throwable throwable) {
                LifecycleUtil.deactivate(transaction);
                transaction = null;
                throw throwable;
            }
            LifecycleUtil.deactivate((Object)transaction);
            transaction = null;
            try {
                DropCreator dropCreator;
                moduleResourceSet = systemDescriptor.createModuleResourceSet((Baseline)stream);
                CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)moduleResourceSet);
                transaction = (CDOTransaction)viewSet.getViews()[0];
                ModuleCopier copier = new ModuleCopier(objectMappings, transaction);
                moduleInfo.getModule().accept(element -> {
                    ImportElement.Type type = element.getType();
                    switch (type) {
                        case FOLDER: {
                            break;
                        }
                        case RESOURCE: {
                            this.importResource(copier, (ImportElement.ImportResource)element);
                            break;
                        }
                        case BINARY: {
                            this.importBinary(copier, (ImportElement.ImportBinary)element);
                            break;
                        }
                        case TEXT: {
                            this.importText(copier, (ImportElement.ImportText)element);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal element type: " + String.valueOf((Object)type));
                        }
                    }
                });
                copier.copyReferences();
                CDOCommitInfo commitInfo = transaction.commit((IProgressMonitor)new NullProgressMonitor());
                copier.recordObjectMappings(moduleInfo);
                long timeStamp = commitInfo.getTimeStamp();
                if (timeStamp == 0L) {
                    CDOCommitInfoManager commitInfoManager = transaction.getSession().getCommitInfoManager();
                    CDOBranch branch = transaction.getBranch();
                    timeStamp = commitInfoManager.getLastCommitOfBranch(branch, true);
                }
                if ((dropCreator = moduleInfo.getDropCreator()) != null) {
                    dropCreator.createDrop(systemDescriptor, stream, timeStamp, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                LifecycleUtil.deactivate((Object)transaction);
            }
            return module;
        }

        private CDOResource importResource(ModuleCopier copier, ImportElement.ImportResource element) {
            EList modifiedContents;
            EList contents = element.getResource().getContents();
            UnaryOperator contentsModifier = element.getContentsModifier();
            if (contentsModifier != null && (modifiedContents = (EList)contentsModifier.apply(contents)) != null) {
                contents = modifiedContents;
            }
            Collection copyContents = copier.copyAll((Collection)contents);
            String path = element.getCopyPath();
            CDOResource result = copier.getTransaction().createResource(path);
            result.getContents().addAll(copyContents);
            return result;
        }

        private CDOBinaryResource importBinary(ModuleCopier copier, ImportElement.ImportBinary element) {
            try {
                InputStream modifiedInputStream;
                URIConverter uriConverter = this.resourceSet.getURIConverter();
                URI uri = element.getURI();
                InputStream inputStream = new BufferedInputStream(uriConverter.createInputStream(uri));
                UnaryOperator contentsModifier = element.getContentsModifier();
                if (contentsModifier != null && (modifiedInputStream = (InputStream)contentsModifier.apply(inputStream)) != null) {
                    inputStream = modifiedInputStream;
                }
                String path = element.getCopyPath();
                CDOBinaryResource result = copier.getTransaction().createBinaryResource(path);
                result.setContents(new CDOBlob(inputStream));
                return result;
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }

        private CDOTextResource importText(ModuleCopier copier, ImportElement.ImportText element) {
            try {
                Reader modifiedReader;
                URIConverter uriConverter = this.resourceSet.getURIConverter();
                URI uri = element.getURI();
                String encoding = element.getEncoding();
                Reader reader = new BufferedReader(new InputStreamReader(uriConverter.createInputStream(uri), encoding));
                UnaryOperator contentsModifier = element.getContentsModifier();
                if (contentsModifier != null && (modifiedReader = (Reader)contentsModifier.apply(reader)) != null) {
                    reader = modifiedReader;
                }
                String path = element.getCopyPath();
                CDOTextResource result = copier.getTransaction().createTextResource(path);
                result.setEncoding(encoding);
                result.setContents(new CDOClob(reader));
                return result;
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }

        private final class ModuleCopier
        extends EcoreUtil.Copier {
            private static final long serialVersionUID = 1L;
            private final Map<EObject, Pair<ModuleInfo, CDOID>> objectMappings;
            private final CDOTransaction transaction;

            public ModuleCopier(Map<EObject, Pair<ModuleInfo, CDOID>> objectMappings, CDOTransaction transaction) {
                super(true, false);
                this.objectMappings = objectMappings;
                this.transaction = transaction;
            }

            public CDOTransaction getTransaction() {
                return this.transaction;
            }

            public void recordObjectMappings(ModuleInfo moduleInfo) {
                for (Map.Entry entry : this.entrySet()) {
                    EObject eObject = (EObject)entry.getKey();
                    CDOObject copyObject = (CDOObject)entry.getValue();
                    this.objectMappings.put(eObject, (Pair<ModuleInfo, CDOID>)Pair.create((Object)moduleInfo, (Object)copyObject.cdoID()));
                }
            }

            public EObject get(Object key) {
                Pair<ModuleInfo, CDOID> mapping = this.objectMappings.get(key);
                if (mapping != null) {
                    ModuleInfo elementModuleInfo = (ModuleInfo)mapping.getElement1();
                    CDOID elementID = (CDOID)mapping.getElement2();
                    CDOView view = this.getViewSafe(elementModuleInfo);
                    return view.getObject(elementID);
                }
                URI handledURI = ImportResolution.this.externalReferences.get(key);
                if (handledURI != null) {
                    if (handledURI == EXTERNAL_REFERENCE_UNSET_MARKER) {
                        return null;
                    }
                    ResourceSet targetResourceSet = this.transaction.getResourceSet();
                    EObject targetObject = targetResourceSet.getEObject(handledURI, true);
                    if (targetObject != null) {
                        return targetObject;
                    }
                }
                return (EObject)super.get(key);
            }

            private CDOView getViewSafe(ModuleInfo moduleInfo) {
                String name = moduleInfo.getModule().getName();
                CDOView[] views = this.transaction.getViewSet().getViews();
                int i = 1;
                while (i < views.length) {
                    CDOView view = views[i];
                    String moduleName = SystemDescriptor.getModuleName(view.getSession());
                    if (name.equals(moduleName)) {
                        return view;
                    }
                    ++i;
                }
                throw new IllegalStateException("View not found for module " + name);
            }
        }

        public final class ModuleInfo {
            private final ImportModule module;
            private ModuleType moduleType;
            private ModuleDefinition moduleDefinition;
            private StreamSpec streamSpec;
            private DropCreator dropCreator = DropCreator.DEFAULT;

            private ModuleInfo(ImportModule module, ModuleDefinition moduleDefinition, StreamSpec streamSpec) {
                this.module = module;
                this.moduleDefinition = moduleDefinition;
                this.streamSpec = streamSpec;
            }

            public ImportModule getModule() {
                return this.module;
            }

            public ModuleType getModuleType() {
                return this.moduleType;
            }

            public void setModuleType(ModuleType moduleType) {
                this.moduleType = moduleType;
            }

            public ModuleDefinition getModuleDefinition() {
                return this.moduleDefinition;
            }

            public void setModuleDefinition(ModuleDefinition moduleDefinition) {
                this.moduleDefinition = moduleDefinition;
            }

            public StreamSpec getStreamSpec() {
                return this.streamSpec;
            }

            public void setStreamSpec(StreamSpec streamSpec) {
                this.streamSpec = streamSpec;
            }

            public DropCreator getDropCreator() {
                return this.dropCreator;
            }

            public void setDropCreator(DropCreator dropCreator) {
                this.dropCreator = dropCreator;
            }

            public String toString() {
                return this.module.getName();
            }
        }
    }
}

