/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.text;

import java.io.IOException;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.text.IFileRider;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.text.REDFile;

public final class REDFileRider
implements IFileRider {
    private REDFile fFile;
    private int fLimit = Integer.MAX_VALUE;
    private int fResult;
    private boolean fEof;
    private char[] fOneCharBuf = new char[1];

    public REDFileRider(REDFile f) throws IOException {
        this.set(f, 0);
    }

    public REDFileRider(REDFile f, int limit) throws IOException {
        this.fLimit = limit;
        this.set(f, 0);
    }

    @Override
    public void seek(int pos) throws IOException {
        this.fFile.seek(pos);
        this.fEof = false;
        this.fResult = 0;
    }

    private void set(REDFile f, int pos) throws IOException {
        assert (f != null);
        assert (pos >= 0 && pos <= f.length());
        this.fFile = f;
        this.fFile.seek(pos);
        this.fEof = false;
        this.fResult = 0;
    }

    public boolean eof() {
        return this.fEof;
    }

    public int getResult() {
        return this.fResult;
    }

    public REDFile getFile() {
        return this.fFile;
    }

    @Override
    public void writeChar(char c) throws IOException {
        this.fOneCharBuf[0] = c;
        this.writeChars(this.fOneCharBuf, 0, 1);
    }

    @Override
    public void writeChars(char[] buf) throws IOException {
        this.writeChars(buf, 0, buf.length);
    }

    @Override
    public void writeChars(char[] buf, int n) throws IOException {
        this.writeChars(buf, 0, n);
    }

    @Override
    public void writeChars(char[] buf, int off, int n) throws IOException {
        this.fFile.writeBuffered(buf, off, n);
        this.fResult = 0;
    }

    @Override
    public void writeChars(String buf, int off, int n) throws IOException {
        this.fFile.writeBuffered(buf, off, n);
        this.fResult = 0;
    }

    @Override
    public char readChar() throws IOException {
        this.readChars(this.fOneCharBuf, 0, 1);
        return this.fEof ? (char)'\u0000' : this.fOneCharBuf[0];
    }

    @Override
    public void readChars(char[] buf) throws IOException {
        this.readChars(buf, 0, buf.length);
    }

    @Override
    public void readChars(char[] buf, int n) throws IOException {
        this.readChars(buf, 0, n);
    }

    @Override
    public void readChars(char[] buf, int off, int n) throws IOException {
        int count = this.fFile.readBuffered(buf, off, n);
        this.fResult = n - count;
        this.fEof = this.fResult > 0;
    }

    @Override
    public void readChars(StringBuffer buf, int n) throws IOException {
        int count = this.fFile.readBuffered(buf, n);
        this.fResult = n - count;
        this.fEof = this.fResult > 0;
    }

    @Override
    public int length() {
        return this.fFile.length();
    }

    @Override
    public int limit() {
        return this.fLimit;
    }

    @Override
    public boolean isReadonly() {
        return this.fFile.isReadonly();
    }
}

