/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.gtest;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.cdt.testsrunner.internal.gtest.GoogleTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.gtest.OutputHandler;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.TestingException;

public class GoogleTestsRunnerProvider
implements ITestsRunnerProvider {
    private static final String TEST_PATHS_DELIMITED = ":";
    private static final String TEST_PATH_PARTS_DELIMITED = ".";
    private static final String ALL_TESTS = ".*";

    public String[] getAdditionalLaunchParameters(String[][] testPaths) {
        String[] gtestParameters;
        String[] result = gtestParameters = new String[]{"--gtest_repeat=1", "--gtest_print_time=1", "--gtest_color=no"};
        if (testPaths != null && testPaths.length >= 1) {
            StringBuilder sb = new StringBuilder("--gtest_filter=");
            boolean needTestPathDelimiter = false;
            String[][] stringArray = testPaths;
            int n = testPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String[] testPath = stringArray[n2];
                if (needTestPathDelimiter) {
                    sb.append(TEST_PATHS_DELIMITED);
                } else {
                    needTestPathDelimiter = true;
                }
                boolean needTestPathPartDelimiter = false;
                String[] stringArray2 = testPath;
                int n3 = testPath.length;
                int n4 = 0;
                while (n4 < n3) {
                    String testPathPart = stringArray2[n4];
                    if (needTestPathPartDelimiter) {
                        sb.append(TEST_PATH_PARTS_DELIMITED);
                    } else {
                        needTestPathPartDelimiter = true;
                    }
                    sb.append(testPathPart);
                    ++n4;
                }
                if (testPath.length <= 1) {
                    sb.append(ALL_TESTS);
                }
                ++n2;
            }
            result = new String[gtestParameters.length + 1];
            System.arraycopy(gtestParameters, 0, result, 0, gtestParameters.length);
            result[gtestParameters.length] = sb.toString();
        }
        return result;
    }

    private String getErrorText(String prefix, String description) {
        return MessageFormat.format(GoogleTestsRunnerMessages.GoogleTestsRunner_error_format, prefix, description);
    }

    public void run(ITestModelUpdater modelUpdater, InputStream inputStream) throws TestingException {
        try {
            OutputHandler ouputHandler = new OutputHandler(modelUpdater);
            ouputHandler.run(inputStream);
        }
        catch (IOException e) {
            throw new TestingException(this.getErrorText(GoogleTestsRunnerMessages.GoogleTestsRunner_io_error_prefix, e.getLocalizedMessage()));
        }
    }
}

