/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FileExtensionsFilter
extends ViewerFilter {
    private final HashSet<String> fExtensions = new HashSet();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            return this.processFile((IFile)element);
        }
        if (element instanceof IContainer) {
            return this.processContainer((IContainer)element, viewer, parentElement);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processContainer(IContainer container, Viewer viewer, Object parentElement) {
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return false;
        }
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (this.select(viewer, parentElement, resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private boolean processFile(IFile file) {
        String fileName = file.getName().toLowerCase(Locale.ENGLISH);
        int lastDotIndex = fileName.lastIndexOf(46);
        int lastIndex = fileName.length() - 1;
        if (lastDotIndex < 0) {
            return false;
        }
        if (lastDotIndex >= lastIndex) {
            return false;
        }
        String extension = fileName.substring(lastDotIndex + 1);
        return this.fExtensions.contains(extension);
    }

    public void addFileExtension(String extension) {
        this.fExtensions.add(extension);
    }
}

