/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

public abstract class ModulePackageAccess
extends ModuleDirective {
    protected volatile Name name;
    protected ASTNode.NodeList modules = new ASTNode.NodeList(this.internalModulesProperty());

    abstract ChildListPropertyDescriptor internalModulesProperty();

    abstract ChildPropertyDescriptor internalNameProperty();

    public final ChildPropertyDescriptor getNameProperty() {
        return this.internalNameProperty();
    }

    static final ChildPropertyDescriptor internalNamePropertyFactory(Class nodeClass) {
        return new ChildPropertyDescriptor(nodeClass, "name", Name.class, true, false);
    }

    static final ChildListPropertyDescriptor internalModulesPropertyFactory(Class nodeClass) {
        return new ChildListPropertyDescriptor(nodeClass, "modules", Name.class, false);
    }

    ModulePackageAccess(AST ast) {
        super(ast);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == this.internalNameProperty()) {
            if (get) {
                return this.getName();
            }
            this.setName((Name)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == this.internalModulesProperty()) {
            return this.modules();
        }
        return super.internalGetChildListProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Name getName() {
        if (this.name == null) {
            ModulePackageAccess modulePackageAccess = this;
            synchronized (modulePackageAccess) {
                if (this.name == null) {
                    this.preLazyInit();
                    this.name = this.postLazyInit(this.ast.newQualifiedName(new SimpleName(this.ast), new SimpleName(this.ast)), this.internalNameProperty());
                }
            }
        }
        return this.name;
    }

    public void setName(Name name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Name oldChild = this.name;
        ChildPropertyDescriptor p = this.internalNameProperty();
        this.preReplaceChild(oldChild, name, p);
        this.name = name;
        this.postReplaceChild(oldChild, name, p);
    }

    public List modules() {
        return this.modules;
    }

    protected ASTNode cloneHelper(AST target, ModulePackageAccess result) {
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setName((Name)this.getName().clone(target));
        result.modules().addAll(ASTNode.copySubtrees(target, this.modules()));
        return result;
    }

    protected void acceptVisitChildren(boolean visitChildren, ASTVisitor visitor) {
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.modules);
        }
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.name == null ? 0 : this.getName().treeSize()) + this.modules.listSize();
    }
}

