/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;

public class MassifSnapshot {
    protected long number;
    protected long time;
    protected long heapBytes;
    protected long heapExtra;
    protected long stacks;
    protected String cmd;
    protected TimeUnit unit;
    protected SnapshotType type;
    protected MassifHeapTreeNode root;

    public MassifSnapshot(int number) {
        this.number = number;
    }

    public long getNumber() {
        return this.number;
    }

    public long getHeapBytes() {
        return this.heapBytes;
    }

    public long getHeapExtra() {
        return this.heapExtra;
    }

    public long getStacks() {
        return this.stacks;
    }

    public long getTime() {
        return this.time;
    }

    public long getTotal() {
        return this.heapBytes + this.heapExtra + this.stacks;
    }

    public SnapshotType getType() {
        return this.type;
    }

    public String getCmd() {
        return this.cmd;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public MassifHeapTreeNode getRoot() {
        return this.root;
    }

    public boolean isDetailed() {
        return !this.type.equals((Object)SnapshotType.EMPTY);
    }

    protected void setTime(long time) {
        this.time = time;
    }

    protected void setHeapBytes(long heapBytes) {
        this.heapBytes = heapBytes;
    }

    protected void setHeapExtra(long heapExtra) {
        this.heapExtra = heapExtra;
    }

    protected void setStacks(long stacks) {
        this.stacks = stacks;
    }

    protected void setType(SnapshotType type) {
        this.type = type;
    }

    protected void setCmd(String cmd) {
        this.cmd = cmd;
    }

    protected void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    protected void setRoot(MassifHeapTreeNode root) {
        this.root = root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SnapshotType {
        EMPTY,
        DETAILED,
        PEAK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeUnit {
        INSTRUCTIONS,
        MILLISECONDS,
        BYTES;

    }
}

