/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MessageLine;

public class StatusTool {
    public static void applyToStatusLine(MessageLine messageLine, IStatus status) {
        String[] messages = StatusTool.getErrorMessages(status);
        messageLine.setErrorMessage(messages[0]);
        messageLine.setMessage(messages[1]);
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String[] messages = StatusTool.getErrorMessages(status);
        page.setErrorMessage(messages[0]);
        page.setMessage(messages[1]);
    }

    public static String[] getErrorMessages(IStatus status) {
        String message = status.getMessage();
        if (status.matches(4) && !"".equals(message)) {
            String[] stringArray = new String[2];
            stringArray[0] = message;
            return stringArray;
        }
        if (status.matches(3)) {
            String[] stringArray = new String[2];
            stringArray[1] = message;
            return stringArray;
        }
        return new String[2];
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus getMostSevere(IStatus[] status) {
        IStatus max = null;
        int i = 0;
        while (i < status.length) {
            IStatus curr = status[i];
            if (curr.matches(4)) {
                return curr;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        return max;
    }
}

