/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.view.histogram;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.gprof.symbolManager.CallGraphArc;
import org.eclipse.linuxtools.gprof.symbolManager.CallGraphNode;
import org.eclipse.linuxtools.gprof.view.histogram.AbstractTreeElement;
import org.eclipse.linuxtools.gprof.view.histogram.CGCategory;
import org.eclipse.linuxtools.gprof.view.histogram.HistFile;
import org.eclipse.linuxtools.gprof.view.histogram.HistLine;
import org.eclipse.linuxtools.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.gprof.view.histogram.TreeElement;

public class HistFunction
extends AbstractTreeElement {
    public final IBinaryParser.ISymbol symbol;
    private final LinkedList<HistLine> children = new LinkedList();
    private CGCategory parentsFunctions;
    private CGCategory childrenFunctions;
    private static HashMap<IBinaryParser.ISymbol, Integer> histSym = new HashMap();

    public HistFunction(HistFile parent, IBinaryParser.ISymbol s) {
        super(parent);
        this.symbol = s;
        histSym.put(s, 0);
    }

    private HistLine getChild(int line) {
        HistLine l2;
        for (HistLine l2 : this.children) {
            if (l2.line != line) continue;
            return l2;
        }
        l2 = new HistLine(this, line);
        this.children.add(l2);
        return l2;
    }

    void addBucket(Bucket b, IBinaryParser.IBinaryObject program) {
        int lineNumber = -1;
        IAddress address = program.getAddressFactory().createAddress(String.valueOf(b.start_addr));
        lineNumber = STSymbolManager.sharedInstance.getLineNumber(program, address);
        HistLine hf = this.getChild(lineNumber);
        hf.addBucket(b);
        histSym.put(this.symbol, b.time + histSym.get(this.symbol));
    }

    void addCallGraphNode(CallGraphNode node) {
        LinkedList<CallGraphArc> parents = node.getParents();
        LinkedList<CallGraphArc> children = node.getChildren();
        if (parents.size() != 0) {
            this.parentsFunctions = new CGCategory(this, "parents", node.getParents());
        }
        if (children.size() != 0) {
            this.childrenFunctions = new CGCategory(this, "children", node.getChildren());
        }
        this.calls = node.getCalls();
    }

    @Override
    public LinkedList<? extends TreeElement> getChildren() {
        return this.children;
    }

    @Override
    public int getCalls() {
        return this.calls;
    }

    @Override
    public String getName() {
        return STSymbolManager.sharedInstance.demangle(this.symbol);
    }

    public CGCategory getParentsFunctions() {
        return this.parentsFunctions;
    }

    public CGCategory getChildrenFunctions() {
        return this.childrenFunctions;
    }

    @Override
    public int getSourceLine() {
        return STSymbolManager.sharedInstance.getLineNumber(this.symbol);
    }

    @Override
    public String getSourcePath() {
        return ((HistRoot)this.getRoot()).decoder.getFileName(this.symbol);
    }

    public static int getSamples(IBinaryParser.ISymbol sym) {
        if (histSym.containsKey(sym)) {
            return histSym.get(sym);
        }
        return 0;
    }
}

