/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.linuxtools.tmf.core.statesystem.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.statesystem.AttributeTree;
import org.eclipse.linuxtools.tmf.core.statesystem.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.TransientState;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class StateSystem {
    protected AttributeTree attributeTree = new AttributeTree(this);
    protected TransientState transState = new TransientState(null);

    public int getQuarkAbsolute(String ... attribute) throws AttributeNotFoundException {
        return this.attributeTree.getQuarkDontAdd(-1, attribute);
    }

    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        return this.attributeTree.getQuarkAndAdd(-1, attribute);
    }

    public int getQuarkRelative(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        return this.attributeTree.getQuarkDontAdd(startingNodeQuark, subPath);
    }

    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        return this.attributeTree.getQuarkAndAdd(startingNodeQuark, subPath);
    }

    public void modifyAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        this.transState.processStateChange(t, value, attributeQuark);
    }

    public void incrementAttribute(long t, int attributeQuark) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        int prevValue = this.queryOngoingState(attributeQuark).unboxInt();
        this.modifyAttribute(t, TmfStateValue.newValueInt(prevValue + 1), attributeQuark);
    }

    public void pushAttribute(long t, ITmfStateValue value, int attributeQuark) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        assert (attributeQuark >= 0);
        Integer stackDepth = 0;
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (!previousSV.isNull() && (previousSV.getType() == 0 ? (stackDepth = Integer.valueOf(previousSV.unboxInt())) >= 10 && !$assertionsDisabled : !$assertionsDisabled)) {
            throw new AssertionError();
        }
        stackDepth = stackDepth + 1;
        int subAttributeQuark = this.getQuarkRelativeAndAdd(attributeQuark, stackDepth.toString());
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.transState.processStateChange(t, value, subAttributeQuark);
    }

    public void popAttribute(long t, int attributeQuark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        Integer stackDepth;
        assert (attributeQuark >= 0);
        ITmfStateValue previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV.isNull()) {
            stackDepth = 0;
        } else {
            assert (previousSV.getType() == 0);
            stackDepth = previousSV.unboxInt();
        }
        if (stackDepth == 0) {
            return;
        }
        if (stackDepth < 0) assert (false);
        int subAttributeQuark = this.getQuarkRelative(attributeQuark, stackDepth.toString());
        stackDepth = stackDepth - 1;
        this.modifyAttribute(t, TmfStateValue.newValueInt(stackDepth), attributeQuark);
        this.removeAttribute(t, subAttributeQuark);
    }

    public void removeAttribute(long t, int attributeQuark) throws TimeRangeException, AttributeNotFoundException {
        assert (attributeQuark >= 0);
        ArrayList<Integer> childAttributes = this.attributeTree.getSubAttributes(attributeQuark);
        for (Integer childNodeQuark : childAttributes) {
            assert (attributeQuark != childNodeQuark);
            this.removeAttribute(t, childNodeQuark);
        }
        this.transState.processStateChange(t, TmfStateValue.nullValue(), attributeQuark);
    }

    public ITmfStateValue queryOngoingState(int attributeQuark) throws AttributeNotFoundException {
        return this.transState.getOngoingStateValue(attributeQuark);
    }

    public void updateOngoingState(ITmfStateValue newValue, int attributeQuark) throws AttributeNotFoundException {
        this.transState.changeOngoingStateValue(attributeQuark, newValue);
    }

    public String getFullAttributePath(int attributeQuark) {
        return this.attributeTree.getFullAttributeName(attributeQuark);
    }

    public void debugPrint(PrintWriter writer) {
        this.attributeTree.debugPrint(writer);
        this.transState.debugPrint(writer);
    }
}

