/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.markers;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.internal.markers.AbstractPomProblemResolution;
import org.eclipse.m2e.editor.internal.markers.MavenMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ManagedVersionRemovalResolution
extends AbstractPomProblemResolution {
    final boolean isDependency;

    public ManagedVersionRemovalResolution(IMarker marker, boolean dependency) {
        super(marker);
        this.isDependency = dependency;
    }

    public int getOrder() {
        return 100;
    }

    @Override
    public boolean canFix(String editorHint) {
        return this.isDependency ? MavenMarkerResolutionGenerator.isDependencyVersionOverride(editorHint) : MavenMarkerResolutionGenerator.isPluginVersionOverride(editorHint);
    }

    public String getLabel() {
        return Messages.PomQuickAssistProcessor_title_version;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
    }

    public String getDescription() {
        if (this.getQuickAssistContext() != null) {
            IDocument doc = this.getQuickAssistContext().getSourceViewer().getDocument();
            String[] toRet = new String[1];
            XmlUtils.performOnRootElement((IDocument)doc, (node, structured) -> {
                Element artifact = this.findArtifactElement((Element)node, this.getMarker());
                if (artifact != null) {
                    Element value = XmlUtils.findChild((Element)artifact, (String)"version");
                    stringArray[0] = ManagedVersionRemovalResolution.previewForRemovedElement(doc, value);
                }
            });
            if (toRet[0] != null) {
                return toRet[0];
            }
        }
        return Messages.PomQuickAssistProcessor_remove_hint;
    }

    @Override
    protected void processFix(IStructuredDocument doc, Element root, List<IMarker> markers) {
        if ("project".equals(root.getNodeName())) {
            for (IMarker marker : markers) {
                IndexedRegion off;
                int offset;
                Element artifact = this.findArtifactElement(root, marker);
                if (artifact == null) {
                    this.LOG.error("Unable to find the marked element");
                    continue;
                }
                Element value = XmlUtils.findChild((Element)artifact, (String)"version");
                if (!(value instanceof IndexedRegion) || (offset = (off = (IndexedRegion)value).getStartOffset()) <= 0) continue;
                Node prev = value.getNextSibling();
                if (prev instanceof Text) {
                    off = (IndexedRegion)prev;
                }
                DeleteEdit edit = new DeleteEdit(offset, off.getEndOffset() - offset);
                try {
                    edit.apply((IDocument)doc);
                    marker.delete();
                }
                catch (Exception e) {
                    this.LOG.error("Unable to remove the element", (Throwable)e);
                }
            }
        }
    }

    Element findArtifactElement(Element root, IMarker marker) {
        Element profileRoot;
        if (root == null) {
            return null;
        }
        String groupId = marker.getAttribute("groupId", null);
        String artifactId = marker.getAttribute("artifactId", null);
        assert (groupId != null);
        assert (artifactId != null);
        String profile = marker.getAttribute("profile", null);
        Element artifactParent = root;
        if (profile != null && (profileRoot = XmlUtils.findChild((Element)root, (String)"profiles")) != null) {
            for (Element prf : XmlUtils.findChilds((Element)profileRoot, (String)"profile")) {
                if (!profile.equals(XmlUtils.getTextValue((Node)XmlUtils.findChild((Element)prf, (String)"id")))) continue;
                artifactParent = prf;
                break;
            }
        }
        if (!this.isDependency) {
            artifactParent = XmlUtils.findChild((Element)artifactParent, (String)"build");
        }
        if (artifactParent == null) {
            return null;
        }
        Element list = XmlUtils.findChild((Element)artifactParent, (String)(this.isDependency ? "dependencies" : "plugins"));
        if (list == null) {
            return null;
        }
        Element artifact = null;
        for (Element art : XmlUtils.findChilds((Element)list, (String)(this.isDependency ? "dependency" : "plugin"))) {
            String grpString = XmlUtils.getTextValue((Node)XmlUtils.findChild((Element)art, (String)"groupId"));
            String artString = XmlUtils.getTextValue((Node)XmlUtils.findChild((Element)art, (String)"artifactId"));
            if (!groupId.equals(grpString) || !artifactId.equals(artString)) continue;
            artifact = art;
            break;
        }
        return artifact;
    }
}

