/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.xml;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasXPath
extends TypeSafeMatcher<Node> {
    private final Matcher<String> valueMatcher;
    private final XPathExpression compiledXPath;
    private final String xpathString;

    public HasXPath(String xPathExpression, Matcher<String> valueMatcher) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            this.compiledXPath = xPath.compile(xPathExpression);
            this.xpathString = xPathExpression;
            this.valueMatcher = valueMatcher;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath : " + xPathExpression, e);
        }
    }

    @Override
    public boolean matchesSafely(Node item) {
        try {
            String result = (String)this.compiledXPath.evaluate(item, XPathConstants.STRING);
            if (result == null) {
                return false;
            }
            if (this.valueMatcher == null) {
                return !result.equals("");
            }
            return this.valueMatcher.matches((Object)result);
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("an XML document with XPath ").appendText(this.xpathString);
        if (this.valueMatcher != null) {
            description.appendText(" ").appendDescriptionOf(this.valueMatcher);
        }
    }

    @Factory
    public static Matcher<Node> hasXPath(String xPath, Matcher<String> valueMatcher) {
        return new HasXPath(xPath, valueMatcher);
    }

    @Factory
    public static Matcher<Node> hasXPath(String xPath) {
        return HasXPath.hasXPath(xPath, null);
    }
}

