/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public abstract class AbstractTreeGenerationRule
extends GenerationSimpleRule {
    private int index;
    private List<String> path;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Tree && event.item instanceof TreeItem;
    }

    public void initializeForEvent(Event event) {
        Tree tree = (Tree)event.widget;
        this.path = new ArrayList<String>();
        this.index = WidgetUtils.getIndex((Control)tree);
        TreeItem currentItem = (TreeItem)event.item;
        while (currentItem != null) {
            if (currentItem.getText() != null) {
                this.path.add(currentItem.getText());
            }
            currentItem = currentItem.getParentItem();
        }
        Collections.reverse(this.path);
    }

    public String getWidgetAccessor() {
        StringBuilder res = new StringBuilder();
        res.append("bot.tree(");
        if (this.index != 0) {
            res.append(this.index);
        }
        res.append(")");
        boolean first = true;
        for (String text : this.path) {
            if (first) {
                res.append(".getTreeItem(\"");
                first = false;
            } else {
                res.append(".getNode(\"");
            }
            res.append(text);
            res.append("\")");
        }
        return res.toString();
    }
}

