/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class DoubleClickTreeItemRule
extends GenerationSimpleRule {
    private int index;
    private List<String> path;
    private Tree tree;

    @Override
    public boolean appliesTo(Event event) {
        return event.widget instanceof Tree && event.type == 8 && ((Tree)event.widget).getSelectionCount() == 1;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.tree = (Tree)event.widget;
        this.path = new ArrayList<String>();
        this.index = WidgetUtils.getIndex((Control)this.tree);
        TreeItem currentItem = this.tree.getSelection()[0];
        while (currentItem != null) {
            if (currentItem.getText() != null) {
                this.path.add(currentItem.getText());
            }
            currentItem = currentItem.getParentItem();
        }
        Collections.reverse(this.path);
    }

    public String getWidgetAccessor() {
        StringBuilder res = new StringBuilder();
        res.append("bot.tree(");
        if (this.index != 0) {
            res.append(this.index);
        }
        res.append(")");
        boolean first = true;
        for (String text : this.path) {
            if (first) {
                res.append(".getTreeItem(\"");
                first = false;
            } else {
                res.append(".getNode(\"");
            }
            res.append(text);
            res.append("\")");
        }
        return res.toString();
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        code.append(this.getWidgetAccessor());
        code.append(".doubleClick()");
        actions.add(code.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public Tree getWidget() {
        return this.tree;
    }
}

