"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_output_lib_browser_output-frontend-module_js"],{

/***/ "../../node_modules/@theia/output/lib/browser/output-editor-factory.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-editor-factory.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputEditorFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = tslib_1.__importDefault(__webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js"));
const monaco_context_menu_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-context-menu */ "../../node_modules/@theia/monaco/lib/browser/monaco-context-menu.js");
const monaco_editor_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor.js");
const output_uri_1 = __webpack_require__(/*! ../common/output-uri */ "../../node_modules/@theia/output/lib/common/output-uri.js");
const output_context_menu_1 = __webpack_require__(/*! ./output-context-menu */ "../../node_modules/@theia/output/lib/browser/output-context-menu.js");
const contextView_1 = __webpack_require__(/*! @theia/monaco-editor-core/esm/vs/platform/contextview/browser/contextView */ "../../node_modules/@theia/monaco-editor-core/esm/vs/platform/contextview/browser/contextView.js");
let OutputEditorFactory = class OutputEditorFactory {
    constructor() {
        this.scheme = output_uri_1.OutputUri.SCHEME;
    }
    create(model, defaultsOptions) {
        const uri = new uri_1.default(model.uri);
        const options = this.createOptions(model, defaultsOptions);
        const overrides = this.createOverrides(model);
        return monaco_editor_1.MonacoEditor.create(uri, model, document.createElement('div'), this.services, options, overrides);
    }
    createOptions(model, defaultOptions) {
        return {
            ...defaultOptions,
            overviewRulerLanes: 3,
            lineNumbersMinChars: 3,
            fixedOverflowWidgets: true,
            wordWrap: 'off',
            lineNumbers: 'off',
            glyphMargin: false,
            lineDecorationsWidth: 20,
            rulers: [],
            folding: false,
            scrollBeyondLastLine: false,
            readOnly: true,
            renderLineHighlight: 'none',
            minimap: { enabled: false },
            matchBrackets: 'never'
        };
    }
    *createOverrides(model) {
        yield [contextView_1.IContextMenuService, this.contextMenuService];
    }
};
exports.OutputEditorFactory = OutputEditorFactory;
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_editor_1.MonacoEditorServices),
    tslib_1.__metadata("design:type", monaco_editor_1.MonacoEditorServices)
], OutputEditorFactory.prototype, "services", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(output_context_menu_1.OutputContextMenuService),
    tslib_1.__metadata("design:type", monaco_context_menu_1.MonacoContextMenuService)
], OutputEditorFactory.prototype, "contextMenuService", void 0);
exports.OutputEditorFactory = OutputEditorFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], OutputEditorFactory);


/***/ }),

/***/ "../../node_modules/@theia/output/lib/browser/output-editor-model-factory.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-editor-model-factory.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputEditorModel = exports.OutputEditorModelFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco_editor_model_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-model */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-model.js");
const output_uri_1 = __webpack_require__(/*! ../common/output-uri */ "../../node_modules/@theia/output/lib/common/output-uri.js");
const monaco_to_protocol_converter_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-to-protocol-converter */ "../../node_modules/@theia/monaco/lib/browser/monaco-to-protocol-converter.js");
const protocol_to_monaco_converter_1 = __webpack_require__(/*! @theia/monaco/lib/browser/protocol-to-monaco-converter */ "../../node_modules/@theia/monaco/lib/browser/protocol-to-monaco-converter.js");
let OutputEditorModelFactory = class OutputEditorModelFactory {
    constructor() {
        this.scheme = output_uri_1.OutputUri.SCHEME;
    }
    createModel(resource) {
        return new OutputEditorModel(resource, this.m2p, this.p2m);
    }
};
exports.OutputEditorModelFactory = OutputEditorModelFactory;
tslib_1.__decorate([
    (0, inversify_1.inject)(monaco_to_protocol_converter_1.MonacoToProtocolConverter),
    tslib_1.__metadata("design:type", monaco_to_protocol_converter_1.MonacoToProtocolConverter)
], OutputEditorModelFactory.prototype, "m2p", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(protocol_to_monaco_converter_1.ProtocolToMonacoConverter),
    tslib_1.__metadata("design:type", protocol_to_monaco_converter_1.ProtocolToMonacoConverter)
], OutputEditorModelFactory.prototype, "p2m", void 0);
exports.OutputEditorModelFactory = OutputEditorModelFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], OutputEditorModelFactory);
class OutputEditorModel extends monaco_editor_model_1.MonacoEditorModel {
    get readOnly() {
        return true;
    }
    setDirty(dirty) {
        // NOOP
    }
}
exports.OutputEditorModel = OutputEditorModel;


/***/ }),

/***/ "../../node_modules/@theia/output/lib/browser/output-frontend-module.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-frontend-module.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const output_widget_1 = __webpack_require__(/*! ./output-widget */ "../../node_modules/@theia/output/lib/browser/output-widget.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const output_channel_1 = __webpack_require__(/*! ./output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
const output_preferences_1 = __webpack_require__(/*! ./output-preferences */ "../../node_modules/@theia/output/lib/browser/output-preferences.js");
const output_toolbar_contribution_1 = __webpack_require__(/*! ./output-toolbar-contribution */ "../../node_modules/@theia/output/lib/browser/output-toolbar-contribution.js");
const output_contribution_1 = __webpack_require__(/*! ./output-contribution */ "../../node_modules/@theia/output/lib/browser/output-contribution.js");
const monaco_editor_provider_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-provider */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-provider.js");
const output_context_menu_1 = __webpack_require__(/*! ./output-context-menu */ "../../node_modules/@theia/output/lib/browser/output-context-menu.js");
const output_editor_factory_1 = __webpack_require__(/*! ./output-editor-factory */ "../../node_modules/@theia/output/lib/browser/output-editor-factory.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
const output_editor_model_factory_1 = __webpack_require__(/*! ./output-editor-model-factory */ "../../node_modules/@theia/output/lib/browser/output-editor-model-factory.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(output_channel_1.OutputChannelManager).toSelf().inSingletonScope();
    bind(common_1.ResourceResolver).toService(output_channel_1.OutputChannelManager);
    bind(output_editor_factory_1.OutputEditorFactory).toSelf().inSingletonScope();
    bind(monaco_editor_provider_1.MonacoEditorFactory).toService(output_editor_factory_1.OutputEditorFactory);
    bind(output_editor_model_factory_1.OutputEditorModelFactory).toSelf().inSingletonScope();
    bind(monaco_text_model_service_1.MonacoEditorModelFactory).toService(output_editor_model_factory_1.OutputEditorModelFactory);
    bind(output_context_menu_1.OutputContextMenuService).toSelf().inSingletonScope();
    (0, output_preferences_1.bindOutputPreferences)(bind);
    bind(output_widget_1.OutputWidget).toSelf();
    bind(browser_1.WidgetFactory).toDynamicValue(context => ({
        id: output_widget_1.OutputWidget.ID,
        createWidget: () => context.container.get(output_widget_1.OutputWidget)
    }));
    (0, browser_1.bindViewContribution)(bind, output_contribution_1.OutputContribution);
    bind(browser_1.OpenHandler).to(output_contribution_1.OutputContribution).inSingletonScope();
    bind(output_toolbar_contribution_1.OutputToolbarContribution).toSelf().inSingletonScope();
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(output_toolbar_contribution_1.OutputToolbarContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/output/lib/browser/output-toolbar-contribution.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/output/lib/browser/output-toolbar-contribution.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 Arm and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OutputToolbarContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const React = tslib_1.__importStar(__webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js"));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
const select_component_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/select-component */ "../../node_modules/@theia/core/lib/browser/widgets/select-component.js");
const output_widget_1 = __webpack_require__(/*! ./output-widget */ "../../node_modules/@theia/output/lib/browser/output-widget.js");
const output_commands_1 = __webpack_require__(/*! ./output-commands */ "../../node_modules/@theia/output/lib/browser/output-commands.js");
const output_contribution_1 = __webpack_require__(/*! ./output-contribution */ "../../node_modules/@theia/output/lib/browser/output-contribution.js");
const output_channel_1 = __webpack_require__(/*! ./output-channel */ "../../node_modules/@theia/output/lib/browser/output-channel.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let OutputToolbarContribution = class OutputToolbarContribution {
    constructor() {
        this.onOutputWidgetStateChangedEmitter = new event_1.Emitter();
        this.onOutputWidgetStateChanged = this.onOutputWidgetStateChangedEmitter.event;
        this.onChannelsChangedEmitter = new event_1.Emitter();
        this.onChannelsChanged = this.onChannelsChangedEmitter.event;
        this.NONE = '<no channels>';
        this.OUTPUT_CHANNEL_LIST_ID = 'outputChannelList';
        this.changeChannel = (option) => {
            const channelName = option.value;
            if (channelName !== this.NONE && channelName) {
                this.outputChannelManager.getChannel(channelName).show();
            }
        };
    }
    init() {
        this.outputContribution.widget.then(widget => {
            widget.onStateChanged(() => this.onOutputWidgetStateChangedEmitter.fire());
        });
        const fireChannelsChanged = () => this.onChannelsChangedEmitter.fire();
        this.outputChannelManager.onSelectedChannelChanged(fireChannelsChanged);
        this.outputChannelManager.onChannelAdded(fireChannelsChanged);
        this.outputChannelManager.onChannelDeleted(fireChannelsChanged);
        this.outputChannelManager.onChannelWasShown(fireChannelsChanged);
        this.outputChannelManager.onChannelWasHidden(fireChannelsChanged);
    }
    registerToolbarItems(toolbarRegistry) {
        toolbarRegistry.registerItem({
            id: 'channels',
            render: () => this.renderChannelSelector(),
            isVisible: widget => widget instanceof output_widget_1.OutputWidget,
            onDidChange: this.onChannelsChanged
        });
        toolbarRegistry.registerItem({
            id: output_commands_1.OutputCommands.CLEAR__WIDGET.id,
            command: output_commands_1.OutputCommands.CLEAR__WIDGET.id,
            tooltip: nls_1.nls.localizeByDefault('Clear Output'),
            priority: 1,
        });
        toolbarRegistry.registerItem({
            id: output_commands_1.OutputCommands.LOCK__WIDGET.id,
            command: output_commands_1.OutputCommands.LOCK__WIDGET.id,
            tooltip: nls_1.nls.localizeByDefault('Turn Auto Scrolling Off'),
            onDidChange: this.onOutputWidgetStateChanged,
            priority: 2
        });
        toolbarRegistry.registerItem({
            id: output_commands_1.OutputCommands.UNLOCK__WIDGET.id,
            command: output_commands_1.OutputCommands.UNLOCK__WIDGET.id,
            tooltip: nls_1.nls.localizeByDefault('Turn Auto Scrolling On'),
            onDidChange: this.onOutputWidgetStateChanged,
            priority: 2
        });
    }
    renderChannelSelector() {
        var _a, _b;
        const channelOptionElements = [];
        this.outputChannelManager.getVisibleChannels().forEach((channel, i) => {
            channelOptionElements.push({
                value: channel.name
            });
        });
        if (channelOptionElements.length === 0) {
            channelOptionElements.push({
                value: this.NONE
            });
        }
        return React.createElement("div", { id: this.OUTPUT_CHANNEL_LIST_ID, key: this.OUTPUT_CHANNEL_LIST_ID },
            React.createElement(select_component_1.SelectComponent, { key: (_a = this.outputChannelManager.selectedChannel) === null || _a === void 0 ? void 0 : _a.name, options: channelOptionElements, defaultValue: (_b = this.outputChannelManager.selectedChannel) === null || _b === void 0 ? void 0 : _b.name, onChange: option => this.changeChannel(option) }));
    }
};
exports.OutputToolbarContribution = OutputToolbarContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(output_channel_1.OutputChannelManager),
    tslib_1.__metadata("design:type", output_channel_1.OutputChannelManager)
], OutputToolbarContribution.prototype, "outputChannelManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(output_contribution_1.OutputContribution),
    tslib_1.__metadata("design:type", output_contribution_1.OutputContribution)
], OutputToolbarContribution.prototype, "outputContribution", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], OutputToolbarContribution.prototype, "init", null);
exports.OutputToolbarContribution = OutputToolbarContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], OutputToolbarContribution);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_output_lib_browser_output-frontend-module_js.js.map