/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { Response } from '@vscode/debugadapter';
import { DebugProtocol } from '@vscode/debugprotocol';
export interface RequestArguments extends DebugProtocol.LaunchRequestArguments {
    gdb?: string;
    gdbArguments?: string[];
    gdbAsync?: boolean;
    gdbNonStop?: boolean;
    environment?: Record<string, string | null>;
    program: string;
    cwd?: string;
    verbose?: boolean;
    logFile?: string;
    openGdbConsole?: boolean;
    initCommands?: string[];
    hardwareBreakpoint?: boolean;
    customResetCommands?: string[];
}
export interface LaunchRequestArguments extends RequestArguments {
    arguments?: string;
}
export interface AttachRequestArguments extends RequestArguments {
    processId: string;
}
export interface FrameReference {
    threadId: number;
    frameId: number;
}
export interface FrameVariableReference {
    type: 'frame';
    frameHandle: number;
}
export interface ObjectVariableReference {
    type: 'object';
    frameHandle: number;
    varobjName: string;
}
export interface RegisterVariableReference {
    type: 'registers';
    frameHandle: number;
    regname?: string;
}
export type VariableReference = FrameVariableReference | ObjectVariableReference | RegisterVariableReference;
export interface MemoryRequestArguments {
    address: string;
    length: number;
    offset?: number;
}
/**
 * Response for our custom 'cdt-gdb-adapter/Memory' request.
 */
export interface MemoryContents {
    data: string;
    address: string;
}
export interface MemoryResponse extends Response {
    body: MemoryContents;
}
export interface CDTDisassembleArguments extends DebugProtocol.DisassembleArguments {
    /**
     * Memory reference to the end location containing the instructions to disassemble. When this
     * optional setting is provided, the minimum number of lines needed to get to the endMemoryReference
     * is used.
     */
    endMemoryReference: string;
}
export interface UARTArguments {
    serialPort?: string;
    socketPort?: string;
    baudRate?: number;
    characterSize?: 5 | 6 | 7 | 8;
    parity?: 'none' | 'even' | 'odd' | 'mark' | 'space';
    stopBits?: 1 | 1.5 | 2;
    handshakingMethod?: 'none' | 'XON/XOFF' | 'RTS/CTS';
    eolCharacter?: 'LF' | 'CRLF';
}
export interface TargetAttachArguments {
    type?: string;
    parameters?: string[];
    host?: string;
    port?: string;
    connectCommands?: string[];
    uart?: UARTArguments;
}
export interface TargetLaunchArguments extends TargetAttachArguments {
    server?: string;
    serverParameters?: string[];
    environment?: Record<string, string | null>;
    serverPortRegExp?: string;
    serverStartupDelay?: number;
    automaticallyKillServer?: boolean;
    cwd?: string;
}
export interface ImageAndSymbolArguments {
    symbolFileName?: string;
    symbolOffset?: string;
    imageFileName?: string;
    imageOffset?: string;
}
export interface TargetAttachRequestArguments extends RequestArguments {
    target?: TargetAttachArguments;
    imageAndSymbols?: ImageAndSymbolArguments;
    preRunCommands?: string[];
}
export interface TargetLaunchRequestArguments extends TargetAttachRequestArguments {
    target?: TargetLaunchArguments;
    imageAndSymbols?: ImageAndSymbolArguments;
    preRunCommands?: string[];
}
