/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;

public class CommentsPreparator
extends ASTVisitor {
    public static final int COMMENT_LINE_SEPARATOR_LENGTH = 3;
    private static final Pattern NLS_TAG_PATTERN = Pattern.compile("//\\$NON-NLS-([0-9]+)\\$");
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("\".*?(\\\\(\\\\\\\\)*\".*?)*\"");
    private static final Pattern HTML_TAG_PATTERN;
    private static final Pattern HTML_ATTRIBUTE_PATTERN;
    private static final Pattern HTML_ENTITY_PATTERN;
    private static final String HTML_ENTITY_REPLACE = "   <> &^~\"";
    private static final Pattern SNIPPET_ATTRIBUTE_PATTERN;
    private static final Pattern SNIPPET_ATTRIBUTES_PATTERN;
    private static final Pattern SNIPPET_MARKUP_TAG_PATTERN;
    private static final Pattern SNIPPET_MARKUP_TAG_ARGUMENT_PATTERN;
    private static final List<String> PARAM_TAGS;
    private static final List<String> IMMUTABLE_TAGS;
    private final TokenManager tm;
    private final DefaultCodeFormatterOptions options;
    private final String sourceLevel;
    private final String formatDisableTag;
    private final String formatEnableTag;
    private Token lastLineComment;
    private int lastLineCommentPosition;
    private Token lastFormatOffComment;
    private TokenManager ctm;
    private List<Token> commentStructure;
    private int commentIndent;
    private boolean[] allowSubstituteWrapping;
    private int noFormatOpenTagStartIndex = -1;
    private int formatCodeOpenTagEndIndex = -1;
    private int lastFormatCodeClosingTagIndex = -1;
    private final ArrayList<Integer> commonAttributeAnnotations = new ArrayList();
    private DefaultCodeFormatter preTagCodeFormatter;
    private DefaultCodeFormatter snippetCodeFormatter;

    static {
        String formatCodeTags = "(pre)";
        String separateLineTags = "(nl|table|tr)";
        String breakBeforeTags = "(dd|dt|li|td|th|h1|h2|h3|h4|h5|h6|q)";
        String blockTags = "(p|dl|ul|ol|hr|dir)";
        String breakAfterTags = "(br)";
        String noFormatTags = "(code|tt)";
        String otherTags = "([\\S&&[^<>]]++)";
        String ws = "(?>[ \\t]++|[\\r\\n]++[ \\t]*+\\*?)";
        String attributeValue = "(?>\"[^\"]*\")|(?>'[^']*')|[\\S&&[^/>\"']]++";
        String attribute = "(?>" + ws + "+[\\S&&[^=]]+" + ws + "*(=)" + ws + "*(?>" + attributeValue + "))";
        HTML_TAG_PATTERN = Pattern.compile("<(/)?+(?:" + formatCodeTags + "|" + separateLineTags + "|" + breakBeforeTags + "|" + breakAfterTags + "|" + noFormatTags + "|" + blockTags + "|" + otherTags + ")(" + attribute + "*)" + ws + "*/?>", 2);
        HTML_ATTRIBUTE_PATTERN = Pattern.compile(attribute);
        HTML_ENTITY_PATTERN = Pattern.compile("&(#x[0-9a-fA-F]+)?(#[0-9]+)?(lt)?(gt)?(nbsp)?(amp)?(circ)?(tilde)?(quot)?;");
        String attributeNames = "(class|file|id|lang|region)";
        String markupTagNames = "(@start|@end|@highlight|@replace|@link)";
        String ws2 = "(?>[ \\t]++|[\\r\\n]++[ \\t]*+\\*?)";
        String attributeValue2 = "(?>\"[^\"]*\")|(?>'[^']*')|[\\S&&[^\"':]]++";
        String snippetAttribute = "(?>" + ws2 + "*" + attributeNames + ws2 + "*(=)" + ws2 + "*(" + attributeValue2 + "))";
        String markupTagArgument = "(?>[ \\t]*\\w+(?>[ \\t]*(=)[ \\t]*(" + attributeValue2 + "))?)";
        SNIPPET_ATTRIBUTE_PATTERN = Pattern.compile(snippetAttribute);
        SNIPPET_ATTRIBUTES_PATTERN = Pattern.compile(snippetAttribute + "*" + ws2 + "*(?<colon>:?)");
        SNIPPET_MARKUP_TAG_ARGUMENT_PATTERN = Pattern.compile(markupTagArgument);
        SNIPPET_MARKUP_TAG_PATTERN = Pattern.compile(markupTagNames + markupTagArgument + "*");
        PARAM_TAGS = Arrays.asList("@param", "@exception", "@serialField", "@throws");
        IMMUTABLE_TAGS = Arrays.asList("@code", "@literal");
    }

    public CommentsPreparator(TokenManager tm, DefaultCodeFormatterOptions options, String sourceLevel) {
        this.tm = tm;
        this.options = options;
        this.sourceLevel = sourceLevel;
        this.formatDisableTag = options.disabling_tag != null ? new String(options.disabling_tag) : null;
        this.formatEnableTag = options.enabling_tag != null ? new String(options.enabling_tag) : null;
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        boolean isMalformed = (node.getFlags() & 1) != 0;
        return !isMalformed;
    }

    @Override
    public boolean visit(LineComment node) {
        int commentIndex = this.tm.firstIndexIn(node, 1001);
        this.handleLineComment(commentIndex);
        return true;
    }

    public void handleLineComment(int commentIndex) {
        boolean formattingEnabled;
        Token commentToken = this.tm.get(commentIndex);
        boolean isOnFirstColumn = this.handleWhitespaceAround(commentIndex);
        if (this.handleFormatOnOffTags(commentToken)) {
            return;
        }
        if (isOnFirstColumn) {
            if (this.options.comment_format_line_comment && !this.options.comment_format_line_comment_starting_on_first_column) {
                this.lastLineComment = null;
                commentToken.setIndent(0);
                commentToken.setWrapPolicy(Token.WrapPolicy.FORCE_FIRST_COLUMN);
                return;
            }
            if (this.options.never_indent_line_comments_on_first_column) {
                commentToken.setIndent(0);
                commentToken.setWrapPolicy(Token.WrapPolicy.FORCE_FIRST_COLUMN);
            }
        }
        this.handleNLSTags(commentToken, commentIndex);
        int positionInLine = this.tm.findSourcePositionInLine(commentToken.originalStart);
        boolean isContinuation = commentIndex > 0 && this.tm.get(commentIndex - 1) == this.lastLineComment && positionInLine >= this.lastLineCommentPosition - this.options.indentation_size + 1 && this.tm.countLineBreaksBetween(this.lastLineComment, commentToken) == 1;
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = isHeader ? this.options.comment_format_header : this.options.comment_format_line_comment;
        if (!formattingEnabled) {
            this.preserveWhitespace(commentToken, commentIndex);
            if (isContinuation) {
                Token.WrapPolicy policy = this.lastLineComment.getWrapPolicy();
                if (policy == null) {
                    int lineStart = this.tm.getPositionInLine(this.tm.findFirstTokenInLine(commentIndex - 1));
                    int commentStart = this.tm.getPositionInLine(commentIndex - 1);
                    policy = new Token.WrapPolicy(Token.WrapMode.WHERE_NECESSARY, commentIndex - 1, commentStart - lineStart);
                }
                commentToken.setWrapPolicy(policy);
                this.lastLineComment = commentToken;
            } else if (commentToken.getLineBreaksBefore() == 0) {
                this.lastLineComment = commentToken;
                this.lastLineCommentPosition = positionInLine;
            }
            return;
        }
        List<Token> structure = this.tokenizeLineComment(commentToken);
        if (isContinuation) {
            if (this.options.join_line_comments) {
                structure.remove(0);
            } else {
                Token first = structure.get(0);
                first.breakBefore();
                first.setWrapPolicy(new Token.WrapPolicy(Token.WrapMode.WHERE_NECESSARY, commentIndex - 1, this.lastLineCommentPosition));
            }
            Token previous = this.lastLineComment;
            Token merged = new Token(previous, previous.originalStart, commentToken.originalEnd, previous.tokenType);
            merged.putLineBreaksAfter(commentToken.getLineBreaksAfter());
            merged.setPreserveLineBreaksAfter(commentToken.isPreserveLineBreaksAfter());
            this.tm.remove(commentIndex - 1);
            this.tm.insert(commentIndex - 1, merged);
            this.tm.remove(commentIndex);
            List<Token> lastStructure = this.lastLineComment.getInternalStructure();
            lastStructure.addAll(structure);
            merged.setInternalStructure(lastStructure);
            this.lastLineComment = merged;
        } else {
            commentToken.setInternalStructure(structure);
            this.handleCompilerTags(commentToken, commentIndex);
            this.handleSnippetMarkupTags(commentToken);
            this.preserveWhitespace(commentToken, commentIndex);
            this.lastLineComment = commentToken;
            this.lastLineCommentPosition = positionInLine;
        }
    }

    private void preserveWhitespace(Token commentToken, int commentIndex) {
        if (this.options.comment_preserve_white_space_between_code_and_line_comments && commentToken.getLineBreaksBefore() == 0 && commentIndex > 0) {
            commentToken.clearSpaceBefore();
            List<Token> structure = commentToken.getInternalStructure();
            if (structure != null && !structure.isEmpty()) {
                structure.get(0).clearSpaceBefore();
            }
            Token previous = this.tm.get(commentIndex - 1);
            previous.clearSpaceAfter();
            if (previous.originalEnd + 1 >= commentToken.originalStart) {
                return;
            }
            if (structure == null || structure.isEmpty()) {
                structure = new ArrayList<Token>();
                structure.add(new Token(previous.originalEnd + 1, commentToken.originalEnd, 1001));
                commentToken.setInternalStructure(structure);
            } else {
                structure.add(0, new Token(previous.originalEnd + 1, commentToken.originalStart - 1, 1000));
            }
        }
    }

    private boolean handleFormatOnOffTags(Token commentToken) {
        int onIndex;
        if (!this.options.use_tags) {
            return false;
        }
        String commentString = this.tm.toString(commentToken);
        int offIndex = this.formatDisableTag != null ? commentString.lastIndexOf(this.formatDisableTag) : -1;
        int n = onIndex = this.formatEnableTag != null ? commentString.lastIndexOf(this.formatEnableTag) : -1;
        if (this.lastFormatOffComment == null) {
            if (offIndex > onIndex) {
                this.lastFormatOffComment = commentToken;
            }
        } else if (onIndex > offIndex) {
            this.tm.addDisableFormatTokenPair(this.lastFormatOffComment, commentToken);
            this.lastFormatOffComment = null;
        }
        return offIndex >= 0 || onIndex >= 0;
    }

    private void handleNLSTags(Token comment, int commentIndex) {
        List<Token> stringLiterals = this.findStringLiteralsInLine(commentIndex);
        if (stringLiterals.isEmpty()) {
            return;
        }
        ArrayList<Token> commentFragments = new ArrayList<Token>();
        Matcher matcher = NLS_TAG_PATTERN.matcher(this.tm.toString(comment));
        int previousMatcherEnd = 0;
        boolean nlsFound = false;
        while (matcher.find()) {
            int nlsNumber = Integer.parseInt(matcher.group(1));
            if (nlsNumber <= 0 || nlsNumber > stringLiterals.size()) continue;
            if (matcher.start() > previousMatcherEnd) {
                Token fragment = new Token(comment.originalStart + previousMatcherEnd, comment.originalStart + matcher.start() - 1, 1001);
                commentFragments.add(fragment);
            }
            Token nlsTag = new Token(comment.originalStart + matcher.start(), comment.originalStart + matcher.end() - 1, 1001);
            stringLiterals.get(nlsNumber - 1).setNLSTag(nlsTag);
            nlsTag.setNLSTag(stringLiterals.get(nlsNumber - 1));
            commentFragments.add(nlsTag);
            nlsFound = true;
            previousMatcherEnd = matcher.end();
        }
        if (nlsFound) {
            comment.setInternalStructure(commentFragments);
            if (comment.originalStart + previousMatcherEnd <= comment.originalEnd) {
                Token fragment = new Token(comment.originalStart + previousMatcherEnd, comment.originalEnd, 1001);
                commentFragments.add(fragment);
            }
        }
    }

    private void handleCompilerTags(Token commentToken, int commentIndex) {
        String commentText = this.tm.toString(commentToken);
        List<Token> structure = commentToken.getInternalStructure();
        if (commentText.startsWith("//$FALL-THROUGH$") || commentText.startsWith("//$IDENTITY-COMPARISON$")) {
            structure.get(1).clearSpaceBefore();
        }
        if (commentText.contains("//$IDENTITY-COMPARISON$")) {
            Token token = commentToken;
            int i = commentIndex;
            while (i > 0) {
                Token left = this.tm.get(i - 1);
                if (this.tm.countLineBreaksBetween(left, token) > 0) break;
                token.clearLineBreaksBefore();
                left.clearLineBreaksAfter();
                token.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
                token = left;
                --i;
            }
        }
    }

    private void handleSnippetMarkupTags(Token commentToken) {
        String commentText = this.tm.toString(commentToken);
        Matcher m = SNIPPET_MARKUP_TAG_PATTERN.matcher(commentText);
        while (m.find()) {
            Matcher m2 = SNIPPET_MARKUP_TAG_ARGUMENT_PATTERN.matcher(m.group());
            if (!m2.find()) continue;
            this.commentStructure = commentToken.getInternalStructure();
            this.ctm = new TokenManager(this.commentStructure, this.tm);
            if (commentToken.tokenType != 1001) continue;
            do {
                this.handleFoundAssignment(m2, 1, commentToken.originalStart + m.start());
                this.handleFoundStringLiteral(m2, 2, commentToken.originalStart + m.start());
            } while (m2.find());
        }
    }

    private List<Token> findStringLiteralsInLine(int lastTokenIndex) {
        ArrayList<Token> stringLiterals = new ArrayList<Token>();
        Token previous = this.tm.get(lastTokenIndex);
        int i = lastTokenIndex - 1;
        while (i >= 0) {
            Token token = this.tm.get(i);
            if (this.tm.countLineBreaksBetween(token, previous) > 0) break;
            if (token.tokenType == 41 || token.tokenType == 42) {
                stringLiterals.add(token);
            }
            previous = token;
            --i;
        }
        Collections.reverse(stringLiterals);
        return stringLiterals;
    }

    private List<Token> tokenizeLineComment(Token commentToken) {
        List<Token> fragments = commentToken.getInternalStructure();
        if (fragments == null) {
            fragments = Arrays.asList(commentToken);
        }
        ArrayList<Token> result = new ArrayList<Token>();
        int i = 0;
        while (i < fragments.size()) {
            Token token = fragments.get(i);
            if (token.hasNLSTag()) {
                if (ScannerHelper.isWhitespace((char)this.tm.charAt(token.originalStart - 1))) {
                    token.spaceBefore();
                }
                result.add(token);
            } else {
                int sourcePosition = token.originalStart;
                if (sourcePosition == commentToken.originalStart) {
                    while (sourcePosition <= token.originalEnd && this.tm.charAt(sourcePosition) == '/') {
                        ++sourcePosition;
                    }
                    result.add(new Token(commentToken.originalStart, sourcePosition - 1, 1001));
                }
                int tokenStart = sourcePosition;
                while (sourcePosition <= token.originalEnd + 1) {
                    if (sourcePosition == token.originalEnd + 1 || ScannerHelper.isWhitespace((char)this.tm.charAt(sourcePosition))) {
                        if (tokenStart < sourcePosition) {
                            Token outputToken = new Token(tokenStart, sourcePosition - 1, 1001);
                            outputToken.spaceBefore();
                            result.add(outputToken);
                        }
                        tokenStart = sourcePosition + 1;
                    }
                    ++sourcePosition;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean visit(BlockComment node) {
        int commentIndex = this.tm.firstIndexIn(node, 1002);
        this.handleBlockComment(commentIndex);
        return true;
    }

    public void handleBlockComment(int commentIndex) {
        boolean formattingEnabled;
        Token commentToken = this.tm.get(commentIndex);
        boolean isFirstColumn = this.handleWhitespaceAround(commentIndex);
        if (this.handleFormatOnOffTags(commentToken)) {
            return;
        }
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = isHeader ? this.options.comment_format_header : this.options.comment_format_block_comment;
        if (this.tm.charAt(commentToken.originalStart + 2) == '-') {
            if (commentToken.getLineBreaksBefore() > 0 || commentIndex == 0 || this.tm.get(commentIndex - 1).getLineBreaksAfter() > 0) {
                formattingEnabled = false;
            } else {
                return;
            }
        }
        if (formattingEnabled && this.tokenizeMultilineComment(commentToken)) {
            this.commentStructure = commentToken.getInternalStructure();
            this.ctm = new TokenManager(this.commentStructure, this.tm);
            this.handleStringLiterals(this.tm.toString(commentToken), commentToken.originalStart);
            this.addSubstituteWraps();
        } else {
            commentToken.setInternalStructure(this.commentToLines(commentToken, -1));
        }
        if (this.options.never_indent_block_comments_on_first_column && isFirstColumn) {
            commentToken.setIndent(0);
            commentToken.setWrapPolicy(Token.WrapPolicy.FORCE_FIRST_COLUMN);
        }
    }

    private boolean handleWhitespaceAround(int commentIndex) {
        char charAfter;
        int charBefore;
        Token commentToken = this.tm.get(commentIndex);
        int n = charBefore = commentToken.originalStart > 0 ? (int)this.tm.charAt(commentToken.originalStart - 1) : 0;
        if (charBefore == 32 || charBefore == 9) {
            commentToken.spaceBefore();
        }
        if (commentToken.originalEnd < this.tm.getSourceLength() - 1 && ((charAfter = this.tm.charAt(commentToken.originalEnd + 1)) == ' ' || charAfter == '\t')) {
            commentToken.spaceAfter();
        }
        Token previous = null;
        Token next = null;
        int existingBreaksBefore = 2;
        int existingBreaksAfter = 2;
        if (commentIndex > 0 && (existingBreaksBefore = this.tm.countLineBreaksBetween(previous = this.tm.get(commentIndex - 1), commentToken)) > 0) {
            commentToken.breakBefore();
            commentToken.clearSpaceBefore();
        }
        if (commentIndex < this.tm.size() - 1 && (existingBreaksAfter = this.tm.countLineBreaksBetween(commentToken, next = this.tm.get(commentIndex + 1))) > 0) {
            commentToken.breakAfter();
        }
        if (existingBreaksBefore <= 1 && (previous.tokenType == 1001 || previous.tokenType == 1002)) {
            if (previous.getWrapPolicy() != Token.WrapPolicy.FORCE_FIRST_COLUMN) {
                commentToken.setWrapPolicy(previous.getWrapPolicy());
            }
        } else {
            int i = commentIndex + 2;
            while (existingBreaksAfter <= 1 && i < this.tm.size() && (next.tokenType == 1001 || next.tokenType == 1002)) {
                Token next2 = this.tm.get(i++);
                existingBreaksAfter = this.tm.countLineBreaksBetween(next, next2);
                next = next2;
            }
            if (existingBreaksBefore < existingBreaksAfter && previous != null) {
                if (previous.isPreserveLineBreaksAfter() || previous.getLineBreaksAfter() >= 2 || existingBreaksAfter < 2) {
                    commentToken.putLineBreaksAfter(previous.getLineBreaksAfter());
                    commentToken.setPreserveLineBreaksAfter(previous.isPreserveLineBreaksAfter());
                    previous.clearLineBreaksAfter();
                    previous.setPreserveLineBreaksAfter(true);
                }
            } else if (existingBreaksAfter < 2 && existingBreaksAfter <= existingBreaksBefore && next != null && next.tokenType != 90 && (next.isPreserveLineBreaksBefore() || next.getLineBreaksBefore() >= 2 || existingBreaksBefore < 2)) {
                commentToken.putLineBreaksBefore(next.getLineBreaksBefore());
                commentToken.setPreserveLineBreaksBefore(next.isPreserveLineBreaksBefore());
                next.clearLineBreaksBefore();
                next.setPreserveLineBreaksBefore(true);
            }
        }
        boolean isFirstColumn = charBefore == 13 || charBefore == 10 || commentToken.originalStart == 0;
        return isFirstColumn;
    }

    private List<Token> commentToLines(Token commentToken, int commentStartPositionInLine) {
        ArrayList<Token> lines = new ArrayList<Token>();
        int tab = this.options.tab_size;
        String commentText = this.tm.toString(commentToken);
        int commentStartPosition = commentStartPositionInLine;
        if (commentStartPosition < 0) {
            commentStartPosition = this.tm.findSourcePositionInLine(commentToken.originalStart);
        }
        int positionInLine = commentStartPosition;
        int lineStart = 0;
        int breaksBeforeFirstLine = 0;
        boolean firstLine = true;
        boolean emptyLine = true;
        int i = 0;
        while (i < commentText.length()) {
            char c = commentText.charAt(i);
            switch (c) {
                case ' ': {
                    if (lineStart == i && positionInLine < commentStartPosition || emptyLine && positionInLine == commentToken.getIndent() - 1) {
                        lineStart = i + 1;
                    }
                    ++positionInLine;
                    break;
                }
                case '\t': {
                    if (lineStart == i && positionInLine < commentStartPosition || emptyLine && positionInLine == commentToken.getIndent() - 1) {
                        lineStart = i + 1;
                    }
                    if (tab <= 0) break;
                    positionInLine += tab - positionInLine % tab;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (lineStart < i) {
                        Token line = new Token(commentToken.originalStart + lineStart, commentToken.originalStart + i - 1, firstLine ? commentToken.tokenType : 0);
                        line.breakAfter();
                        if (lines.isEmpty()) {
                            line.putLineBreaksBefore(breaksBeforeFirstLine);
                        }
                        lines.add(line);
                    } else if (!lines.isEmpty()) {
                        Token previousLine = (Token)lines.get(lines.size() - 1);
                        previousLine.putLineBreaksAfter(previousLine.getLineBreaksAfter() + 1);
                    } else {
                        ++breaksBeforeFirstLine;
                    }
                    if (i + 1 < commentText.length() && commentText.charAt(i + 1) == (c == '\r' ? (char)'\n' : '\r')) {
                        ++i;
                    }
                    lineStart = i + 1;
                    positionInLine = 0;
                    firstLine = false;
                    emptyLine = true;
                    break;
                }
                default: {
                    ++positionInLine;
                    emptyLine = false;
                }
            }
            ++i;
        }
        if (lineStart < commentText.length()) {
            Token line = new Token(commentToken.originalStart + lineStart, commentToken.originalEnd, firstLine ? commentToken.tokenType : 0);
            line.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
            lines.add(line);
        }
        return lines;
    }

    @Override
    public boolean visit(Javadoc node) {
        boolean formattingEnabled;
        this.noFormatOpenTagStartIndex = -1;
        this.formatCodeOpenTagEndIndex = -1;
        this.lastFormatCodeClosingTagIndex = -1;
        this.commonAttributeAnnotations.clear();
        this.ctm = null;
        int commentIndex = this.tm.firstIndexIn(node, 1003);
        Token commentToken = this.tm.get(commentIndex);
        if (node.getParent() == null) {
            this.handleWhitespaceAround(commentIndex);
        }
        if (commentIndex < this.tm.size() - 1) {
            commentToken.breakAfter();
        }
        if (this.handleFormatOnOffTags(commentToken)) {
            return false;
        }
        boolean isHeader = this.tm.isInHeader(commentIndex);
        boolean bl = formattingEnabled = isHeader ? this.options.comment_format_header : this.options.comment_format_javadoc_comment;
        if (!formattingEnabled || !this.tokenizeMultilineComment(commentToken)) {
            commentToken.setInternalStructure(this.commentToLines(commentToken, -1));
            return false;
        }
        this.commentStructure = commentToken.getInternalStructure();
        this.commentIndent = this.tm.toIndent(commentToken.getIndent(), true);
        this.ctm = new TokenManager(commentToken.getInternalStructure(), this.tm);
        this.handleJavadocTagAlignment(node);
        this.handleJavadocBlankLines(node);
        return true;
    }

    @Override
    public void endVisit(Javadoc node) {
        if (this.ctm == null) {
            return;
        }
        this.addSubstituteWraps();
    }

    @Override
    public boolean visit(TagElement node) {
        String tagName = node.getTagName();
        if (tagName == null || tagName.length() <= 1 || !node.tagProperties().isEmpty()) {
            return true;
        }
        int startIndex = this.tokenStartingAt(node.getStartPosition());
        this.ctm.get(startIndex + 1).setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
        if (node.getParent() instanceof Javadoc) {
            assert (this.ctm.toString(startIndex).startsWith(tagName));
            if (startIndex > 1) {
                this.ctm.get(startIndex).breakBefore();
            }
            this.handleHtml(node);
            this.ctm.get(this.tokenStartingAt(node.getStartPosition())).setToEscape(false);
        } else if (node.isNested() && (IMMUTABLE_TAGS.contains(tagName) || "@snippet".equals(tagName))) {
            int endPos = node.getStartPosition() + node.getLength() - 1;
            int endIndex = this.ctm.findIndex(endPos, -1, false);
            if (this.ctm.get((int)endIndex).originalEnd > endPos) {
                endIndex = this.tokenEndingAt(endPos);
            }
            if ("@snippet".equals(tagName)) {
                this.handleSnippet(node, startIndex, endIndex);
            } else {
                this.disableFormatting(startIndex, endIndex, false);
            }
        }
        return true;
    }

    @Override
    public void endVisit(TagElement node) {
        String tagName = node.getTagName();
        if (tagName == null || tagName.length() <= 1) {
            this.handleHtml(node);
        } else if ("@see".equals(tagName)) {
            this.handleStringLiterals(this.tm.toString(node), node.getStartPosition());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleJavadocTagAlignment(Javadoc node) {
        ArrayList javadocRootTags = new ArrayList();
        List tagElements = node.tags();
        for (TagElement tagElement : tagElements) {
            String string = tagElement.getTagName();
            if (string == null || string.length() <= 1) continue;
            int startIndex = this.tokenStartingAt(tagElement.getStartPosition());
            int n = tagElement.getStartPosition() + tagElement.getLength() - 1;
            while (ScannerHelper.isWhitespace((char)this.ctm.charAt(n))) {
                --n;
            }
            int endIndex = this.tokenEndingAt(n);
            ArrayList<Token> tagTokens = new ArrayList<Token>();
            tagTokens.add(this.ctm.get(startIndex));
            if (!PARAM_TAGS.contains(string) || startIndex == endIndex) {
                tagTokens.add(null);
            }
            int i = startIndex + 1;
            while (i <= endIndex) {
                tagTokens.add(this.ctm.get(i));
                ++i;
            }
            javadocRootTags.add(tagTokens);
        }
        if (this.options.comment_align_tags_names_descriptions) {
            void var6_16;
            int n;
            boolean bl = false;
            int maxParamNameLength = 0;
            for (List list : javadocRootTags) {
                Token token = (Token)list.get(0);
                Token paramName = (Token)list.get(1);
                n = Math.max(n, this.tm.getLength(token, 0));
                if (paramName == null) continue;
                maxParamNameLength = Math.max(maxParamNameLength, this.tm.getLength(paramName, 0));
            }
            void descriptionAlign = var6_16 = n + true;
            if (maxParamNameLength > 0) {
                descriptionAlign += maxParamNameLength + 1;
            }
            for (List list : javadocRootTags) {
                this.alignJavadocTag(list, (int)var6_16, (int)descriptionAlign);
            }
        } else if (this.options.comment_align_tags_descriptions_grouped) {
            int n;
            int n2;
            boolean bl = false;
            String groupTagName = null;
            boolean bl2 = false;
            int i = 0;
            while (i < javadocRootTags.size()) {
                List list = (List)javadocRootTags.get(i);
                String tagName = this.ctm.toString((Token)list.get(0));
                if (!tagName.equals(groupTagName)) {
                    void j = n2;
                    while (j < i) {
                        this.alignJavadocTag((List)javadocRootTags.get((int)j), 0, n);
                        ++j;
                    }
                    n2 = i;
                    groupTagName = tagName;
                    n = 0;
                }
                int indent = tagName.length() + 1;
                if (list.get(1) != null) {
                    indent += 1 + this.ctm.getLength((Token)list.get(1), 0);
                }
                n = Math.max(n, indent);
                ++i;
            }
            void j = n2;
            while (j < javadocRootTags.size()) {
                this.alignJavadocTag((List)javadocRootTags.get((int)j), 0, n);
                ++j;
            }
        } else {
            for (List list : javadocRootTags) {
                int n = this.ctm.getLength((Token)list.get(0), 0);
                int align = this.options.comment_indent_root_tags ? n + 1 : 0;
                this.alignJavadocTag(list, 0, align);
            }
        }
    }

    private void handleJavadocBlankLines(Javadoc node) {
        List tagElements = node.tags();
        List tagIndexes = tagElements.stream().filter(t -> !t.isNested() && t.getTagName() != null && t.getTagName().length() > 1).map(t -> this.tokenStartingAt(t.getStartPosition())).collect(Collectors.toList());
        tagIndexes.addAll(this.commonAttributeAnnotations);
        Collections.sort(tagIndexes);
        String previousName = null;
        if (!tagIndexes.isEmpty()) {
            int firstIndex = (Integer)tagIndexes.get(0);
            previousName = this.ctm.toString(firstIndex);
            if (this.options.comment_insert_empty_line_before_root_tags && firstIndex > 1) {
                this.ctm.get(firstIndex).putLineBreaksBefore(2);
            }
        }
        if (this.options.comment_insert_empty_line_between_different_tags) {
            int i = 1;
            while (i < tagIndexes.size()) {
                boolean sameType;
                Token tagToken = this.ctm.get((Integer)tagIndexes.get(i));
                String thisName = this.tm.toString(tagToken);
                boolean bl = sameType = previousName.equals(thisName) || this.isCommonsAttributeAnnotation(previousName) && this.isCommonsAttributeAnnotation(thisName);
                if (!sameType) {
                    tagToken.putLineBreaksBefore(2);
                }
                previousName = thisName;
                ++i;
            }
        }
    }

    private void alignJavadocTag(List<Token> tagTokens, int paramNameAlign, int descriptionAlign) {
        Token paramName = tagTokens.get(1);
        if (paramName != null) {
            paramName.setAlign(paramNameAlign);
            if (this.options.comment_insert_new_line_for_parameter && tagTokens.size() > 2) {
                tagTokens.get(2).breakBefore();
            }
        }
        boolean extraIndent = paramName != null ? this.options.comment_indent_parameter_description : this.options.comment_indent_tag_description;
        int i = 2;
        while (i < tagTokens.size()) {
            Token token = tagTokens.get(i);
            token.setAlign(descriptionAlign);
            token.setIndent(extraIndent ? this.options.indentation_size : 0);
            ++i;
        }
    }

    private void handleHtml(TagElement node) {
        if (!this.options.comment_format_html && !this.options.comment_format_source) {
            return;
        }
        String text = this.tm.toString(node);
        Matcher matcher = HTML_TAG_PATTERN.matcher(text);
        while (matcher.find()) {
            boolean isOpeningTag;
            int startPos = matcher.start() + node.getStartPosition();
            int endPos = matcher.end() - 1 + node.getStartPosition();
            boolean bl = isOpeningTag = matcher.start(1) == matcher.end(1);
            if (this.options.comment_format_html) {
                int firstTokenIndex = this.tokenStartingAt(startPos);
                int lastTokenIndex = this.tokenEndingAt(endPos);
                int i = firstTokenIndex + 1;
                while (i <= lastTokenIndex) {
                    Token token = this.ctm.get(i);
                    if (token.getWrapPolicy() == null) {
                        token.setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                    }
                    ++i;
                }
                String attributesText = matcher.group(9);
                Matcher attrMatcher = HTML_ATTRIBUTE_PATTERN.matcher(attributesText);
                int commentStart = this.ctm.get((int)0).originalStart;
                while (attrMatcher.find()) {
                    int equalPos = node.getStartPosition() + matcher.start(9) + attrMatcher.start(1);
                    assert (this.tm.charAt(equalPos) == '=');
                    this.allowSubstituteWrapping[equalPos - commentStart] = true;
                }
            }
            int matchedGroups = 0;
            int i = 2;
            while (i <= 7) {
                if (matcher.start(i) < matcher.end(i)) {
                    ++matchedGroups;
                }
                ++i;
            }
            if (matchedGroups != 1) continue;
            if (matcher.start(2) < matcher.end(2)) {
                this.handleFormatCodeTag(node, startPos, endPos, isOpeningTag);
            }
            if (!this.options.comment_format_html || "@param".equals(node.getTagName()) && this.ctm.findIndex(startPos, -1, false) == 1 + this.ctm.firstIndexIn(node, -1)) continue;
            if (matcher.start(3) < matcher.end(3)) {
                this.handleSeparateLineTag(startPos, endPos);
                continue;
            }
            if (matcher.start(4) < matcher.end(4)) {
                this.handleBreakBeforeTag(startPos, endPos, isOpeningTag);
                if (!this.options.comment_javadoc_do_not_separate_block_tags || isOpeningTag) continue;
                this.handleBreakAfterTag(startPos, endPos);
                continue;
            }
            if (matcher.start(5) < matcher.end(5)) {
                this.handleBreakAfterTag(startPos, endPos);
                continue;
            }
            if (matcher.start(6) < matcher.end(6)) {
                this.handleNoFormatTag(startPos, endPos, isOpeningTag);
                continue;
            }
            if (matcher.start(7) >= matcher.end(7)) continue;
            if (this.options.comment_javadoc_do_not_separate_block_tags) {
                this.handleBreakBeforeTag(startPos, endPos, isOpeningTag);
                if (isOpeningTag) continue;
                this.handleBreakAfterTag(startPos, endPos);
                continue;
            }
            this.handleSeparateLineTag(startPos, endPos);
        }
    }

    @Override
    public boolean visit(MethodRef node) {
        this.handleReference(node);
        return true;
    }

    @Override
    public boolean visit(MemberRef node) {
        this.handleReference(node);
        return true;
    }

    @Override
    public boolean visit(QualifiedName node) {
        this.handleReference(node);
        return false;
    }

    private void handleReference(ASTNode node) {
        ASTNode parent = node.getParent();
        if (parent instanceof TagElement && ((TagElement)parent).isNested()) {
            int firstIndex = this.tokenStartingAt(node.getStartPosition());
            int lastIndex = this.tokenEndingAt(node.getStartPosition() + node.getLength() - 1);
            if (this.ctm.charAt(this.ctm.get((int)(lastIndex + 1)).originalStart) == '}') {
                ++lastIndex;
            }
            int i = firstIndex;
            while (i <= lastIndex) {
                Token token = this.ctm.get(i);
                token.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
                ++i;
            }
        }
    }

    private void handleStringLiterals(String text, int textStartPosition) {
        Matcher matcher = STRING_LITERAL_PATTERN.matcher(text);
        while (matcher.find()) {
            this.handleFoundStringLiteral(matcher, 0, textStartPosition);
        }
    }

    private void handleFoundStringLiteral(Matcher matcher, int group, int textStartPosition) {
        int endPosition;
        int endIndex;
        if (matcher.start(group) == matcher.end(group)) {
            return;
        }
        int startPosition = textStartPosition + matcher.start(group);
        int startIndex = this.ctm.findIndex(startPosition, -1, false);
        if (startIndex != (endIndex = this.ctm.findIndex(endPosition = textStartPosition + matcher.end(group) - 1, -1, false))) {
            startIndex = this.tokenStartingAt(startPosition);
            endIndex = this.tokenEndingAt(endPosition);
            this.disableFormatting(startIndex, endIndex, false);
        }
        if (this.ctm.get((int)0).tokenType != 1001) {
            this.noSubstituteWrapping(startPosition, endPosition);
        }
    }

    private void handleFoundAssignment(Matcher matcher, int group, int textStartPosition) {
        if (matcher.start(group) == matcher.end(group)) {
            return;
        }
        int equalsPosition = textStartPosition + matcher.start(group);
        int equalsIndex = this.tokenStartingAt(equalsPosition);
        equalsIndex = this.tokenEndingAt(equalsPosition);
        assert (this.ctm.toString(equalsIndex).equals("="));
        if (this.options.insert_space_before_assignment_operator) {
            this.ctm.get(equalsIndex).spaceBefore();
        } else {
            this.ctm.get(equalsIndex).clearSpaceBefore();
        }
        if (this.options.insert_space_after_assignment_operator) {
            this.ctm.get(equalsIndex + 1).spaceBefore();
        } else {
            this.ctm.get(equalsIndex + 1).clearSpaceBefore();
        }
    }

    private void handleSeparateLineTag(int startPos, int endPos) {
        int openingTagIndex = this.tokenStartingAt(startPos);
        if (openingTagIndex > 1 && this.lastFormatCodeClosingTagIndex == openingTagIndex - 1) {
            Token token = this.ctm.get(openingTagIndex - 1);
            assert (token.getLineBreaksAfter() == 2);
            token.clearLineBreaksAfter();
            token.breakAfter();
        }
        this.handleBreakBeforeTag(startPos, endPos, true);
        this.handleBreakAfterTag(startPos, endPos);
    }

    private void handleBreakBeforeTag(int start, int end, boolean isOpeningTag) {
        int firstPartIndex = this.tokenStartingAt(start);
        int lastPartIndex = this.tokenEndingAt(end);
        Token firstPartToken = this.ctm.get(firstPartIndex);
        firstPartToken.setWrapPolicy(null);
        if (isOpeningTag) {
            firstPartToken.breakBefore();
            this.ctm.get(lastPartIndex + 1).clearSpaceBefore();
        } else {
            firstPartToken.clearSpaceBefore();
        }
    }

    private void handleBreakAfterTag(int start, int end) {
        int tokenIndex = this.tokenEndingAt(end);
        this.ctm.get(tokenIndex).breakAfter();
    }

    private void handleNoFormatTag(int start, int end, boolean isOpeningTag) {
        if (isOpeningTag) {
            if (this.noFormatOpenTagStartIndex < 0) {
                this.noFormatOpenTagStartIndex = this.tokenStartingAt(start);
            }
        } else if (this.noFormatOpenTagStartIndex >= 0) {
            int closingTagIndex = this.tokenEndingAt(end);
            if (this.noFormatOpenTagStartIndex < closingTagIndex) {
                this.disableFormatting(this.noFormatOpenTagStartIndex, closingTagIndex, true);
            }
            this.noFormatOpenTagStartIndex = -1;
        }
    }

    private void handleFormatCodeTag(TagElement tagElement, int startPos, int endPos, boolean isOpeningTag) {
        if (!this.options.comment_format_source) {
            this.handleNoFormatTag(startPos, endPos, isOpeningTag);
            return;
        }
        this.handleSeparateLineTag(startPos, endPos);
        int startIndex = this.tokenStartingAt(startPos);
        int endTagIndex = this.tokenEndingAt(endPos);
        if (isOpeningTag) {
            if (startIndex > 1) {
                this.ctm.get(startIndex).putLineBreaksBefore(2);
            }
            if (this.formatCodeOpenTagEndIndex < 0) {
                this.formatCodeOpenTagEndIndex = endTagIndex;
            }
        } else if (this.formatCodeOpenTagEndIndex >= 0) {
            if (endTagIndex < this.ctm.size() - 2) {
                this.ctm.get(endTagIndex).putLineBreaksAfter(2);
            }
            ArrayList<ASTNode> tags = new ArrayList<ASTNode>(tagElement.fragments());
            tags.removeIf(f -> !(f instanceof TagElement) || !((TagElement)f).isNested());
            tags.removeIf(f -> f.getStartPosition() > endPos || f.getStartPosition() + f.getLength() < this.ctm.get((int)this.formatCodeOpenTagEndIndex).originalStart);
            if (!tags.isEmpty()) {
                this.disableFormatting(this.formatCodeOpenTagEndIndex, startIndex, true);
                String AT_CODE = "@code";
                String src = this.ctm.getSource();
                tags.removeIf(f -> !((TagElement)f).getTagName().equals(AT_CODE));
                for (ASTNode tagNode : tags) {
                    TagElement tag = (TagElement)tagNode;
                    if (!tag.getTagName().equals(AT_CODE)) continue;
                    int nameEndPos = src.indexOf(AT_CODE, tag.getStartPosition()) + AT_CODE.length() - 1;
                    int closingBracePos = tag.getStartPosition() + 1;
                    int braces = 1;
                    while (braces > 0 && closingBracePos < src.length()) {
                        if (src.charAt(closingBracePos) == '{') {
                            ++braces;
                        }
                        if (src.charAt(closingBracePos) == '}') {
                            --braces;
                        }
                        ++closingBracePos;
                    }
                    if (!this.formatCode(this.tokenEndingAt(nameEndPos), this.tokenStartingAt(--closingBracePos), false)) continue;
                    int closingIndex = this.tokenStartingAt(closingBracePos);
                    Token t = this.ctm.get(closingIndex);
                    this.commentStructure.set(closingIndex, new Token(t, t.originalStart, t.originalEnd, 1003));
                    boolean allowAnnotationAtLineStart = CompilerOptions.versionToJdkLevel((String)this.sourceLevel) > CompilerOptions.versionToJdkLevel((String)"14");
                    int i = this.tokenEndingAt(nameEndPos) + 1;
                    while (i < closingIndex) {
                        t = this.ctm.get(i);
                        if (this.ctm.charAt(t.originalStart) == '@') {
                            if (allowAnnotationAtLineStart) {
                                t.setToEscape(false);
                            } else {
                                t.clearLineBreaksBefore();
                                t.spaceBefore();
                                this.ctm.get(i - 1).clearLineBreaksAfter();
                            }
                        }
                        ++i;
                    }
                }
            } else if (this.formatCodeOpenTagEndIndex >= startIndex - 1 || !this.formatCode(this.formatCodeOpenTagEndIndex, startIndex, false)) {
                this.disableFormattingExclusively(this.formatCodeOpenTagEndIndex, startIndex);
            }
            this.formatCodeOpenTagEndIndex = -1;
            this.lastFormatCodeClosingTagIndex = this.ctm.findIndex(startPos, -1, true);
        }
    }

    private void handleSnippet(TagElement node, int startIndex, int endIndex) {
        Token startToken = this.ctm.get(startIndex);
        Token endToken = this.ctm.get(endIndex);
        startToken.breakBefore();
        endToken.breakAfter();
        String lang = null;
        boolean isInline = false;
        int snippetTextStartPos = startToken.originalEnd + 1;
        String snippetText = this.ctm.getSource().substring(snippetTextStartPos, endToken.originalEnd + 1);
        Matcher m = SNIPPET_ATTRIBUTES_PATTERN.matcher(snippetText);
        if (m.find() && m.start() == 0) {
            isInline = !m.group("colon").isEmpty();
            Matcher m2 = SNIPPET_ATTRIBUTE_PATTERN.matcher(snippetText);
            while (m2.find()) {
                this.handleFoundAssignment(m2, 2, snippetTextStartPos);
                this.handleFoundStringLiteral(m2, 3, snippetTextStartPos);
                if (!m2.group(1).equals("lang")) continue;
                lang = m2.group(3);
            }
        }
        List fragments = node.fragments();
        if (isInline && !fragments.isEmpty()) {
            boolean formatted;
            int openingIndex = this.ctm.firstIndexBefore((ASTNode)fragments.get(0), -1);
            int closingIndex = this.tokenStartingAt(endToken.originalEnd);
            this.ctm.get(closingIndex).breakBefore();
            boolean bl = formatted = (lang == null || lang.matches("['\"]?java['\"]?")) && this.formatCode(openingIndex, closingIndex, true);
            if (!formatted) {
                this.disableFormattingExclusively(openingIndex, closingIndex);
            }
        }
    }

    private void fixJavadocTagAlign(Token baseToken, int fixFirstIndex) {
        int i = fixFirstIndex;
        while (i < this.ctm.size() - 1) {
            Token token = this.ctm.get(i);
            if (token.getAlign() == 0 && token.getIndent() == 0) break;
            token.setAlign(baseToken.getAlign());
            token.setIndent(baseToken.getIndent());
            ++i;
        }
    }

    private void disableFormatting(int startIndex, int endIndex, boolean isHtml) {
        Token startToken = this.ctm.get(startIndex);
        Token endToken = this.ctm.get(endIndex);
        Token noFormatToken = new Token(startToken.originalStart, endToken.originalEnd, 1003);
        List<Token> lines = this.commentToLines(noFormatToken, this.findCommentLineIndent(startIndex));
        for (Token line : lines) {
            line.setToEscape(isHtml);
        }
        Token first = lines.get(0);
        if (startToken.isSpaceBefore()) {
            first.spaceBefore();
        }
        first.setAlign(startToken.getAlign());
        first.setIndent(startToken.getIndent());
        first.putLineBreaksBefore(startToken.getLineBreaksBefore());
        first.setWrapPolicy(startToken.getWrapPolicy());
        Token last = lines.get(lines.size() - 1);
        last.putLineBreaksAfter(endToken.getLineBreaksAfter());
        this.fixJavadocTagAlign(startToken, endIndex + 1);
        List<Token> tokensToReplace = this.commentStructure.subList(startIndex, endIndex + 1);
        tokensToReplace.clear();
        tokensToReplace.addAll(lines);
    }

    private void disableFormattingExclusively(int openingTagIndex, int closingTagIndex) {
        Token openingTag = this.ctm.get(openingTagIndex);
        int noFormatStart = openingTag.originalEnd + 1;
        int noFormatEnd = this.ctm.get((int)(closingTagIndex - 1)).originalEnd;
        if (noFormatStart <= noFormatEnd) {
            Token noFormatToken = new Token(noFormatStart, noFormatEnd, 1003);
            List<Token> lines = this.commentToLines(noFormatToken, this.findCommentLineIndent(openingTagIndex));
            for (Token line : lines) {
                line.setToEscape(true);
            }
            this.fixJavadocTagAlign(openingTag, closingTagIndex);
            List<Token> tokensToReplace = this.commentStructure.subList(openingTagIndex + 1, closingTagIndex);
            tokensToReplace.clear();
            tokensToReplace.addAll(lines);
        } else {
            this.commentStructure.subList(openingTagIndex + 1, closingTagIndex).clear();
            Token closingTag = this.ctm.get(closingTagIndex);
            if (this.ctm.countLineBreaksBetween(openingTag, closingTag) == 0) {
                openingTag.clearLineBreaksAfter();
                closingTag.clearLineBreaksBefore();
            }
        }
    }

    private int findCommentLineIndent(int commentFragmentIndex) {
        int position;
        int lastNonWhitespace = position = this.ctm.get((int)commentFragmentIndex).originalStart;
        while (--position > 0) {
            char c = this.ctm.charAt(position);
            if (c == '\r' || c == '\n') break;
            if (ScannerHelper.isWhitespace((char)c)) continue;
            lastNonWhitespace = position;
        }
        if (lastNonWhitespace > 0 && this.ctm.charAt(lastNonWhitespace - 1) == ' ') {
            --lastNonWhitespace;
        }
        return this.ctm.getLength(position, lastNonWhitespace - 1, 0);
    }

    private int tokenStartingAt(int start) {
        int tokenIndex = this.ctm.findIndex(start, -1, false);
        Token token = this.ctm.get(tokenIndex);
        if (token.originalStart == start) {
            return tokenIndex;
        }
        assert (start > token.originalStart && start <= token.originalEnd);
        this.splitToken(token, tokenIndex, start);
        return tokenIndex + 1;
    }

    private int tokenEndingAt(int end) {
        int tokenIndex = this.ctm.findIndex(end, -1, true);
        Token token = this.ctm.get(tokenIndex);
        if (token.originalEnd == end) {
            return tokenIndex;
        }
        assert (end < token.originalEnd && end >= token.originalStart);
        this.splitToken(token, tokenIndex, end + 1);
        return tokenIndex;
    }

    private void splitToken(Token token, int tokenIndex, int splitPosition) {
        assert (splitPosition > token.originalStart && splitPosition <= token.originalEnd);
        Token part1 = new Token(token.originalStart, splitPosition - 1, token.tokenType);
        Token part2 = new Token(splitPosition, token.originalEnd, token.tokenType);
        if (token.isSpaceBefore()) {
            part1.spaceBefore();
        }
        part1.putLineBreaksBefore(token.getLineBreaksBefore());
        part2.putLineBreaksAfter(token.getLineBreaksAfter());
        part1.setIndent(token.getIndent());
        part2.setIndent(token.getIndent());
        part1.setAlign(token.getAlign());
        part2.setAlign(token.getAlign());
        part1.setWrapPolicy(token.getWrapPolicy());
        this.commentStructure.set(tokenIndex, part1);
        this.commentStructure.add(tokenIndex + 1, part2);
    }

    private boolean tokenizeMultilineComment(Token commentToken) {
        boolean newLinesAtBoundries;
        if (this.allowSubstituteWrapping == null || this.allowSubstituteWrapping.length < commentToken.countChars()) {
            this.allowSubstituteWrapping = new boolean[commentToken.countChars()];
        }
        boolean isJavadoc = commentToken.tokenType == 1003;
        Arrays.fill(this.allowSubstituteWrapping, 0, commentToken.countChars(), !isJavadoc);
        boolean cleanBlankLines = isJavadoc ? this.options.comment_clear_blank_lines_in_javadoc_comment : this.options.comment_clear_blank_lines_in_block_comment;
        ArrayList<Token> structure = new ArrayList<Token>();
        int firstTokenEnd = commentToken.originalStart + 1;
        while (firstTokenEnd < commentToken.originalEnd - 1 && this.tm.charAt(firstTokenEnd + 1) == '*') {
            ++firstTokenEnd;
        }
        Token first = new Token(commentToken.originalStart, firstTokenEnd, commentToken.tokenType);
        first.spaceAfter();
        structure.add(first);
        int lastTokenStart = commentToken.originalEnd - 1;
        while (lastTokenStart - 1 > firstTokenEnd && this.tm.charAt(lastTokenStart - 1) == '*') {
            --lastTokenStart;
        }
        int position = firstTokenEnd + 1;
        int lineBreaks = 0;
        block2: while (position <= commentToken.originalEnd) {
            char c;
            int i = position;
            while (i < lastTokenStart) {
                c = this.tm.charAt(i);
                if (c == '\r' || c == '\n') {
                    ++lineBreaks;
                    char c2 = this.tm.charAt(i + 1);
                    if ((c2 == '\r' || c2 == '\n') && c2 != c) {
                        ++i;
                    }
                    position = i + 1;
                } else if (!ScannerHelper.isWhitespace((char)c)) {
                    while (this.tm.charAt(i) == '*' && lineBreaks > 0) {
                        ++i;
                    }
                    position = i;
                    break;
                }
                ++i;
            }
            int tokenStart = position;
            while (position <= commentToken.originalEnd + 1) {
                c = '\u0000';
                if (position == commentToken.originalEnd + 1 || position == lastTokenStart || ScannerHelper.isWhitespace((char)(c = this.tm.charAt(position)))) {
                    if (tokenStart < position) {
                        Token outputToken = new Token(tokenStart, position - 1, commentToken.tokenType);
                        outputToken.spaceBefore();
                        if (lineBreaks > 0) {
                            if (cleanBlankLines) {
                                lineBreaks = 1;
                            }
                            if (lineBreaks > 1 || !this.options.join_lines_in_comments) {
                                outputToken.putLineBreaksBefore(lineBreaks);
                            }
                        }
                        if (this.tm.charAt(tokenStart) == '@') {
                            outputToken.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
                            if (commentToken.tokenType == 1002 && lineBreaks == 1 && structure.size() > 1) {
                                outputToken.putLineBreaksBefore(cleanBlankLines ? 1 : 2);
                            }
                            if (lineBreaks > 0 && this.isCommonsAttributeAnnotation(this.tm.toString(outputToken))) {
                                outputToken.breakBefore();
                                this.commonAttributeAnnotations.add(structure.size());
                            }
                        }
                        structure.add(outputToken);
                        lineBreaks = 0;
                    }
                    if (c == '\r' || c == '\n') continue block2;
                    tokenStart = position == lastTokenStart ? position : position + 1;
                }
                ++position;
            }
        }
        Token last = (Token)structure.get(structure.size() - 1);
        boolean bl = newLinesAtBoundries = commentToken.tokenType == 1003 ? this.options.comment_new_lines_at_javadoc_boundaries : this.options.comment_new_lines_at_block_boundaries;
        if (!newLinesAtBoundries) {
            ((Token)structure.get(1)).clearLineBreaksBefore();
            last.clearLineBreaksBefore();
        } else if (this.tm.countLineBreaksBetween(first, last) > 0) {
            first.breakAfter();
            last.breakBefore();
        }
        last.setAlign(1);
        if (structure.size() == 2) {
            return false;
        }
        commentToken.setInternalStructure(structure);
        return true;
    }

    private boolean isCommonsAttributeAnnotation(String tokenContent) {
        return tokenContent.startsWith("@@");
    }

    private void noSubstituteWrapping(int from, int to) {
        int commentStart = this.ctm.get((int)0).originalStart;
        assert (commentStart <= from && from <= to && to <= this.ctm.get((int)(this.ctm.size() - 1)).originalEnd);
        Arrays.fill(this.allowSubstituteWrapping, from - commentStart, to - commentStart + 1, false);
    }

    private void addSubstituteWraps() {
        Token previous = this.ctm.get(0);
        int commentStart = previous.originalStart;
        int i = 1;
        while (i < this.ctm.size() - 1) {
            boolean touchesPrevious;
            Token token = this.ctm.get(i);
            boolean bl = touchesPrevious = token.originalStart == this.ctm.get((int)(i - 1)).originalEnd + 1;
            if (touchesPrevious && token.getLineBreaksBefore() == 0 && previous.getLineBreaksAfter() == 0 && token.getWrapPolicy() == null) {
                boolean allowWrap = this.allowSubstituteWrapping[token.originalStart - commentStart];
                token.setWrapPolicy(allowWrap ? Token.WrapPolicy.SUBSTITUTE_ONLY : Token.WrapPolicy.DISABLE_WRAP);
            }
            int pos = token.originalStart + 1;
            while (pos < token.originalEnd) {
                char c;
                if (this.allowSubstituteWrapping[pos - commentStart] && !ScannerHelper.isJavaIdentifierPart((char)(c = this.ctm.charAt(pos)))) {
                    this.ctm.get(this.tokenStartingAt(pos)).setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                    this.ctm.get(this.tokenStartingAt(pos + 1)).setWrapPolicy(Token.WrapPolicy.SUBSTITUTE_ONLY);
                }
                ++pos;
            }
            previous = token;
            ++i;
        }
    }

    private boolean formatCode(int openingIndex, int closingIndex, boolean snippetTag) {
        int codeStartPosition = this.ctm.get((int)openingIndex).originalEnd + 1;
        int codeEndPosition = this.ctm.get((int)closingIndex).originalStart - 1;
        StringBuilder codeBuilder = new StringBuilder(codeEndPosition - codeStartPosition + 1);
        int[] positionMapping = new int[codeEndPosition - codeStartPosition + 1];
        this.getCodeToFormat(codeStartPosition, codeEndPosition, codeBuilder, positionMapping);
        DefaultCodeFormatter formatter = snippetTag ? this.getSnippetCodeFormatter() : this.getPreTagCodeFormatter();
        List<Token> formattedTokens = formatter.prepareFormattedCode(codeBuilder.toString());
        if (formattedTokens == null) {
            return false;
        }
        formattedTokens = this.translateFormattedTokens(codeStartPosition, formattedTokens, positionMapping, null);
        Token openingToken = this.ctm.get(openingIndex);
        for (Token token : formattedTokens) {
            token.setAlign(token.getAlign() + openingToken.getAlign() + openingToken.getIndent());
        }
        this.fixJavadocTagAlign(openingToken, closingIndex);
        Token start = formattedTokens.get(0);
        start.putLineBreaksBefore(start.getLineBreaksBefore() + 1);
        Token end = formattedTokens.get(formattedTokens.size() - 1);
        end.putLineBreaksAfter(end.getLineBreaksAfter() + 1);
        this.ctm.get(closingIndex).clearLineBreaksBefore();
        List<Token> tokensToReplace = this.commentStructure.subList(openingIndex + 1, closingIndex);
        tokensToReplace.clear();
        tokensToReplace.addAll(formattedTokens);
        return true;
    }

    private DefaultCodeFormatter getPreTagCodeFormatter() {
        if (this.preTagCodeFormatter == null) {
            Map<String, String> options2 = this.options.getMap();
            options2.put("org.eclipse.jdt.core.formatter.comment.line_length", String.valueOf(this.options.comment_line_length - this.commentIndent - 3));
            options2.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(this.options.page_width - this.commentIndent - 3));
            options2.put("org.eclipse.jdt.core.compiler.source", this.sourceLevel);
            this.preTagCodeFormatter = new DefaultCodeFormatter(options2);
        }
        return this.preTagCodeFormatter;
    }

    private DefaultCodeFormatter getSnippetCodeFormatter() {
        if (this.snippetCodeFormatter == null) {
            Map<String, String> options2 = this.options.getMap();
            options2.put("org.eclipse.jdt.core.formatter.comment.preserve_white_space_between_code_and_line_comments", "true");
            options2.put("org.eclipse.jdt.core.formatter.comment.line_length", String.valueOf(10000));
            options2.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(this.options.page_width - this.commentIndent - 3));
            options2.put("org.eclipse.jdt.core.compiler.source", this.sourceLevel);
            this.snippetCodeFormatter = new DefaultCodeFormatter(options2);
        }
        return this.snippetCodeFormatter;
    }

    private void getCodeToFormat(int startPos, int endPos, StringBuilder sb, int[] posMapping) {
        char c2;
        int position = 0;
        char c = this.ctm.charAt(position + startPos);
        if (c == '\r' || c == '\n') {
            posMapping[position++] = sb.length() - 1;
            c2 = this.ctm.charAt(position + startPos);
            if ((c2 == '\r' || c2 == '\n') && c2 != c) {
                posMapping[position++] = sb.length() - 1;
            }
        }
        while (position + startPos <= endPos) {
            int lineStart;
            int i = lineStart = position + startPos;
            while (true) {
                if ((c = this.ctm.charAt(i)) == '\r' || c == '\n') {
                    sb.append(c);
                    lineStart = i + 1;
                } else if (!ScannerHelper.isWhitespace((char)c)) {
                    if (c != '*') break;
                    lineStart = this.ctm.charAt(i + 1) == ' ' ? i + 2 : i + 1;
                    break;
                }
                ++i;
            }
            int lineEnd = endPos + 1;
            int i2 = lineStart;
            while (i2 <= endPos) {
                c = this.ctm.charAt(i2);
                if (c == '\r' || c == '\n') {
                    lineEnd = i2;
                    break;
                }
                ++i2;
            }
            while (position + startPos < lineStart) {
                posMapping[position++] = sb.length() - 1;
            }
            int htmlEntityStart = -1;
            int i3 = lineStart;
            while (i3 < lineEnd) {
                c = this.ctm.charAt(i3);
                sb.append(c);
                posMapping[position++] = sb.length() - 1;
                if (c == '&') {
                    htmlEntityStart = i3;
                } else if (c == ';' && htmlEntityStart >= 0) {
                    char replacementChar = this.getHtmlEntityChar(this.ctm.getSource().substring(htmlEntityStart, i3 + 1));
                    if (replacementChar != '\u0000') {
                        sb.setLength(sb.length() - (i3 + 1 - htmlEntityStart));
                        sb.append(replacementChar);
                        int k = position - (i3 + 1 - htmlEntityStart);
                        while (k < position) {
                            posMapping[k] = sb.length() - 1;
                            ++k;
                        }
                    }
                    htmlEntityStart = -1;
                }
                ++i3;
            }
        }
        while (sb.length() > 0 && ((c = sb.charAt(sb.length() - 1)) == ' ' || c == '\t')) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (sb.length() > 0 && ((c = sb.charAt(sb.length() - 1)) == '\r' || c == '\n')) {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() > 0 && ((c2 = sb.charAt(sb.length() - 1)) == '\r' || c2 == '\n') && c2 != c) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
    }

    private char getHtmlEntityChar(String entity) {
        Matcher matcher = HTML_ENTITY_PATTERN.matcher(entity);
        if (matcher.find()) {
            char replaceChar = '\u0000';
            int i = 1;
            while (i < HTML_ENTITY_REPLACE.length()) {
                int end;
                int start = matcher.start(i);
                if (start != (end = matcher.end(i))) {
                    if (replaceChar != '\u0000') {
                        return '\u0000';
                    }
                    switch (i) {
                        case 1: {
                            replaceChar = (char)Integer.parseInt(entity.substring(start + 2, end), 16);
                            break;
                        }
                        case 2: {
                            replaceChar = (char)Integer.parseInt(entity.substring(start + 1, end), 10);
                            break;
                        }
                        default: {
                            replaceChar = HTML_ENTITY_REPLACE.charAt(i);
                        }
                    }
                }
                ++i;
            }
            return replaceChar;
        }
        return '\u0000';
    }

    private List<Token> translateFormattedTokens(int startPosition, List<Token> formattedTokens, int[] positionMapping, HashMap<Token, Token> translationMap) {
        int previousLineBreaks = 0;
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token token : formattedTokens) {
            int newStart = Arrays.binarySearch(positionMapping, token.originalStart);
            while (newStart > 0 && positionMapping[newStart - 1] == token.originalStart) {
                --newStart;
            }
            int newEnd = Arrays.binarySearch(positionMapping, token.originalEnd);
            while (newEnd + 1 < positionMapping.length && positionMapping[newEnd + 1] == token.originalEnd) {
                ++newEnd;
            }
            Token translated = new Token(token, newStart + startPosition, newEnd + startPosition, token.tokenType);
            if (translated.getWrapPolicy() == null) {
                translated.setWrapPolicy(Token.WrapPolicy.DISABLE_WRAP);
            }
            if (token.hasNLSTag()) {
                Token translatedNLS;
                if (translationMap == null) {
                    translationMap = new HashMap();
                }
                if ((translatedNLS = translationMap.get(token.getNLSTag())) != null) {
                    translatedNLS.setNLSTag(translated);
                    translated.setNLSTag(translatedNLS);
                } else {
                    translationMap.put(token, translated);
                }
            }
            int lineBreaks = Math.max(previousLineBreaks, token.getLineBreaksBefore());
            List<Token> structure = token.getInternalStructure();
            if (structure != null && !structure.isEmpty()) {
                translated.setInternalStructure(this.translateFormattedTokens(startPosition, structure, positionMapping, translationMap));
            }
            translated.putLineBreaksBefore(lineBreaks);
            translated.setToEscape(true);
            result.add(translated);
            previousLineBreaks = token.getLineBreaksAfter();
        }
        ((Token)result.get(result.size() - 1)).putLineBreaksAfter(previousLineBreaks);
        return result;
    }

    public void finishUp() {
        if (this.lastFormatOffComment != null) {
            this.tm.addDisableFormatTokenPair(this.lastFormatOffComment, this.tm.get(this.tm.size() - 1));
        }
    }
}

