/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.shared.utils.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.lsp4j.MessageType;

public class CreateModuleInfoHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String createModuleInfo(String projectUri, IProgressMonitor monitor) {
        IProject project = ProjectUtils.getProjectFromUri(projectUri);
        if (!ProjectUtils.isJavaProject(project)) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "The selected project is not a valid Java project.");
            return null;
        }
        final IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!JavaModelUtil.is9OrHigher((IJavaProject)javaProject)) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "The project source compliance must be 9 or higher to create module-info.java.");
            return null;
        }
        try {
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
            ArrayList<IPackageFragmentRoot> packageFragmentRootsAsList = new ArrayList<IPackageFragmentRoot>(Arrays.asList(packageFragmentRoots));
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
            int n = packageFragmentRoots.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    packageFragmentRoots = packageFragmentRootsAsList.toArray(new IPackageFragmentRoot[packageFragmentRootsAsList.size()]);
                    if (packageFragmentRoots.length != 0) break;
                    JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "No source folder exists in the project.");
                    return null;
                }
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IResource res = packageFragmentRoot.getCorrespondingResource();
                if (res == null || res.getType() != 2 || packageFragmentRoot.getKind() != 1) {
                    packageFragmentRootsAsList.remove(packageFragmentRoot);
                }
                ++n2;
            }
            IPackageFragmentRoot targetPkgFragmentRoot = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray2 = packageFragmentRoots;
            int n3 = packageFragmentRoots.length;
            n = 0;
            while (true) {
                if (n >= n3) {
                    if (targetPkgFragmentRoot != null) break;
                    return null;
                }
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray2[n];
                if (packageFragmentRoot.getPackageFragment("").getCompilationUnit("module-info.java").exists()) {
                    JavaLanguageServerPlugin.getInstance().getClientConnection().showNotificationMessage(MessageType.Error, "The module-info.java file already exists in the source folder \"" + packageFragmentRoot.getElementName() + "\"");
                    return null;
                }
                if (targetPkgFragmentRoot == null) {
                    targetPkgFragmentRoot = packageFragmentRoot;
                }
                ++n;
            }
            String moduleInfoUri = CreateModuleInfoHandler.createModuleInfoJava(javaProject, targetPkgFragmentRoot, packageFragmentRoots, monitor);
            if (moduleInfoUri != null) {
                new Job("Update project: " + javaProject.getElementName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            CreateModuleInfoHandler.convertClasspathToModulePath(javaProject, monitor);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            return moduleInfoUri;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return null;
        }
    }

    private static String createModuleInfoJava(IJavaProject javaProject, IPackageFragmentRoot targetPkgFragmentRoot, IPackageFragmentRoot[] packageFragmentRoots, IProgressMonitor monitor) throws CoreException {
        String fileContent = CreateModuleInfoHandler.getModuleInfoFileContent(javaProject, packageFragmentRoots);
        IPackageFragment defaultPkg = targetPkgFragmentRoot.getPackageFragment("");
        ICompilationUnit moduleInfo = defaultPkg.createCompilationUnit("module-info.java", fileContent, true, monitor);
        return moduleInfo.getResource().getLocationURI().toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String getModuleInfoFileContent(IJavaProject javaProject, IPackageFragmentRoot[] packageFragmentRoots) throws CoreException {
        int n;
        Object[] objectArray;
        HashSet<String> exportedPackages = new HashSet<String>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
        int n2 = packageFragmentRoots.length;
        int n3 = 0;
        while (n3 < n2) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n3];
            objectArray = packageFragmentRoot.getChildren();
            n = objectArray.length;
            int n4 = 0;
            while (n4 < n) {
                IJavaElement child = objectArray[n4];
                IJavaElement iJavaElement = child;
                if (iJavaElement instanceof IPackageFragment) {
                    void pkgFragment;
                    IPackageFragment cfr_ignored_0 = (IPackageFragment)iJavaElement;
                    IPackageFragment cfr_ignored_1 = (IPackageFragment)iJavaElement;
                    if (!pkgFragment.isDefaultPackage() && pkgFragment.getCompilationUnits().length != 0) {
                        exportedPackages.add(pkgFragment.getElementName());
                    }
                }
                ++n4;
            }
            ++n3;
        }
        String[] requiredModules = JavaCore.getReferencedModules((IJavaProject)javaProject);
        String moduleName = CreateModuleInfoHandler.getModuleName(javaProject);
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)javaProject);
        StringBuilder fileContentBuilder = new StringBuilder();
        fileContentBuilder.append("module ");
        fileContentBuilder.append(moduleName);
        fileContentBuilder.append(" {");
        fileContentBuilder.append(lineDelimiter);
        for (String exportedPkg : exportedPackages) {
            fileContentBuilder.append("\t");
            fileContentBuilder.append("exports ");
            fileContentBuilder.append(exportedPkg);
            fileContentBuilder.append(";");
            fileContentBuilder.append(lineDelimiter);
        }
        objectArray = requiredModules;
        n = requiredModules.length;
        int n5 = 0;
        while (n5 < n) {
            IJavaElement requiredModule = objectArray[n5];
            fileContentBuilder.append("\t");
            fileContentBuilder.append("requires ");
            fileContentBuilder.append((String)requiredModule);
            fileContentBuilder.append(";");
            fileContentBuilder.append(lineDelimiter);
            ++n5;
        }
        fileContentBuilder.append("}");
        fileContentBuilder.append(lineDelimiter);
        String fileContent = fileContentBuilder.toString();
        Map options = javaProject.getOptions(true);
        String formattedContent = CodeFormatterUtil.format((int)128, (String)fileContent, (int)0, (String)lineDelimiter, (Map)options);
        return formattedContent;
    }

    private static String getModuleName(IJavaProject javaProject) {
        String moduleName = CreateModuleInfoHandler.convertToModuleName(javaProject.getElementName());
        IStatus status = JavaConventionsUtil.validateModuleName((String)moduleName, (IJavaElement)javaProject);
        if (status == JavaModelStatus.VERIFIED_OK) {
            return moduleName;
        }
        return "module.name";
    }

    public static String convertToModuleName(String name) {
        Pattern invalidChars = Pattern.compile("[^A-Za-z0-9]");
        name = invalidChars.matcher(name).replaceAll(".");
        Pattern continuousDots = Pattern.compile("\\.{2,}");
        name = continuousDots.matcher(name).replaceAll(".");
        name = StringUtils.stripStart((String)name, (String)".");
        name = StringUtils.stripEnd((String)name, (String)".");
        return name;
    }

    private static void convertClasspathToModulePath(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        boolean changed = false;
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 2: 
                case 5: {
                    IClasspathAttribute[] newAttributes = CreateModuleInfoHandler.addModuleAttributeIfNeeded(entry.getExtraAttributes());
                    if (newAttributes == null) break;
                    rawClasspath[i] = CreateModuleInfoHandler.addAttributes(entry, newAttributes);
                    changed = true;
                }
            }
            ++i;
        }
        if (changed) {
            javaProject.setRawClasspath(rawClasspath, monitor);
        }
    }

    private static IClasspathAttribute[] addModuleAttributeIfNeeded(IClasspathAttribute[] extraAttributes) {
        int j = 0;
        while (j < extraAttributes.length) {
            IClasspathAttribute classpathAttribute = extraAttributes[j];
            if ("module".equals(classpathAttribute.getName())) {
                if ("true".equals(classpathAttribute.getValue())) {
                    return null;
                }
                extraAttributes[j] = JavaCore.newClasspathAttribute((String)"module", (String)"true");
                return extraAttributes;
            }
            ++j;
        }
        extraAttributes = Arrays.copyOf(extraAttributes, extraAttributes.length + 1);
        extraAttributes[extraAttributes.length - 1] = JavaCore.newClasspathAttribute((String)"module", (String)"true");
        return extraAttributes;
    }

    private static IClasspathEntry addAttributes(IClasspathEntry entry, IClasspathAttribute[] extraAttributes) {
        switch (entry.getEntryKind()) {
            case 5: {
                return JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])extraAttributes, (boolean)entry.isExported());
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])extraAttributes, (boolean)entry.isExported());
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (boolean)entry.combineAccessRules(), (IClasspathAttribute[])extraAttributes, (boolean)entry.isExported());
            }
        }
        return entry;
    }
}

