/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.makestatic;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.code.makestatic.FinalConditionsChecker;

public final class InstanceUsageRewriter
extends ASTVisitor {
    public boolean fTargetMethodhasInstanceUsage;
    private final String fParamName;
    private final ASTRewrite fRewrite;
    private final AST fAst;
    private final MethodDeclaration fTargetMethodDeclaration;
    private FinalConditionsChecker fFinalConditionsChecker;

    public InstanceUsageRewriter(String paramName, ASTRewrite rewrite, AST ast, MethodDeclaration methodDeclaration, FinalConditionsChecker finalConditionsChecker) {
        this.fParamName = paramName;
        this.fRewrite = rewrite;
        this.fAst = ast;
        this.fTargetMethodDeclaration = methodDeclaration;
        this.fFinalConditionsChecker = finalConditionsChecker;
    }

    public boolean getTargetMethodhasInstanceUsage() {
        return this.fTargetMethodhasInstanceUsage;
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            this.modifyFieldUsage(node, binding);
        } else if (binding instanceof IMethodBinding) {
            this.modifyInstanceMethodUsage(node, binding);
        }
        return super.visit(node);
    }

    public boolean visit(ThisExpression node) {
        IBinding qualifierBinding;
        ITypeBinding typeBinding;
        ASTNode parentNode = node.getParent();
        Name qualifier = node.getQualifier();
        if (qualifier != null ? this.isInsideAnonymousClass(typeBinding = (ITypeBinding)(qualifierBinding = qualifier.resolveBinding())) : this.parentIsAnonymousClass(parentNode)) {
            return super.visit(node);
        }
        this.replaceThisExpression(node);
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        ITypeBinding typeBinding = node.getType().resolveBinding();
        if (typeBinding != null && typeBinding.isMember() && !Modifier.isStatic((int)typeBinding.getModifiers())) {
            this.fTargetMethodhasInstanceUsage = true;
            this.replaceClassInstanceCreation(node);
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodInvocation node) {
        this.fFinalConditionsChecker.checkNodeIsNoSuperMethodInvocation();
        return super.visit(node);
    }

    private void modifyFieldUsage(SimpleName node, IBinding binding) {
        IVariableBinding variableBinding = (IVariableBinding)binding;
        ITypeBinding declaringClass = variableBinding.getDeclaringClass();
        if (this.isInsideAnonymousClass(declaringClass)) {
            return;
        }
        if (variableBinding.isField() && !Modifier.isStatic((int)variableBinding.getModifiers())) {
            ASTNode parent = node.getParent();
            if (this.isConcatenatedFieldAccessOrQualifiedName(node, parent)) {
                return;
            }
            this.replaceFieldAccess(node, parent);
            this.fTargetMethodhasInstanceUsage = true;
        }
    }

    private void modifyInstanceMethodUsage(SimpleName node, IBinding binding) {
        IMethodBinding methodBinding = (IMethodBinding)binding;
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        if (this.isInsideAnonymousClass(declaringClass)) {
            return;
        }
        if (!Modifier.isStatic((int)methodBinding.getModifiers())) {
            this.fTargetMethodhasInstanceUsage = true;
            this.fFinalConditionsChecker.checkIsNotRecursive(node, this.fTargetMethodDeclaration);
            this.replaceMethodInvocation(node);
        }
    }

    private boolean isInsideAnonymousClass(ITypeBinding declaringClass) {
        if (declaringClass != null) {
            boolean isLocal = declaringClass.isLocal();
            boolean isAnonymous = declaringClass.isAnonymous();
            boolean isMember = declaringClass.isMember();
            boolean isNested = declaringClass.isNested();
            boolean isTopLevel = declaringClass.isTopLevel();
            if (!isTopLevel || isNested || isAnonymous || isLocal || isMember) {
                return true;
            }
        }
        return false;
    }

    private boolean isConcatenatedFieldAccessOrQualifiedName(SimpleName node, ASTNode parent) {
        QualifiedName qualifiedName;
        FieldAccess fieldAccess;
        return parent instanceof FieldAccess ? (fieldAccess = (FieldAccess)parent).getExpression() != node : parent instanceof QualifiedName && (qualifiedName = (QualifiedName)parent).getQualifier() != node;
    }

    private void replaceFieldAccess(SimpleName node, ASTNode parent) {
        FieldAccess replacement = this.fAst.newFieldAccess();
        replacement.setExpression((Expression)this.fAst.newSimpleName(this.fParamName));
        replacement.setName(this.fAst.newSimpleName(node.getIdentifier()));
        this.fFinalConditionsChecker.checkMethodNotUsingSuperFieldAccess(parent);
        if (parent instanceof SuperFieldAccess) {
            this.fRewrite.replace(parent, (ASTNode)replacement, null);
        } else {
            this.fRewrite.replace((ASTNode)node, (ASTNode)replacement, null);
        }
    }

    private void replaceMethodInvocation(SimpleName node) {
        MethodInvocation methodInvocation;
        Expression optionalExpression;
        ASTNode parent = node.getParent();
        SimpleName replacementExpression = this.fAst.newSimpleName(this.fParamName);
        if (parent instanceof MethodInvocation && (optionalExpression = (methodInvocation = (MethodInvocation)parent).getExpression()) == null) {
            this.fRewrite.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)replacementExpression, null);
        }
    }

    private boolean parentIsAnonymousClass(ASTNode parentNode) {
        while (parentNode != null) {
            if (parentNode instanceof AnonymousClassDeclaration) {
                return true;
            }
            parentNode = parentNode.getParent();
        }
        return false;
    }

    private void replaceThisExpression(ThisExpression node) {
        this.fTargetMethodhasInstanceUsage = true;
        SimpleName replacement = this.fAst.newSimpleName(this.fParamName);
        this.fRewrite.replace((ASTNode)node, (ASTNode)replacement, null);
    }

    private void replaceClassInstanceCreation(ClassInstanceCreation node) {
        ClassInstanceCreation replacement = this.fAst.newClassInstanceCreation();
        replacement.setType((Type)ASTNode.copySubtree((AST)this.fAst, (ASTNode)node.getType()));
        replacement.setExpression((Expression)this.fAst.newSimpleName(this.fParamName));
        for (Object arg : node.arguments()) {
            replacement.arguments().add(ASTNode.copySubtree((AST)this.fAst, (ASTNode)((Expression)arg)));
        }
        this.fRewrite.replace((ASTNode)node, (ASTNode)replacement, null);
    }
}

